<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <base href="/">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo e($conf->company_name); ?></title>


        <?php if(isset($product) && $product!=null): ?>
            <meta property="og:title" content="<?php echo e($product->title); ?>"/>
            <meta property="og:description" content="<?php echo e($product->description); ?>"/>
            <meta property="og:type" content="website"/>
            <meta property="og:url" content="<?php echo e(url("/detailed/".$product->id)); ?>"/>
            <meta property="og:image" content="<?php echo e($product->image); ?>"/>
        <?php else: ?>
            <meta property="og:title" content="Manshop"/>
            <meta property="og:description" content="Website description"/>
            <meta property="og:type" content="website"/>
            <meta property="og:url" content=<?php echo e(url("/")); ?>/>
            <meta property="og:image" content="http://shop.mangosoft.mk/storage/images/1/logo/logo.jpg"/>
        <?php endif; ?>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">
        <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" media="screen" />
        <!-- Styles -->

        <style>
            html, body {
                background-color: #fff;
                color: #636b6f;
                font-family: 'Nunito', sans-serif;
                font-weight: 200;
                height: 100vh;
                margin: 0;
            }

            .full-height {
                height: 100vh;
            }

            .flex-center {
                align-items: center;
                display: flex;
                justify-content: center;
            }

            .position-ref {
                position: relative;
            }

            .top-right {
                position: absolute;
                right: 10px;
                top: 18px;
            }

            .content {
                text-align: center;
            }

            .title {
                font-size: 0;
            }

            .links > a {
                color: #636b6f;
                padding: 0 25px;
                font-size: 13px;
                font-weight: 600;
                letter-spacing: .1rem;
                text-decoration: none;
                text-transform: uppercase;
            }

            .m-b-md {
                margin-bottom: 30px;
            }
        </style>
        <!--====== Favicon Icon ======-->
        <link rel="shortcut icon" href="<?php echo e($conf->logo); ?>" type="image/png">

        <!--====== Animate CSS ======-->
        <link rel="stylesheet" href="assets/css/animate.css">

        <!--====== Magnific Popup CSS ======-->
        <link rel="stylesheet" href="assets/css/magnific-popup.css">

        <!--====== Slick CSS ======-->
        <link rel="stylesheet" href="assets/css/slick.css">

        <!--====== Font Awesome CSS ======-->
        <link rel="stylesheet" href="assets/css/fontawesome.min.css">

        <!--====== Brusher Font CSS ======-->
        <link rel="stylesheet" href="assets/css/brusher-fornt.css">

        <!--====== Flat Icon CSS ======-->
        <link rel="stylesheet" href="assets/css/flaticon.css">

        <!--====== Ico Font Icon CSS ======-->
        <link rel="stylesheet" href="assets/css/icofont.min.css">

        <!--====== Jquery Ui CSS ======-->
        <link rel="stylesheet" href="assets/css/jquery-ui.min.css">

        <!--====== Bootstrap CSS ======-->
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">

        <!--====== Default CSS ======-->
        <link rel="stylesheet" href="assets/css/default.css">

        <!--====== Style CSS ======-->
        <link rel="stylesheet" href="assets/css/style.css">

    </head>
    <body style="background: transparent">
        <div class="position-ref full-height">
                <?php if(auth()->guard()->check()): ?>
                    <div id="myExp">
                        <MainApp id="authenticatedToken" data="<?php echo e(auth()->user()->token); ?>" logged="true" url="<?php echo e(url('/')); ?>" conf="<?php echo e($conf); ?>"/>
                    </div>
                <?php else: ?>
                    <div id="myExp">
                        <MainApp id="authenticatedToken" data="" logged="false" url="<?php echo e(url('/')); ?>" conf="<?php echo e($conf); ?>"/>
                    </div>

                <?php endif; ?>
        </div>

        <link href="/css/app.css" rel="stylesheet">
        <script src="<?php echo e(asset('/js/app.js')); ?>"></script>

        <!-- Optional: include a polyfill for ES6 Promises for IE11 -->









        <script src="//code.tidio.co/r9o1gzqebekyof4meb4rjnct3kg0nlhm.js" async></script>

    </body>
</html>
<?php /**PATH C:\htdocs\manshop\resources\views/welcome.blade.php ENDPATH**/ ?>