<?php $__env->startSection('content'); ?>
    <div id="main-content">

        <div class="row mt-5" id="manage-orders">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="header">
                        <h2>Orders</h2>

                        <div class="ml-auto">
                            <div class="user-account">
                                <div class="dropdown" style="float: right">
                                    <a href="javascript:void(0);" class="dropdown-toggle user-name" data-toggle="dropdown">Orders per page: {{ paginate }}</a>
                                    <ul class="dropdown-menu dropdown-menu-right account animated flipInY">
                                        <li><a href="javascript:void(0);" v-on:click="changePag(15)">15</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(30)">30</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(45)">45</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(60)">60</a></li>
                                    </ul>
                                </div>
                            </div>
                            <button class="btn btn-dark" :disabled="apiData.prev_page_url === null" v-on:click="prevPage()">
                                Previous Page
                            </button>
                            <button class="btn btn-dark" :disabled="apiData.next_page_url === null" v-on:click="nextPage()">
                                Next Page
                            </button>
                            <input type="text" placeholder="Search User, order id..." class="form-control" v-model="search" v-on:keyUp="getOrders()" style="width: auto !important; display: initial !important;">







                            <div class="spinner-border" role="status" v-if="changePage">
                                <span class="sr-only">Loading...</span>
                            </div>
                        </div>
                    </div>
                    <div class="body">
                        <div class="table-responsive" v-if="orders.length > 0">
                            <table class="table table-hover m-b-0 text-center">
                                <thead class="thead-dark">
                                <tr>
                                    <th>Id</th>
                                    <th>Products</th>
                                    <th>User</th>
                                    <th>Address</th>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Coupon Used</th>
                                    <th>Discount</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(order, i) in orders">
                                    <td>{{ order.id }}</td>
                                    <td v-on:click="modalProds(order)" data-toggle="modal" data-target="#showProducts"><a class="btn btn-link">Click to view</a></td>
                                    <td><span>{{ order.name }}</span></td>
                                    <td><span>{{ order.city }}, {{ order.address }} {{ order.zip }}</span></td>
                                    <td><span>{{ dateStr(order.created_at) }}</span></td>
                                    <td>
                                        <span v-if="order.schedule === 'delivery'">Delivery</span>
                                        <span v-else>Pickup</span>
                                    </td>

                                    <td><span>{{ order.coupon }}</span></td>
                                    <td><span>{{ order.discount }}</span></td>
                                    <td><span>{{ order.sum }}</span></td>
                                    <td>
                                        <span class="badge badge-danger" v-if="order.status === 1">Awaiting</span>
                                        <span class="badge badge-warning" v-if="order.status === 2 && order.schedule ==='delivery'">Order Shipped</span>
                                        <span class="badge badge-warning" v-if="order.status === 2 && order.schedule !=='delivery'">Order Ready for Pickup</span>
                                        <span class="badge badge-success" v-if="order.status === 3">Order Completed</span>
                                    </td>
                                    <td v-if="order.status === 1">
                                        <button type="button" class="btn btn-outline-success" v-if="order.schedule === 'delivery'" v-on:click="makeSelection(order)" data-toggle="modal" data-target="#orderInfo" :disabled="order.id == orderLoading">Order Shipped
                                            <div class="spinner-border" role="status" style="width: 1rem; height: 1rem;"v-if="order.id == orderLoading">
                                                <span class="sr-only"></span>
                                            </div></button>
                                        <button type="button" class="btn btn-outline-success" v-else v-on:click="makeSelection(order)" data-toggle="modal" data-target="#orderInfo"  :disabled="order.id == orderLoading">Ready for Pickup
                                            <div class="spinner-border" role="status" style="width: 1rem; height: 1rem;" v-if="order.id == orderLoading">
                                                <span class="sr-only"></span>
                                            </div></button>
                                    </td>
                                    <td v-if="order.status === 2">
                                        <button type="button" class="btn btn-outline-success" v-on:click="orderReady(order, i, 'admin/completeOrder')" :disabled="order.id == orderLoading">Order Completed
                                            <div class="spinner-border" role="status" style="width: 1rem; height: 1rem;"v-if="order.id == orderLoading">
                                                <span class="sr-only"></span>
                                            </div></button>
                                    </td>
                                    <td v-if="order.status === 3">

                                    </td>

                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div v-else>
                            <h1 class="text-center" style="font-style: italic;">No orders available.</h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="orderInfo" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content" v-if="selectedOrder">
                    <div class="modal-header">
                        <h4 class="title text-center text-primary" id="largeModalLabel">Order Info</h4>
                    </div>
                    <div class="row">
                        <div class="col-12 mt-2">
                            <div class="form-group">
                                <textarea type="string" class="form-control mx-auto" style="height: 150px; max-height: 150px; width: 90%" placeholder="Shipping info, pickup info..."></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-success" v-if="selectedOrder.schedule === 'delivery'" v-on:click="orderReady(selectedOrder, i, 'admin/readyOrder', 'shipped.')" :disabled="selectedOrder.id == orderLoading">Ship Order
                            <div class="spinner-border" role="status" style="width: 1rem; height: 1rem;"v-if="selectedOrder.id == orderLoading">
                                <span class="sr-only"></span>
                            </div></button>
                        <button type="button" class="btn btn-outline-success" v-else v-on:click="orderReady(selectedOrder, i, 'admin/readyOrder','ready for pickup.',)" :disabled="order.id == orderLoading">Ready for Pickup
                            <div class="spinner-border" role="status" style="width: 1rem; height: 1rem;" v-if="order.id == orderLoading">
                                <span class="sr-only"></span>
                            </div></button>
                    </div>
                </div>
            </div>
        </div>
        <!-- Products Modal -->
        <div class="modal fade" id="showProducts" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">



                    <div v-if="modProducts.length > 0">
                        <div class="table-responsive">
                            <table class="table table-hover m-b-0 text-center">
                                <thead class="thead-dark">
                                <tr>
                                    <th>no</th>
                                    <th>Product</th>
                                    <th>Size</th>
                                    <th>Color</th>
                                    <th>Quantity</th>
                                    <th>Price</th>
                                    <th>Total</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr  v-for="(p, i) in modProducts">
                                    <td>{{ i+1 }}</td>
                                    <td><span>{{ p.product.title }}</span></td>
                                    <td><span>{{ p.size.size }}</span></td>
                                    <td><span>{{ p.color.color }}</span></td>
                                    <td><span>{{ p.quantity }}</span></td>
                                    <td><span>{{ p.product.price }}</span></td>
                                    <td><span>{{ p.product.price * p.quantity }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



        <?php $__env->stopSection(); ?>
        <?php $__env->startSection('footer'); ?>
            <script>
                const Vue_comp = new Vue({
                    el:"#main-content",
                    data: {
                        orders: [],
                        apiData: null,
                        changePage: false,
                        link: 'admin/getOrders',
                        paginate: 30,
                        modProducts: [],
                        search: '',
                        orderLoading: 0,
                        selectedOrder: null
                    },
                    created() {
                        this.getOrders();
                    },
                    methods: {
                        capitalizeFirstLetter(string) {
                            return string.charAt(0).toUpperCase() + string.slice(1);
                        },
                        dateStr(d) {
                            // return new Date(d).toDateString();
                            return moment(d).format('DD MMM, YYYY');
                        },
                        getOrders() {
                            const self = this;
                            axios.post(this.link, {number: this.paginate, search: this.search}, {
                                    headers: {
                                        'Content-Type': 'application/json',
                                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                                    },
                                }
                            ).then(function(response){
                                console.log('orders', response)
                                if (response.data.status) {
                                    self.apiData = response.data.values;
                                    self.orders = self.apiData.data;
                                }
                                this.changePage = false;
                            }).catch(function(error){
                                this.changePage = false;
                            });
                        },
                        prevPage() {
                            if (this.apiData && this.apiData.prev_page_url) {
                                // this.changePage = true;
                                this.link = this.apiData.prev_page_url;
                                this.getOrders();
                            }
                        },
                        nextPage() {
                            if (this.apiData && this.apiData.next_page_url) {
                                // this.changePage = true;
                                this.link = this.apiData.next_page_url;
                                this.getOrders();
                            }
                        },
                        changePag(val) {
                            this.paginate = val;
                            this.getOrders();
                        },
                        modalProds(order) {
                            this.modProducts = order.items;
                        },
                        orderReady(order, i, link, msg = null) {
                            const self = this;
                            this.orderLoading = order.id;
                            axios.post(link, {id: order.id}, {
                                    headers: {
                                        'Content-Type': 'application/json',
                                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                                    },
                                }
                            ).then(function(response){
                                self.orderLoading = 0;
                                if (response.data.status) {
                                    let m = '';
                                    if (msg !== null) {
                                        m = 'Order ' + msg;
                                    } else {
                                        m = response.data.message;
                                    }
                                    self.orders[i] = response.data.values;
                                    showToast('success', m);
                                }
                            }).catch(function(error){
                                self.orderLoading = 0;
                                showToast('warning', 'Something went wrong.');
                            });
                        },
                        makeSelection(order) {
                            this.selectedOrder = order;
                        }
                    }
                });
            </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\manshop-SKS\resources\views/admin/Manage/orders.blade.php ENDPATH**/ ?>