<?php $__env->startSection('content'); ?>
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-3">
                                 <p v-if="fileList.length >= 2" style="margin-bottom: 0 !important">Only two horizontal banners allowed.</p>
                                <el-upload
                                    class="upload-demo"
                                    action="https://jsonplaceholder.typicode.com/posts/"
                                    :on-change="handlePreview"
                                    :on-remove="handleRemove"
                                    :auto-upload="false"
                                    :file-list="fileList"
                                    list-type="picture">
                                    <el-button size="small" type="primary"  v-if="fileList.length < 2" :disabled="fileList.length >=2">Click to upload</el-button>
                                    
                                </el-upload>
                            </div>
                            <div class="col-9" >
                                <div class="row banner-desc-input" v-for="(bt, index) in bnrDesc">
                                    <div class="col-9">
                                        <textarea style="resize: none;"  placeholder="Description" class="form-control" v-model = "bnrDesc[index]"></textarea>

                                    </div>
                                    <div class="col-3" v-if="products.length > 0">
                                        <select class="form-control show-tick ms select2" data-placeholder="Select" placeholder="Select Product" name="prod_id" v-model="prodIds[index]" id="prod_id">
                                            <option></option>
                                            <option v-for="p in products" v-bind:value="p.id"> {{ p.title }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12" v-if="bnrDesc.length > 0" >
                                <button class="btn btn-primary" style="float:right;margin-top:30px;" type="button" @click="submitForm">Submit</button>
                            </div>
                        </div>





                    </div>
                </div>
            </div>
        </div>



        <?php $__env->stopSection(); ?>
        <?php $__env->startSection('footer'); ?>

            <script>

                const Vue_comp = new Vue({
                    el:"#main-content",
                    data: {
                        banners: null,
                        products: [],
                        bnrDesc:[],
                        fileList: [],
                        prodIds: []
                    },
                    created() {
                        const self = this;
                        axios.post( 'api/V1/horizontalProducts',{}, {
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                                },
                            }
                        ).then(function(response){
                            self.banners = response.data.values;
                            console.log('prods', self.banners);
                            if(self.banners.length > 0){
                                $.each(self.banners,function (index,value){
                                    self.fileList.push({name: 'horizontal', url: value.image});
                                    self.bnrDesc.push(value.description);
                                    self.prodIds.push(value.prod_id);
                                })
                            }
                        }).catch(function(error){});
                        
                        
                        console.log(this.banners);
                        axios.post( '/admin/getProducts',{}, {
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                                },
                            }
                        ).then(function(response){
                            self.products = response.data.values;
                            console.log('prods', self.products);
                        }).catch(function(error){});
                        
                    },
                    methods: {
                        // onImageChange(e, b){
                        //     console.log(e.target.files[0]);
                        //     this.banner[b] = e.target.files[0];
                        //     console.log('vistinskata', this.banner);
                        // },
                        handleRemove(file, fileList) {
                            let index = this.fileList.indexOf(file);
                            this.bnrDesc.splice(index,1);
                            this.prodIds.splice(index,1);
                            this.fileList.splice(index,1);
                            this.submitForm();
                        },
                        handlePreview(file) {
                            this.bnrDesc.push('');
                            this.fileList.push(file);
                        },
                        submitForm(){
                            let formData = new FormData();
                            $.each(this.fileList,function (index,value){
                                if(value.raw === undefined)
                                    formData.append('files['+index+']',value.url);
                                else
                                    formData.append('files['+index+']',value.raw);
                            });
                            formData.append('prod_ids',this.prodIds);
                            formData.append('desc',this.bnrDesc);
                            formData.append('type', 'horizontal_products');
                            axios.post( '/admin/manageBanners', formData, {
                                    headers: {
                                        'Content-Type': 'multipart/form-data',
                                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                                    },
                                }
                            ).then(function(response){
                                if (response.data.status) {
                                    showToast('success', response.data.message);
                                }
                            })
                                .catch(function(error){
                                });
                        }
                    }
                });
            </script>
            <style>
                .banner-desc-input {
                    margin-top: 12px;
                }
                .banner-desc-input:first-child {
                    margin-top: 42px !important;
                }
                textarea{
                    height: 92px !important;
                }
            </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\mangopaid-modapascher\resources\views/admin/Products/horizontal.blade.php ENDPATH**/ ?>