<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//

Route::get('/profile', 'HomeController@checkType');
Route::get('/fix', 'HomeController@changePsw');
Route::get('/testEmail', 'HomeController@testEmail');
Route::get('/logged-now', 'HomeController@justLogged');
Route::post('/login-new', 'HomeController@loginNew');
Route::post('/register-new', 'HomeController@registerNew');
Route::get('/live-order/{id}', 'LiveOrdersController@show');
Route::post('/live-order/payment/{id}', 'LiveOrdersController@livePayment');
Route::post('/live-order/paypalSuccess', 'LiveOrdersController@paypalSuccess');


Route::get('/paypal/{type}/{id}', 'ApiV1\OrderController@processPaypal');

//Route::get('/test', 'HomeController@test');
Route::get('/change/language/{lang}', 'HomeController@change_language');

Auth::routes();
Route::group(['prefix' => 'admin', 'middleware' => ['auth', 'isAdmin']], function () {
    Route::get('/live-order', 'LiveOrdersController@index');
    Route::post('/live-order', 'LiveOrdersController@store');
    Route::post('/live-order/change-type', 'LiveOrdersController@changeType');
    Route::MATCH(['GET', 'POST'],'/live-orders', 'LiveOrdersController@liveOrders');

    Route::get('/', 'Admin\DashboardController@index');
    Route::get('addProd', 'Admin\DashboardController@addProd');
    Route::get('addProd/{id}', 'Admin\DashboardController@addProd');
    Route::get('manageProducts', 'Admin\DashboardController@manageProducts');
    Route::get('manageCategories', 'Admin\DashboardController@manageCategories');
    Route::get('manageCollections', 'Admin\DashboardController@manageCollections');
    Route::get('manageCoupons', 'Admin\DashboardController@manageCoupons');

    Route::post('changeTheme', 'Admin\ConfigController@themeChange');

    Route::get('manageBanners', 'Admin\DashboardController@manageBanners');
    Route::post('manageBanners', 'Admin\ManageShopController@addBanner');

    Route::post('updatePageName', 'Admin\ConfigController@updatePageName');
    Route::post('logoUpload', 'Admin\ConfigController@logoUpload');
    Route::post('updateShopData', 'Admin\ConfigController@updateShopData');

    Route::post('product', 'Admin\ProductsController@product');
    Route::post('product/{id}', 'Admin\ProductsController@product');
    Route::post('deleteProduct/{id}', 'Admin\ProductsController@deleteProduct');


    Route::post('addCategory/{id}', 'Admin\ManageShopController@addCategory');
    Route::post('addSubCategory/{id}/{sub_id}', 'Admin\ManageShopController@addSubCategory');
    Route::post('deleteCategory/{id}', 'Admin\ManageShopController@deleteCategory');
    Route::post('activateCategory/{id}', 'Admin\ManageShopController@activateCategory');

    Route::post('addCoupon/{id}', 'Admin\ManageShopController@addCoupon');
    Route::post('deleteCoupon/{id}', 'Admin\ManageShopController@deleteCoupon');
    Route::post('activateCoupon/{id}', 'Admin\ManageShopController@activateCoupon');
    Route::post('/getProducts', 'ProductsController@getProductsAdmin');

    Route::post('deleteSubCategory/{id}', 'Admin\ManageShopController@deleteSubCategory');
    Route::post('activateSubCategory/{id}', 'Admin\ManageShopController@activateSubCategory');

    Route::get('orders', 'Admin\OrderController@manageOrders');
    Route::post('getOrders', 'Admin\OrderController@getOrders');
    Route::post('readyOrder', 'Admin\OrderController@readyOrder');
    Route::post('completeOrder', 'Admin\OrderController@completeOrder');
    Route::post('editOrderInfo', 'Admin\OrderController@editOrderInfo');

    Route::get('clients', 'Admin\ManageShopController@manageClients');
    Route::post('getClients', 'Admin\ManageShopController@getClients');
    Route::post('getClientsCustom', 'Admin\ManageShopController@getClientsCustom');

    Route::get('exportClients', 'Admin\ManageShopController@export')->name('export');
    Route::get('exampleExcel', 'Admin\ManageShopController@exampleExcel')->name('export');
//    Route::get('importExportView', 'Admin\ManageShopController@importExportView');
    Route::post('importClients', 'Admin\ManageShopController@import')->name('import');

    Route::get('productBanners', 'Admin\DashboardController@productBanners');

    Route::post('addSection', 'Admin\ManageShopController@addSection');

    Route::post('saveCurrencies', 'Admin\ManageShopController@saveCurrencies');

    Route::post('addShippingRange', 'Admin\ManageShopController@addShippingRange');

    Route::post('editAdminInfo', 'Admin\UserController@editAdminInfo');

    Route::group(['prefix' => 'languages'], function () {
//        Route::match(['get', 'post'], '/', 'App\Http\Controllers\LanguagesController@languages');
        Route::match(['get', 'post'], '/', 'Admin\LanguageController@languages');
        Route::match(['get', 'post'], '/generate', 'Admin\LanguageController@generateLanguages');
        Route::match(['get', 'post'], '/add', 'Admin\LanguageController@changeLanguageVariable');
        Route::match(['get', 'post'], '/delete/{id}', 'Admin\LanguageController@deleteLanguageVariable');
    });



});
Route::get('logout', 'Auth\LoginController@logout');

Route::post('/getProducts', 'ProductsController@getProducts');
Route::post('/getSingleProduct', 'ProductsController@getSingleProduct');



Route::get('{any}','HomeController@indexHome')->where('any', '.*');


