@extends('layouts.admin')

@section('content')
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-3">
                                <el-upload
                                    class="upload-demo"
                                    action="https://jsonplaceholder.typicode.com/posts/"
                                    :on-change="handlePreview"
                                    :on-remove="handleRemove"
                                    :auto-upload="false"
                                    :file-list="fileList"
                                    list-type="picture">
                                    <el-button size="small" type="primary">Click to upload</el-button>
                {{--                    <div slot="tip" class="el-upload__tip">jpg/png files with a size less than 500kb</div>--}}
                                </el-upload>
                            </div>
                            <div class="col-9" >
                                <div class="row banner-desc-input" v-for="(bt, index) in bnrDesc">
                                        <div class="col-9">
                                            <textarea style="resize: none;"  placeholder="Banner description" class="form-control" v-model = "bnrDesc[index]"></textarea>

                                        </div>
                                        <div class="col-3" v-if="products.length>0">
                                            <select class="form-control show-tick ms select2" data-placeholder="Select" placeholder="Select Product" name="prod_id" v-model="prodIds[index]" id="prod_id">
                                                <option></option>
                                                <option v-for="p in products" v-bind:value="p.id"> @{{ p.title }}</option>
                                            </select>
                                        </div>
                                </div>
                            </div>
                            <div class="col-12" v-if="bnrDesc.length > 0" >
                                <button class="btn btn-primary" style="float:right;margin-top:30px;" type="button" @click="submitForm">Submit</button>
                            </div>
                        </div>

                    </div>
                </div>
        </div>
    </div>



@endsection
@section('footer')
    <script>

        const Vue_comp = new Vue({
            el:"#main-content",
            data: {
                banners: null,
                products: [],
                bnrDesc:[],
                fileList: [],
                prodIds: []
            },
            created() {
                const self = this;
                axios.post( 'api/V1/getBanners',{}, {
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{csrf_token()}}'
                        },
                    }
                ).then(function(response){
                    self.banners = response.data.values;
                    console.log('banners', self.banners);
                    if(self.banners.length > 0){
                        $.each(self.banners,function (index,value){
                            self.fileList.push({name: 'banner', url: value.image});
                            self.bnrDesc.push(value.description);
                            self.prodIds.push(value.prod_id);
                        })
                    }
                }).catch(function(error){});
                console.log(this.banners);

                axios.post( '/admin/getProducts',{}, {
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{csrf_token()}}'
                        },
                    }
                ).then(function(response){
                    self.products = response.data.values;
                    console.log('prods', self.products);
                }).catch(function(error){});
                {{--this.products = JSON.parse("{!! dd((json_encode($products))) !!}");--}}
            },
            methods: {
                // onImageChange(e, b){
                //     console.log(e.target.files[0]);
                //     this.banner[b] = e.target.files[0];
                //     console.log('vistinskata', this.banner);
                // },
                handleRemove(file, fileList) {
                    let index = this.fileList.indexOf(file);
                    this.bnrDesc.splice(index,1);
                    this.prodIds.splice(index,1);
                    this.fileList.splice(index,1);
                    this.submitForm();
                },
                handlePreview(file) {
                    this.bnrDesc.push('');
                    this.fileList.push(file);
                },
                submitForm(){
                    let formData = new FormData();
                    $.each(this.fileList,function (index,value){
                        if(value.raw === undefined)
                            formData.append('files['+index+']',value.url);
                        else
                            formData.append('files['+index+']',value.raw);
                    });
                    formData.append('prod_ids',this.prodIds);
                    formData.append('desc',this.bnrDesc);
                    formData.append('type', 'banner');
                    axios.post( '/admin/manageBanners', formData, {
                            headers: {
                                'Content-Type': 'multipart/form-data',
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        if (response.data.status) {
                            showToast('success', response.data.message);
                        }
                    })
                        .catch(function(error){
                        });
                }
            }
        });
    </script>
    <style>
        .banner-desc-input {
            margin-top: 12px;
        }
        .banner-desc-input:first-child {
            margin-top: 42px !important;
        }
        textarea{
            height: 92px !important;
        }
    </style>
@endsection
