import React, { Component } from 'react'
import Store from "./store";
import ReactDOM from "react-dom";
import MainApp from "../../MainApp";

export default class RelatedProds extends Component {
    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            store:store,
            product: {
                id: '',
                title: '',
                description: '',
                image: ''
            }
        }
        let currUrl =  window.location.href;
        let id = currUrl.split('/detailed/');
        id = id[1];
        console.log('compo id:'+id);

        this.state.store.api_post_call('getSingleProduct', {id: id}).then(res=> {
            this.setState({product : res.data.values})
            console.log('prod', res.data.values);


        }).catch(err => {
            console.log(err);
        });
    }
    render() {
        let product = this.state.product;
        return (
            <div>
                <meta property="og:title" content={product.title}/>
                <meta property="og:description" content={product.description}/>
                <meta property="og:type" content="website"/>
                <meta property="og:url" content={this.props.url+"/detailed/" + product.id}/>
                <meta property="og:image" content={product.image}/>


            </div>


        )


    }
}

if (document.getElementById('meta-react')) {
    const element = document.getElementById('meta-react');
    const url = $('#meta-comp').attr('url');
    ReactDOM.render(<RelatedProds url={url}/>,
        element);

}
