import React, { Component } from 'react'
import Store from "../../../utils/store";

export default class TopProduct extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            store:store

        }
        this.calcPrice=this.calcPrice.bind(this);

    }

    calcPrice(val) {
        // let store = null;
        // store = new Store('mangopaid');
        return this.state.store.calculateCurrencies(this.props.calculateCurrencies,val);
    }

    render () {


        let topProduct = this.props.topProduct;
        let indexProduct = this.props.indexProduct;
        let title = topProduct.title;
        if (title.length > 20) {
            title = title.substring(0, 17) + "...";
        }
        let currency = this.props.currency;


        return (
            <div className="mini-product-list" key={'top_product_item_'+indexProduct}>

                <div className="single-mini-product d-flex">
                    <div className="product-thumb">
                        <img className="imgSize" src={topProduct.image}
                             alt="Product"/><a className="cart" href={`/detailed/${topProduct.id}`}>
                        <i className="fa fa-eye"> </i></a>
                    </div>
                    <div className="product-content media-body">
                        <h6 className="title"><a href={`/detailed/${topProduct.id}`} style={{textTransform: 'uppercase'}} >{title} </a></h6>
                        <span className="sale-price" style={{fontSize: '14px'}}>{topProduct.price} {currency}</span>
                                    {/*<span className="regular-price">$ {product.sellPrice}</span>*/}
                                    {/*<ul className="product-rating">*/}
                                    {/*    {stars}*/}
                                    {/*</ul>*/}
                    </div>
                </div>
            </div>

        )
    }
}


