import React, {Component} from 'react'
import PropTypes from 'prop-types';
// import image from '../../../../../../../public/images/foo/product-1.jpg'
// import image2 from '../../../../../../../public/images/foo/product-2.jpg'
import Swal from "sweetalert2";
import Store from "../../../../utils/store";





export default class GridProductSale extends Component {
    constructor(props) {
        super(props);
        this.state = {
            product: null,
            status: ''
        };

        this.changeActiveColor = this.changeActiveColor.bind(this);
        this.selectedColorClass = this.selectedColorClass.bind(this);
        this.selectedSizeClass = this.selectedSizeClass.bind(this);
        this.addToCart = this.addToCart.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        this.calcPrice = this.calcPrice.bind(this);

    }

    componentDidMount() {
        const self = this;
        setTimeout(function () {

            let product = self.props.product;
            product.active = false;
            product.sizes.map(function (size) {
                size.active = false;
                // product.colors.map(function(color){
                //     color.active=false;
                // });
            });
            self.setState({product: product});
//            console.log('products will mount', self.state.product);
        }, 100);
    }
    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }


    changeActiveSize(sizeIndex) {
        const self = this;
        let product = this.props.product;
        product.sizes.map((size)=>{
            size.active =false;
        });
        product.sizes[sizeIndex].active = true;

        this.setState({product: product});
    }

    changeActiveColor(sizeIndex, colorIndex) {
        let product = this.props.product;
        console.log(product);
        product.sizes.map((size)=>{
            if(size.active===true) {
                size.colors.map((color) => {
                    color.active = false;
                }); }
        });
        product.sizes[sizeIndex].colors[colorIndex].active = true;

        this.setState({product: product});
    }

    selectedColorClass(sizeIndex, colorIndex){
        const self = this;
        let returnValue = '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    selectedSizeClass(sizeIndex){
        const self = this;
        let returnValue = '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    addToCart(index){
        const product = this.props.product;
        this.props.addToCartProduct(product, index);
    }

    handleSubmit(index){
        let valid = true;
        let product = this.props.product;
        for(let i = 0; i <product.sizes.length; i++) {
            if (product.sizes[i].active === true) {
                for (let k = 0; k < product.sizes[i].colors.length; k++) {
                    if (product.sizes[i].colors[k].active === true) {
                        this.setState({
                            ...this.state,
                            errorMessage: ""
                        });
                        valid=true;
                        break;
                    } else {
                        this.setState({
                            ...this.state,
                            errorMessage: "Please select color"
                        });
                        valid = false;
                    }
                }
                break;
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: "Please select size"
                });
                valid = false;
            }
        }

        if(valid){
            this.addToCart(index);
        }

    }

    render() {
        let product = this.props.product;
        let sizes = product.sizes;
        let min=0;
        let status='';
        for(let i=0;i<sizes.length;i++){
            if(sizes[i].stock > min){
                min=sizes[i].stock;
            }
            if(min>0)
            {
                status = "IN STOCK";
            }
            else
            {
                status = "OUT OF STOCK";
            }
        }

        let title = product.title;
        if (title.length > 20) {
            title = title.substring(0, 17) + "...";
        }
        let currency=this.props.currency;



        return (


            // <div className="col-lg-4 col-sm-6">
            <div className="single-product mt-30">
                <div className="product-image">
                    <a href={`/detailed/${product.id}`}>
                        <img className="product-1" style={{objectFit: 'contain', height: '302px', maxHeight: '302px'}} src={product.image} alt="product"/>
                        { product.images.length>1 ?
                            <React.Fragment>
                                <img className="product-2" style={{objectFit: 'contain', height:'302px', maxHeight: '302px'}}
                                     src={product.images[1].image} alt="product"/>
                            </React.Fragment> :
                            <React.Fragment>
                                <img className="product-2" style={{objectFit: 'contain', height:'312px', maxHeight: '312px'}}
                                     src={product.image} alt="product"/>
                            </React.Fragment>

                        }
                    </a>
                </div>
                <div className="product-content text-center">
                    <div className="product-content-top">

                        <h4 className="title"><a href={`/detailed/${product.id}`} style={{textTransform: 'uppercase'}}>{title} </a>
                        </h4>

                        <span className="regular-price">{this.calcPrice(5000)}</span>
                        <span className="sale-price" style={{fontSize: '14px', paddingLeft:'10px', color: '#e06377'}}>{this.calcPrice(product.price)}</span>


                        {/*<span className="sale-price" style={{color: '#6e6e6e', fontSize: '14px'}}>{this.calcPrice(product.price)}</span>*/}
                        {/*<span className="regular-price">$299</span>*/}
                    </div>
                    <div className="product-cart">
                        <div className="product-size-color d-flex justify-content-between mt-0 pt-0" >
                            <ul className="product-size center-elem">
                                {sizes.map((size, sizeIndex) =>

                                    <li onClick={() => { this.changeActiveSize(sizeIndex) }}
                                        key={'top_product_color_'+sizeIndex}
                                        className={this.selectedSizeClass(sizeIndex)} >
                                        <span  style={{padding: '15px !important'}} >{size.size}</span>
                                    </li>
                                )
                                }
                            </ul>
                            <ul className="product-color">
                                {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                        <li style={{backgroundColor: color.color.toLowerCase(), border: '1px solid #bebebe', height: '18px', width: '18px'}} onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}
                                            key={'top_product_color_'+sizeIndex+'_'+colorIndex}
                                            className={this.selectedColorClass(sizeIndex, colorIndex)}>
                                            <span>  </span>
                                        </li>
                                    ) : null
                                )}
                            </ul>
                        </div>
                        <div style={{cursor: 'pointer'}} className="product-cart-btn mt-0 pt-0" onClick={() => { this.handleSubmit() }}>
                            <a className="cart-btn" ><i className="flaticon-shopping-cart"> </i>
                                <span>Add to cart</span></a>
                        </div>
                    </div>
                </div>
            </div>
        )
    }
}

GridProductSale.propTypes = {
    product: PropTypes.shape({
        id: PropTypes.number,
        title: PropTypes.string,
        price: PropTypes.string,
        description: PropTypes.string,
        status: PropTypes.number
    })
};



