import React, { Component } from 'react'
import 'react-router-dom';
import slider2 from "../../../../../../../../public/assets/images/cover31.jpg"
import PropTypes from 'prop-types';
import Store from '../../../../../utils/store';
import RelatedProduct from "./RelatedProduct";
import ProductDescription from "./ProductDescription";
import Swal from "sweetalert2";



import Carousel, { consts } from 'react-elastic-carousel';


export default class ProductCardDetails extends Component {
    constructor(props) {
        super(props);
        // this.breakPoints = [ { width: '850px', itemsToShow: 3 }]
        const store = new Store('mangopaid');
        this.state = {
            product: {
                title: '',
                wishlistProds: '',
                cartProds: '',
                sizes: [],
                images: [],
                sub_cat: {
                    title: '',
                    category: {
                        title: ''
                    }
                }
            },
            errorMessage: '',
            errorMessageWish: '',
            store: store,
            status: '',
            message: '',
            messageColor: '',
            config: {
                currency: '',
                min_o_free: ''
            },
            quantity: 1,
            relatedProducts: [],
            calculateCurrencies:[]
        };
        this.changeActiveColor = this.changeActiveColor.bind(this);
        this.selectedColorClass = this.selectedColorClass.bind(this);
        this.selectedSizeClass = this.selectedSizeClass.bind(this);
        this.addToWishListProduct = this.addToWishListProduct.bind(this);
        this.addToCartProduct = this.addToCartProduct.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        this.wishHandleSubmit = this.wishHandleSubmit.bind(this);
        this.decrement=this.decrement.bind(this);
        this.increment=this.increment.bind(this);
        this.setStore=this.setStore.bind(this);
        this.calcPrice=this.calcPrice.bind(this);

    }

    // UNSAFE_componentWillMount() {
    //     const self = this;
    //     setTimeout(function () {
    //
    //         let product = self.props.product;
    //         product.active = false;
    //         product.sizes.map(function (size) {
    //             size.active = false;
    //             // product.colors.map(function(color){
    //             //     color.active=false;
    //             // });
    //         });
    //         self.setState({product: product});
    //     }, 100);

    // }

    UNSAFE_componentWillMount() {

        this.state.store.api_post_call('calculateCurrencies', {}).then(res=> {
            let calculateCurrencies = res.data.values;
            this.setState({
                calculateCurrencies: calculateCurrencies
            })

        }).catch(err => {
            console.log(err);
        })

    }

    async componentDidMount () {
        const { match: { params } } = this.props;
        await this.state.store.api_post_call('getSingleProduct', {id: params.id}).then(res=> {
            this.setState({product : res.data.values})
        }).catch(err => {
            console.log(err);
        });

        let sizes = this.state.product.sizes;
        let min=0;
        for(let i=0;i<sizes.length;i++){
            if(sizes[i].stock > min){
                min=sizes[i].stock;
            }
            if(min>0)
            {
                this.setState({status: "EN STOCK"})
            }
            else
            {
                this.setState({status: "EN RUPTURE DE STOCK"})
            }
        }

        this.state.store.api_post_call('getShopConfig', {}).then(res=> {
            this.setState({config:  res.data.values});
        }).catch(err => {
            console.log(err);
        })

        this.state.store.api_post_call('relatedProds', {sub_id: this.state.product.sub_category_id}).then(res=> {
            this.setState({relatedProducts:  res.data.values.related});

        }).catch(err => {
            console.log(err);
        })

        let product = this.state.product;
        product.quantity = 1;
        product.totalPrice=product.quantity*product.price;
        this.setState({
            product:product

        })
        this.state.store.editProduct(product, this.state.product);

        if(product.sizes.length === 1 ){
            this.changeActiveSize(0);
        }

        if(product.sizes.length===1 && product.sizes[0].colors.length===1){
            this.changeActiveColor(0,0);
        }


    }

    changeActiveSize(sizeIndex) {
        const self = this;
        let product = this.state.product;
        product.sizes.map((size)=>{
            size.active =false;
        });
        product.sizes[sizeIndex].active = true;

        this.setState({product: product,
        message: product.sizes[sizeIndex].size
        });
    }

    changeActiveColor(sizeIndex, colorIndex) {
        let product = this.state.product;
        product.sizes.map((size)=>{
            if(size.active===true) {
                size.colors.map((color) => {
                    color.active = false;
                }); }
        });
        product.sizes[sizeIndex].colors[colorIndex].active = true;


        this.setState({product: product,
        messageColor:product.sizes[sizeIndex].colors[colorIndex].color
        });
    }

    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.state.calculateCurrencies,val);
    }


    decrement(product) {
        if(this.state.quantity===1)
            product.quantity = 1;
        else
            product.quantity = this.state.quantity - 1;
        product.totalPrice = parseFloat(product.price) * parseFloat(product.quantity);

        this.setState({
            product:product,
            quantity:parseFloat(product.quantity),
            totalPrice: parseFloat(product.totalPrice)
        });
    }



    increment(prod=null){
        let qty = parseFloat(this.state.quantity);
        let product = this.state.product;
        product.quantity = qty + 1;
        product.totalPrice =
            parseFloat(product.price) * parseFloat(product.quantity);

        this.setState({
            product:product,
            quantity:parseFloat(product.quantity),
            totalPrice: parseFloat(product.totalPrice)
        });
    }

    setStore(product){
        this.state.store.editProduct(product, this.state.product);
    }

    selectedColorClass(sizeIndex, colorIndex){
        const self = this;
        let returnValue = '';
        // if(this.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
        //     return 'active';
        // }
        // else return '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    selectedSizeClass(sizeIndex){
        const self = this;
        let returnValue = '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    addToWishListProduct(index){
        const product = this.state.product;
        let storeData = this.state.store.addToWishListProduct(product, index);
        this.setState({wishlistProds: storeData.wishList});
    }

    addToCartProduct(index){
        let storeData = this.state.store.addToCartProductOnCLick(this.state.product, index);
        this.setState({cartProds: storeData.cart});
    }


    wishHandleSubmit(){
        let valid = true;
        let product = this.state.product;
        for(let i = 0; i <product.sizes.length; i++) {
            if (product.sizes[i].active === true) {
                for (let k = 0; k < product.sizes[i].colors.length; k++) {
                    if (product.sizes[i].colors[k].active === true) {
                        this.setState({
                            ...this.state,
                            errorMessage: ""
                        });
                        valid=true;
                        break;
                    } else {
                        this.setState({
                            ...this.state,
                            errorMessage: "Veuillez sélectionner la couleur"
                        });
                        valid = false;
                    }
                }
                break;
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: "Veuillez sélectionner la taille"
                });
                valid = false;
            }
        }

        if(this.state.status === "EN RUPTURE DE STOCK"){
            valid = false;
            Swal.fire("L'article est en rupture de stock");
        }

        if(valid){
            this.addToWishListProduct();
            Swal.fire("Ajouté à la liste de souhaits");

        }

    }

    handleSubmit(){
        let valid = true;
        let product = this.state.product;
        for(let i = 0; i <product.sizes.length; i++) {
            if (product.sizes[i].active === true) {
                for (let k = 0; k < product.sizes[i].colors.length; k++) {
                    if (product.sizes[i].colors[k].active === true) {
                        this.setState({
                            ...this.state,
                            errorMessage: ""
                        });
                        valid=true;
                        break;
                    } else {
                        this.setState({
                            ...this.state,
                            errorMessage: "Veuillez sélectionner la couleur"
                        });
                        valid = false;
                    }
                }
                break;
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: "Veuillez sélectionner la taille"
                });
                valid = false;
            }
        }

        if(this.state.status === "EN RUPTURE DE STOCK"){
            valid = false;
            Swal.fire("L'article est en rupture de stock");
        }

        if(valid){
            this.addToCartProduct();
            Swal.fire({
                title: '<strong>Added to cart<strong>',
                icon: 'success',
                showCloseButton: true,
                showCancelButton: true,
                focusConfirm: false,
                confirmButtonText:
                    '<a className="white" href="/list">Continuer vos achats</a>' ,
                confirmButtonColor: '#fff',
                cancelButtonText:
                    '<a className="white" href="/cart"> Aller au panier </a>'
            });

            // add(product);
        }

    }

    render() {
        const self =this;
            const product = self.state.product;
            console.log('product', product);
            const status = this.state.status;

            let currency = this.state.config.currency;
            let min_o_free = this.state.config.min_o_free;
            let limit = parseInt(min_o_free);

            const {relatedProducts} = this.state;

        const breakPoints = [
            { width: 1, itemsToShow: 1, itemsToScroll: 1  },
            { width: 550, itemsToShow: 1, itemsToScroll: 1 },
            { width: 768, itemsToShow: 1 },
            { width: 1200, itemsToShow: 1 }
        ];


        // const props = {width: 400, scale: 1.5, zoomPosition: "right", zoomWidth: 300, img: {product.image}, height: 300};

            return (

                <React.Fragment>
                    {/*<HeaderPart/>*/}
                    <div>
                    <section className="page-banner bg_cover" style={{backgroundImage: "url(" + slider2 + ")"}}>
                        {/*<img src={slider2} alt="slider"/>*/}

                        <div className="container">
                            <ol className="breadcrumb">
                                <li className="breadcrumb-item"><a href="/">Home</a></li>
                                <li className="breadcrumb-item"><a href="/list">Products</a></li>
                                <li className="breadcrumb-item active">Details</li>
                            </ol>
                        </div>
                    </section>
                    <section className="shop-details-page pt-30">
                        <div className="container">
                            <div className="row">
                                {/*<div className="col-lg-6">*/}
                                {/*    <img style={{height: '650px', maxHeight: '650px', objectFit: 'contain'}} src={product.image} alt="details"/>*/}
                                {/*</div>*/}

                                <div className="col-lg-6">
                                    <Carousel pagination={true} showArrows={false} breakPoints={breakPoints} enableSwipe enableMouseSwipe
                                              renderPagination={({ pages, activePage, onClick }) => {
                                                  return (
                                                      <div className="row" style={{marginLeft:'auto', marginRight:'auto', display:'block', textAlign:'center'}}>
                                                          {pages.map(page => {
                                                              const isActivePage = activePage === page
                                                              return (
                                                                  <button
                                                                      style={{backgroundColor: 'rgb(255, 57, 65)', height: '7px', width: '7px', textAlign: 'center', padding: '2px', margin: '15px 3px 0'

                                                                      }}
                                                                      key={page}
                                                                      onClick={() => onClick(page)}
                                                                      active={isActivePage}
                                                                  ></button>
                                                              )
                                                          })}
                                                      </div>
                                                  )
                                              }}
                                    >
                                        {product.images.map(
                                            (i, imageIndex) =>
                                                <div key={imageIndex} className="shop-details-image mt-50" style={{width: '100%', maxWidth: '100%'}}>
                                                    <div className="shop-slid-image" style={{width: '100%', maxWidth: '100%'}}>
                                                        <div className="single-shop-image" style={{width: '100%', maxWidth: '100%'}}>
                                                            <img style={{height: '650px', maxHeight: '650px', objectFit: 'contain'}} src={i.image} alt="details"/>
                                                        </div>
                                                    </div>
                                                </div>
                                        )}
                                    </Carousel>
                                        {/*<div className="shop-thumb" style={{maxWidth: '100%', width: '100%', padding: '10px', margin: '30px !important' }}>*/}
                                        {/*</div>*/}
                                </div>



                                <div className="col-lg-6">
                                    <div className="shop-details-content pt-0 pb-20 m-b--20" style={{borderTop: '0', borderBottom: '1px solid #e5e5e5'}}>
                                        <div style={{fontWeight: '900', backgroundColor: 'rgb(235, 241, 246)', padding: '15px 20px 15px 10px', marginTop: '50px'
                                        }}>
                                            <button className='btn btn-wishlist' onClick={() => { this.wishHandleSubmit() }}>
                                                <i className='fa-heart far pr-1' > </i>
                                                Liste de souhaits
                                            </button>
                                            <div className='mr-0, p-r-12 float-right' style={{color: 'green', fontWeight:'700', paddingTop: '8px'}}>
                                                {this.state.status}
                                            </div>

                                        </div>

                                        <div className="shop-details-content mt-25">
                                            <h4 className="title">{product.title} </h4>
                                            <div className="price mt-20">
                                                <span style={{fontSize: '50px'}} className="sale-price">{product.price} <small> {currency}</small> </span>
                                            </div>
                                            <span style={{color: "red", fontSize:'12px'}} >{this.state.errorMessage}</span>
                                            <span style={{color: "red", fontSize:'12px'}} >{this.state.errorMessageWish}</span>


                                            {
                                                product.sizes.length == 1 ?
                                                    <React.Fragment>
                                                        <div
                                                            className="product-size-color d-flex justify-content-between mt-5">
                                                            <div className="btn-group mr-3">
                                                                <label htmlFor="size"
                                                                       className="labelDesign"> Taille: </label>
                                                                <span className="labelDesign"> { product.sizes[0].size } </span>
                                                            </div>
                                                        </div>
                                                        <div className="product-size-color d-flex justify-content-between">
                                                            <ul className="product-color">
                                                                {
                                                                    product.sizes[0].colors.length === 1 ?
                                                                        <React.Fragment>
                                                                            <label className="labelDesign"> Couleur:  </label>
                                                                            <li style={{
                                                                                backgroundColor: product.sizes[0].colors[0].color_code,
                                                                                border: '1px solid #bebebe',
                                                                                height: '40px',
                                                                                width: '40px',
                                                                                borderRadius: '5px'
                                                                            }}>
                                                                                <span> </span>
                                                                            </li>

                                                                            <div className="messageBlue" style={{marginTop: '30px', width: 'max-content'}}>
                                                                                <span style={{color: '#555'}}>Taille choisie: </span>
                                                                                <strong className="badge-info" style={{marginLeft: '10px', padding: '1px 15px', color: '#222'}}> {product.sizes[0].size} </strong>
                                                                                <strong className="badge-info"  style={{marginLeft: '10px', padding: '1px 15px', color: '#222'}}  > {product.sizes[0].colors[0].color} </strong>
                                                                                <span style={{color: '#555', paddingLeft: '5px'}}> color </span>
                                                                            </div>

                                                                        </React.Fragment> :
                                                                        <React.Fragment>
                                                                            {product.sizes.map((size, sizeIndex) => size.colors.map((color, colorIndex) =>
                                                                                <li style={{
                                                                                    backgroundColor: color.color_code,
                                                                                    border: '1px solid #bebebe',
                                                                                    height: '40px',
                                                                                    width: '40px',
                                                                                    borderRadius: '5px'
                                                                                }}
                                                                                    onClick={() => {
                                                                                        this.changeActiveColor(sizeIndex, colorIndex)
                                                                                    }}
                                                                                    key={'top_product_color_' + sizeIndex + '_' + colorIndex}
                                                                                    className={this.selectedColorClass(sizeIndex, colorIndex)}>
                                                                                    <span>  </span>

                                                                                </li>
                                                                            ) )}
                                                                            <div className="messageBlue" style={{marginTop: '30px', width: 'max-content'}}>
                                                                                <span style={{color: '#555'}}>Taille choisie: </span>
                                                                                <strong className="badge-info" style={{marginLeft: '10px', padding: '1px 15px', color: '#222'}}> {product.sizes[0].size} </strong>
                                                                                <strong className="badge-info"  style={{marginLeft: '10px', padding: '1px 15px', color: '#222'}}  > {this.state.messageColor} </strong>
                                                                                <span style={{color: '#555', paddingLeft: '5px'}}> color </span>
                                                                            </div>

                                                                        </React.Fragment>


                                                                }
                                                            </ul>




                                                            {/*    {product.sizes[0].colors.map((color, colorIndex) =>*/}
                                                            {/*            <li style={{*/}
                                                            {/*                backgroundColor: color.color.toLowerCase(),*/}
                                                            {/*                border: '1px solid #bebebe',*/}
                                                            {/*                height: '40px',*/}
                                                            {/*                width: '40px',*/}
                                                            {/*                borderRadius: '5px'*/}
                                                            {/*            }}*/}
                                                            {/*                onClick={() => {*/}
                                                            {/*                    this.changeActiveColor(sizeIndex, colorIndex)*/}
                                                            {/*                }}*/}
                                                            {/*                key={'top_product_color_' + sizeIndex + '_' + colorIndex}*/}
                                                            {/*                className={this.selectedColorClass(sizeIndex, colorIndex)}>*/}
                                                            {/*                <span>  </span>*/}

                                                            {/*            </li>*/}
                                                            {/*        )}*/}
                                                            {/*</ul>*/}
                                                        </div>





                                                    </React.Fragment>
                                                    :
                                                    <React.Fragment>

                                                        <div
                                                            className="product-size-color d-flex justify-content-between mt-5">
                                                            <div className="btn-group mr-3">
                                                                <label htmlFor="size"
                                                                       className="labelDesign"> Taille: </label>
                                                                <button type="button"
                                                                        className="detailButton dropdown-toggle"
                                                                        style={{
                                                                            color: '#555',
                                                                            border: '1px solid #ccc',
                                                                            height: '40px'
                                                                        }}
                                                                        data-toggle="dropdown" aria-haspopup="true"
                                                                        aria-expanded="false">
                                                                    Select a size
                                                                </button>
                                                                <div className="dropdown-menu"
                                                                     aria-labelledby="dropdownMenuButton">

                                                                    {product.sizes.map((size, sizeIndex) =>

                                                                        <li onClick={() => {
                                                                            this.changeActiveSize(sizeIndex)
                                                                        }}
                                                                            className={this.selectedSizeClass(sizeIndex)}>
                                                                            <button className="dropdown-item"
                                                                                    type="button"
                                                                                    style={{cursor: 'pointer'}}>{size.size}</button>
                                                                        </li>
                                                                    )
                                                                    }
                                                                </div>
                                                            </div>
                                                        </div>
                                                        {/*<div className="btn-group">*/}
                                                        {/*    {product.sizes.map((size, sizeIndex) => size.active ?*/}
                                                        <div
                                                            className="product-size-color d-flex justify-content-between mt-5">
                                                            <ul className="product-color">
                                                                {product.sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                                                        <li style={{
                                                                            backgroundColor: color.color_code,
                                                                            border: '1px solid #bebebe',
                                                                            height: '40px',
                                                                            width: '40px',
                                                                            borderRadius: '5px'
                                                                        }}
                                                                            onClick={() => {
                                                                                this.changeActiveColor(sizeIndex, colorIndex)
                                                                            }}
                                                                            key={'top_product_color_' + sizeIndex + '_' + colorIndex}
                                                                            className={this.selectedColorClass(sizeIndex, colorIndex)}>
                                                                            <span>  </span>

                                                                        </li>
                                                                    ) : null
                                                                )}
                                                            </ul>
                                                        </div>
                                                        <div className="messageBlue" style={{marginTop: '30px', width: 'max-content'}}>
                                                            <span style={{color: '#555'}}>Taille choisie: </span>
                                                            <strong className="badge-info" style={{marginLeft: '10px', padding: '1px 15px', color: '#222'}}> {this.state.message} </strong>
                                                            <strong className="badge-info"  style={{marginLeft: '10px', padding: '1px 15px', color: '#222'}}  > {this.state.messageColor} </strong>
                                                            <span style={{color: '#555', paddingLeft: '5px'}}> couleur </span>
                                                        </div>


                                                            {/*<button type="button" className="detailButton  dropdown-toggle" style={{ color: '#555', border: '1px solid #ccc'}}*/}
                                                            {/*        data-toggle="dropdown" aria-haspopup="true"*/}
                                                            {/*        aria-expanded="false">*/}
                                                            {/*    Select a color*/}
                                                            {/*</button>*/}
                                                            {/*<div className="dropdown-menu dropdown-menu-right" >*/}

                                                            {/*    {size.colors.map((color, colorIndex) =>*/}
                                                            {/*            // <li style={{backgroundColor: color.color.toLowerCase()}} onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}*/}
                                                            {/*            <li  onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}*/}
                                                            {/*                className={this.selectedColorClass(sizeIndex, colorIndex)}>*/}
                                                            {/*                <button className="dropdown-item" type="button" style={{cursor:'pointer'}}>{color.color}  </button>*/}
                                                            {/*            </li>*/}
                                                            {/*       )}*/}
                                                            {/*</div>*/}
                                                            {/*    </div>*/}
                                                            {/*: null*/}
                                                            {/*    )}*/}


                                                    </React.Fragment>





                                            }

                                            <div className="quantity-stock align-items-center" style={{maxWidth: '100% !important',
                                                width: '100% !important' }}>
                                                <div className="quantity">

                                                    <div className="quantity-form" style={{margin: '0'}}>
                                                        <div className="product-quantity d-flex" id="quantity">
                                                            <label htmlFor="quantity" className="labelDesign">Qté:</label>
                                                            <div style={{border: '1px solid #ccc', color: '#ccc', borderRadius:'2px'}}>
                                                                <button style={{border: '0', color:'#555', backgroundColor: 'white'}} onClick={()=>this.decrement(product)} type="button" className="sub"> - </button>
                                                            <input style={{width: '85px', height:'41px', border: '0', color: '#555'}} type="text" id="1" value={this.state.quantity}/>
                                                            <button  style={{border:'0', color:'#555', backgroundColor: 'white'}} onClick={()=>this.increment(product)} type="button" className="add">+</button>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                {product.sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                                    color.active ?
                                                        <React.Fragment>
                                                            {color.stock > 0 ?
                                                                <React.Fragment>
                                                                    <label style={{
                                                                        color: '#008000',
                                                                        fontSize: '12px',
                                                                        paddingTop: '20px'
                                                                    }}> disponible: {color.stock} </label>
                                                                </React.Fragment>
                                                                :
                                                                <React.Fragment>
                                                                    <label style={{
                                                                        color: 'rgb(255, 57, 65)',
                                                                        fontSize: '12px',
                                                                        paddingTop: '20px'
                                                                    }}> disponible: {color.stock} </label>
                                                                </React.Fragment>
                                                            }

                                                        </React.Fragment>
                                                        :
                                                        null


                                                    //     <li style={{backgroundColor: color.color.toLowerCase(), border: '1px solid #bebebe', height: '40px', width: '40px', borderRadius: '5px'}}
                                                    //         onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}
                                                    //         key={'top_product_color_'+sizeIndex+'_'+colorIndex}
                                                    //         className={this.selectedColorClass(sizeIndex, colorIndex)}>
                                                    //         <span>  </span>
                                                    //
                                                    //     </li>
                                                    // ) : null
                                                )
                                                :
                                                null
                                                )}
                                            </div>

                                            <div className="product-cart-btn mt-30">
                                                <a className="cart-btn"  style={{backgroundColor: '#e06377', cursor: 'pointer'}}><i
                                                    className="flaticon-shopping-cart"> </i>
                                                    <span onClick={() => { this.handleSubmit() }}>AJOUTER AU CHARIOT</span></a>
                                            </div>



                                        </div>
                                    </div>

                                    <div className='additionalInfo'>
                                        <p>Code: {product.code}</p>

                                        {product.sub_cat !== null ?
                                            <React.Fragment>
                                                <p>Catégorie: {product.sub_cat.category.title}</p>
                                                <p>Sous-catégorie: {product.sub_cat.title}</p>
                                            </React.Fragment>
                                            :
                                            null
                                        }


                                        {/*<p>Category: {product.sub_cat.category.title} </p>*/}
                                        {/*<p>Subcategory: {product.sub_cat.title}</p>*/}
                                        {/*<p>Code: {product.code}</p>*/}
                                    </div>

                                </div>
                            </div>
                        </div>
                    </section>
                    <ProductDescription product={product} currency={currency} calculateCurrencies={this.state.calculateCurrencies} status={this.state.status} />
                    <section id="Product-tab" className="pt-40 product-area pb-100">
                        <div className="container">
                            <div className="row justify-content-center">
                                <div className="section-title text-center pb-25 mb-30" >
                                    <div style={{textAlign: 'center', fontSize: 'x-large', color: '#222', borderBottom: '1px solid #dee2e6', width:'auto'}}> PRODUITS SIMILAIRES

                                    </div>
                                </div>
                            </div>
                            <div className="row">
                                <div className="col-lg-12">
                                    {
                                        this.state.relatedProducts.length !== 0 ?
                                            <React.Fragment>
                                    <div style={{width: '100%', maxWidth: '100%', borderBottom: '1px solid #dee2e6'}} className="shop-details-image">
                                        <div className="shop-thumb" style={{maxWidth: '100%', width: '100%', padding: '10px', margin: '30px !important' }}>
                                                        <Carousel className='d-none d-lg-block' itemsToScroll={2} itemsToShow={4} showArrows={false} pagination={false}>
                                                            {this.state.relatedProducts.map( (relatedProd, relatedIndex) =>
                                                                <RelatedProduct product={relatedProd} key={relatedIndex} currency={currency} calculateCurrencies={this.state.calculateCurrencies} />
                                                            )}
                                                        </Carousel>
                                                        <Carousel className='d-block d-sm-none' itemsToScroll={1} itemsToShow={1} showArrows={false} pagination={false}>
                                                            {this.state.relatedProducts.map( (relatedProd, relatedIndex) =>
                                                                <RelatedProduct product={relatedProd} key={relatedIndex} currency={currency} calculateCurrencies={this.state.calculateCurrencies} />
                                                            )}
                                                        </Carousel>
                                                        <Carousel className='d-none d-lg-none d-sm-block d-md-block'  itemsToScroll={1} itemsToShow={2} showArrows={false} pagination={false}>
                                                            {this.state.relatedProducts.map( (relatedProd, relatedIndex) =>
                                                                <RelatedProduct product={relatedProd} key={relatedIndex} currency={currency} calculateCurrencies={this.state.calculateCurrencies}/>
                                                            )}
                                                        </Carousel>
                                        </div>
                                    </div>
                                            </React.Fragment> :
                                            <React.Fragment>
                                                <div style={{color: '#555', textAlign: 'center', width: '100%', maxWidth: '100%'}}> There is no related products. </div>
                                            </React.Fragment> }
                                </div>
                            </div>
                        </div>
                    </section>
                    <a href="#" className="back-to-top"><i className="fal fa-chevron-up"> </i></a>
                    </div>
                </React.Fragment>

            )
        }
};


ProductCardDetails.propTypes = {
    product: PropTypes.shape({
        id: PropTypes.string,
        title: PropTypes.string,
        price: PropTypes.number,
        description: PropTypes.string,
        stars: PropTypes.number
    })
};

