import React, {Component} from 'react'
import PropTypes from 'prop-types';
// import image from '../../../../../../../public/images/foo/product-1.jpg'
// import image2 from '../../../../../../../public/images/foo/product-2.jpg'
import Swal from "sweetalert2";
import Store from "../../../../utils/store";





export default class ProductCardGrid extends Component {
    constructor(props) {
        super(props);
        this.state = {
            product: null,
            status: ''
        };

        this.changeActiveColor = this.changeActiveColor.bind(this);
        this.selectedColorClass = this.selectedColorClass.bind(this);
        this.selectedSizeClass = this.selectedSizeClass.bind(this);
        this.addToCart = this.addToCart.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        this.calcPrice = this.calcPrice.bind(this);
        // this.setStatus = this.setStatus.bind(this);
        // this.printStatus = this.printStatus.bind(this);

    }

    componentDidMount() {
        const self = this;
        setTimeout(function () {

            let product = self.props.product;
            product.active = false;
            product.sizes.map(function (size) {
                size.active = false;
                // product.colors.map(function(color){
                //     color.active=false;
                // });
            });
            self.setState({product: product});
//            console.log('products will mount', self.state.product);
        }, 100);

        setTimeout(function () {
        let sizes = this.state.product.sizes;
        let min=0;
        for(let i=0;i<sizes.length;i++){
            if(sizes[i].stock > min){
                min=sizes[i].stock;
            }
            if(min>0)
            {
                this.setState({status: "IN STOCK"})
            }
            else
            {
                this.setState({status: "OUT OF STOCK"})
            }
        }
        }, 150);
    }
    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }

    // setStatus() {
    //     let sizes = this.state.product.sizes;
    //     let min=0;
    //     for(let i=0;i<sizes.length;i++){
    //         if(sizes[i].stock > min){
    //             min=sizes[i].stock;
    //         }
    //         if(min>0)
    //         {
    //             this.setState({status: "IN STOCK"})
    //         }
    //         else
    //         {
    //             this.setState({status: "OUT OF STOCK"})
    //         }
    //     }
    // }
    //
    // printStatus(){
    //     this.setStatus();
    //     return this.state.status;
    //
    //
    // }

    changeActiveSize(sizeIndex) {
        const self = this;
        let product = this.props.product;
        product.sizes.map((size)=>{
            size.active =false;
        });
        product.sizes[sizeIndex].active = true;

        this.setState({product: product});
    }

    changeActiveColor(sizeIndex, colorIndex) {
        let product = this.props.product;
        console.log(product);
        product.sizes.map((size)=>{
            if(size.active===true) {
                size.colors.map((color) => {
                    color.active = false;
                }); }
        });
        product.sizes[sizeIndex].colors[colorIndex].active = true;

        this.setState({product: product});
    }

    selectedColorClass(sizeIndex, colorIndex){
        const self = this;
        let returnValue = '';
        // console.log('funkcija',this.state.product.sizes[sizeIndex]);
        // if(this.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
        //     return 'active';
        // }
        // else return '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    selectedSizeClass(sizeIndex){
        const self = this;
        let returnValue = '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    addToCart(index){
        const product = this.props.product;
        this.props.addToCartProduct(product, index);
    }


    handleSubmit(index){
        let valid = true;
        let product = this.props.product;
        for(let i = 0; i <product.sizes.length; i++) {
            if (product.sizes[i].active === true) {
                for (let k = 0; k < product.sizes[i].colors.length; k++) {
                    if (product.sizes[i].colors[k].active === true) {
                        this.setState({
                            ...this.state,
                            errorMessage: ""
                        });
                        valid=true;
                        break;
                    } else {
                        this.setState({
                            ...this.state,
                            errorMessage: "Veuillez sélectionner la couleur"
                        });
                        valid = false;
                    }
                }
                break;
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: "Veuillez sélectionner la taille"
                });
                valid = false;
            }
        }

        if(this.state.status === "EN RUPTURE DE STOCK"){
            valid = false;
            Swal.fire("L'article est en rupture de stock");
        }

        if(valid){
            this.addToCart(index);
            Swal.fire({
                title: '<strong>Ajouté au panier\n<strong>',
                icon: 'success',
                showCloseButton: true,
                showCancelButton: true,
                focusConfirm: false,
                confirmButtonText:
                    '<a className="white" href="/list">Continuez vos achats</a>' ,
                confirmButtonColor: '#fff',
                cancelButtonText:
                    '<a className="white" href="/cart">Aller au panier</a>'
            });
        }

    }

    render() {
        let product = this.props.product;
        // console.log('eden proizvod', product);
        let sizes = product.sizes;
        // console.log('sizes', sizes);

        let min=0;
        let status='';
        for(let i=0;i<sizes.length;i++){
            if(sizes[i].stock > min){
                min=sizes[i].stock;
            }
            if(min>0)
            {
                status = "EN STOCK";
            }
            else
            {
                status = "EN RUPTURE DE STOCK";
            }
        }

        let title = product.title;
        if (title.length > 20) {
            title = title.substring(0, 17) + "...";
        }
        let currency=this.props.currency;



        return (


            // <div className="col-lg-4 col-sm-6">
            <div className="single-product mt-30">
                <div className="product-image">
                    <a href={`/detailed/${product.id}`}>
                        <img className="product-1" style={{objectFit: 'contain', height: '302px', maxHeight: '302px'}} src={product.image} alt="product"/>
                        { product.images.length>1 ?
                            <React.Fragment>
                                <img className="product-2" style={{objectFit: 'contain', height:'302px', maxHeight: '302px'}}
                                     src={product.images[1].image} alt="product"/>
                            </React.Fragment> :
                            <React.Fragment>
                                <img className="product-2" style={{objectFit: 'contain', height:'312px', maxHeight: '312px'}}
                                     src={product.image} alt="product"/>
                            </React.Fragment>

                        }
                    </a>
                </div>
                <div className="product-content text-center">
                    <div className="product-content-top">

                        <h4 className="title"><a href={`/detailed/${product.id}`} style={{textTransform: 'uppercase'}}>{title} </a>
                        </h4>
                        <span className="sale-price" style={{color: '#6e6e6e', fontSize: '14px'}}>{product.price} {currency}</span>
                        {/*<span className="regular-price">$299</span>*/}
                        <p style={{color: "red", fontSize:'12px'}} >{this.state.errorMessage}</p>

                    </div>
                    <div className="product-cart">
                        <div className="product-size-color d-flex justify-content-between mt-0 pt-0" >
                            <ul className="product-size center-elem">
                                {sizes.map((size, sizeIndex) =>

                                    <li onClick={() => { this.changeActiveSize(sizeIndex) }}
                                        key={'top_product_color_'+sizeIndex}
                                        className={this.selectedSizeClass(sizeIndex)} >
                                        <span  style={{padding: '15px !important'}} >{size.size}</span>
                                    </li>
                                )
                                }
                            </ul>
                            <ul className="product-color">
                                {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                        <li style={{backgroundColor: color.color_code, border: '1px solid #bebebe', height: '18px', width: '18px'}} onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}
                                            key={'top_product_color_'+sizeIndex+'_'+colorIndex}
                                            className={this.selectedColorClass(sizeIndex, colorIndex)}>
                                            <span>  </span>
                                        </li>
                                    ) : null
                                )}
                            </ul>
                        </div>
                        <div>
                            {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                    color.active ?
                                        <React.Fragment>
                                            {color.stock > 0 ?
                                                <React.Fragment>
                                                    <label style={{
                                                        color: '#008000',
                                                        fontSize: '12px'
                                                    }}> disponible: {color.stock} </label>
                                                </React.Fragment>
                                                :
                                                <React.Fragment>
                                                    <label style={{
                                                        color: 'rgb(255, 57, 65)',
                                                        fontSize: '12px'
                                                    }}> disponible: {color.stock} </label>
                                                </React.Fragment>
                                            }

                                        </React.Fragment>
                                        :
                                        null

                                )
                                :
                                null
                            )}
                        </div>
                        <div style={{cursor: 'pointer'}} className="product-cart-btn mt-0 pt-0" onClick={() => { this.handleSubmit() }}>
                            <a className="cart-btn" ><i className="flaticon-shopping-cart"> </i>
                                <span>Ajouter au chariot</span></a>
                        </div>
                    </div>
                </div>
            </div>
            // </div>
        )
    }
}

ProductCardGrid.propTypes = {
    product: PropTypes.shape({
        id: PropTypes.number,
        title: PropTypes.string,
        price: PropTypes.string,
        description: PropTypes.string,
        status: PropTypes.number
    })
};



