import React, { Component } from 'react'
import Store from "../../../../utils/store";

export default class HomeProduct extends Component {

    constructor(props) {
        super(props);
        this.state = {
            errorMessage: '',
            product: null,

        }
        this.changeActiveColor = this.changeActiveColor.bind(this);
        this.selectedColorClass = this.selectedColorClass.bind(this);
        this.selectedSizeClass = this.selectedSizeClass.bind(this);
        this.addToCart = this.addToCart.bind(this);
        this.calcPrice = this.calcPrice.bind(this);
        this.handleSubmit=this.handleSubmit.bind(this);

    }
    componentDidMount(){
        const self = this;
        setTimeout(function(){

            let product = self.props.product;
            product.active=false;
            product.sizes.map(function(size){
                size.active=false;
            });
            self.setState({product: product});
        },100);
    }


    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }

    changeActiveSize(sizeIndex) {
        const self = this;
        let product = this.state.product;
        product.sizes.map((size)=>{
            size.active =false;
        });
        product.sizes[sizeIndex].active = true;

        this.setState({product: product});
    }

    changeActiveColor(sizeIndex, colorIndex) {
        let product = this.state.product;
        product.sizes.map((size)=>{
            if(size.active===true) {
                size.colors.map((color) => {
                    color.active = false;
                }); }
        });
        product.sizes[sizeIndex].colors[colorIndex].active = true;

        this.setState({product: product});
    }

    selectedColorClass(sizeIndex, colorIndex){
        const self = this;
        let returnValue = '';
        // if(this.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
        //     return 'active';
        // }
        // else return '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].colors[colorIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    selectedSizeClass(sizeIndex){
        const self = this;
        let returnValue = '';
        if(self.state.product != null){
            if(self.state.product.sizes[sizeIndex].active === true){
                returnValue = 'active';
            }
        }
        return returnValue;
    }

    addToCart(){
        const product = this.props.product;
        this.props.addToWishListProduct(product);
    }

    handleSubmit(){
        let valid = true;
        let product = this.props.product;
        for(let i = 0; i <product.sizes.length; i++) {
            if (product.sizes[i].active === true) {
                for (let k = 0; k < product.sizes[i].colors.length; k++) {
                    if (product.sizes[i].colors[k].active === true) {
                        this.setState({
                            ...this.state,
                            errorMessage: ""
                        });
                        valid=true;
                        break;
                    } else {
                        this.setState({
                            ...this.state,
                            errorMessage: "Please select color"
                        });
                        valid = false;
                    }
                }
                break;
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: "Please select size"
                });
                valid = false;
            }
        }

        if(valid){
            this.addToCart();
        }

    }


    render () {
        let product = this.props.product;
        let sizes = product.sizes;
        let title = product.title;
        if (title.length > 30) {
            title = title.substring(0, 27) + "...";
        }
        let currency = this.props.currency;

        return (
                            <div className="single-product-2 mt-30" style={{height: '550px', minHeight: '550px'}}>
                                <div className="product-image">
                                    <a  href={`/detailed/${product.id}`}>
                                        <img className="product-1" style={{objectFit: 'contain'}} src={product.image} alt="Product"/>
                                        <img className="product-2" style={{objectFit: 'contain'}} src={product.image} alt="product"/>
                                    </a>
                                </div>
                                <div className="product-content text-center">
                                    {/*<ul className="product-rating">*/}
                                    {/*    <li className="rating-on"><i className="flaticon-star"> </i></li>*/}
                                    {/*    <li className="rating-on"><i className="flaticon-star"> </i></li>*/}
                                    {/*    <li className="rating-on"><i className="flaticon-star"> </i></li>*/}
                                    {/*    <li><i className="flaticon-star"> </i> </li>*/}
                                    {/*    <li><i className="flaticon-star"> </i> </li>*/}
                                    {/*</ul>*/}
                                    <h4 className="titleList"  key={product.id}> <a href={`/detailed/${product.id}`}>{title} </a></h4>
                                    <span className="sale-price">{product.price} {currency}</span>
                                    {/*<span className="regular-price">$299</span>*/}
                                    {/*<div className="product-size-color d-flex justify-content-between">*/}
                                    {/*    <ul className="product-size">*/}
                                    {/*        {sizes.map((size, sizeIndex) =>*/}

                                    {/*            <li onClick={() => { this.changeActiveSize(sizeIndex) }}*/}
                                    {/*                key={'product_color_'+this.props.id+'_'+sizeIndex}*/}
                                    {/*                className={this.selectedSizeClass(sizeIndex)} >*/}
                                    {/*                <span>{size.size}</span>*/}
                                    {/*            </li>*/}
                                    {/*        )*/}
                                    {/*        }*/}
                                    {/*     </ul>*/}
                                    {/*     <ul className="product-color">*/}
                                    {/*         {sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>*/}
                                    {/*                 <li style={{backgroundColor: color.color.toLowerCase()}} onClick={() => { this.changeActiveColor(sizeIndex, colorIndex) }}*/}
                                    {/*                     key={'product_color_'+this.props.id+'_'+sizeIndex+'_'+colorIndex}*/}
                                    {/*                     className={this.selectedColorClass(sizeIndex, colorIndex)}>*/}
                                    {/*                     <span>  </span>*/}
                                    {/*                 </li>*/}
                                    {/*             ) : null*/}
                                    {/*         )}*/}
                                    {/*     </ul>*/}
                                    {/* </div>*/}
                                    {/* <span style={{color: "red"}} >{this.state.errorMessage}</span>*/}

                                    <div className="product-cart-btn pt-3">
                                        <a className="cart-btn" href={`/detailed/${product.id}`}><i className="fa fa-eye" aria-hidden="true"> </i>
                                            <span >Détails</span></a>
                                        {/*<a className="wishlist"  style={{marginLeft: '15px', size: '18px'}} onClick={() => { this.handleSubmit() }}><i className="flaticon-heart"> </i></a>*/}
                                    </div>

                                 </div>
                             </div>
        )
    }
}


