import React, {Component} from 'react';
import Store from '../../../utils/store'
import Swal from "sweetalert2";





export default class DiscountCouponPart extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');

        this.state = {
            store:store,
            coupons: [
                {
                    image: '',
                    id: '',
                    price: '',
                    type: '',
                    status
                }
            ]
        }

        this.warningMessage = this.warningMessage.bind(this);
    }
    async UNSAFE_componentWillMount() {
        await this.state.store.api_post_call('getCoupons', {}).then(res=> {
            this.setState({coupons : res.data.values})
            console.log('coupon', res.data.values);


        }).catch(err => {
            console.log(err);
        });
    }


    warningMessage(){
        Swal.fire("Please login first", "and get available discount offers", "warning");
    }


    render () {
        let isLogged = this.props.isLogged;


        return (
            <section className="banner-area-4 pt-50 pb-100">
                <div className="container">
                    <div className="row justify-content-center">


                        {
                            this.state.coupons.map(collection =>
                                <div  key={collection.id} className="col-lg-6 col-md-7 col-sm-10 p-20 m-20">

                                    <div className="single-banner-4 text-center mt-30">
                                        <div className="coupon-image" style={{height: '270px', maxHeight: '270px'}}>
                                            {/*<img src={img3} alt=""/>*/}
                                            <img style={{objectFit: 'contain !important'}}  src={collection.image} alt=""/>
                                            {/*<img style={{objectFit: 'contain'}} className="banner-image-size" src={collection.image} alt=""/>*/}
                                        </div>

                                        {
                                            isLogged ?
                                                <React.Fragment>
                                                    <div className="banner-content">
                                                        {/*<h4 className="title"><a href="/list">{collection.description} <br/> {collection.title}</a></h4>*/}
                                                        <a href="/offer" className="main-btn">Get Discount</a>
                                                    </div>
                                                </React.Fragment>
                                                :
                                                <React.Fragment>
                                                    <div className="banner-content">
                                                        {/*<h4 className="title"><a href="/list">{collection.description} <br/> {collection.title}</a></h4>*/}
                                                        <a style={{cursor: 'pointer'}} data-toggle="modal" data-target="#loginModal" className="main-btn">Get Discount</a>
                                                    </div>
                                                </React.Fragment>
                                        }

                                        <span className="discount">{parseInt(collection.price)}{collection.type} Off Now</span>
                                    </div>
                                </div>


                            )}

                    </div>
                </div>

                <div className="modal fade" id="loginModal" data-backdrop="static" data-keyboard="false"
                     tabIndex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                    <div className="modal-dialog d-block " style={{marginTop: '10% ', marginBottom: '15% ', height: '30%', maxHeight: '50%'}}>
                        <div className="modal-content" style={{marginTop: '35%'}}>

                            <div style={{padding: '20px'}} ><i data-dismiss="modal" style={{float:'right', fontSize: '15px', cursor: 'pointer'}} className="fa fa-times" aria-hidden="true"> </i> </div>

                            <section className="login-area pt-80" >
                                <div className="container">
                                    <div className="row justify-content-center">
                                        <div className="col-10">
                                            <div className="login-form text-center">
                                                <h4 className="title" >Login to Your Account</h4>
                                                <form action="#">
                                                    <div className="single-form">
                                                        <input type="email" placeholder="Username or Email"/>
                                                    </div>
                                                    <div className="single-form">
                                                        <input type="password" placeholder="Enter your Password"/>
                                                    </div>
                                                    <div className="single-form">
                                                        <button className="main-btn" type="submit">Login</button>
                                                        <p>No account? <a className="register" data-dismiss="modal" data-toggle="modal" data-target="#signupModal" style={{color: '#e06377', cursor: 'pointer'}}>Create
                                                            one here.</a></p>
                                                    </div>
                                                    <div className="single-form">
                                                        <ul className="remember-forgot d-flex justify-content-between">
                                                            <li>
                                                                <input type="checkbox" name="checkbox" id="checkbox"/>
                                                                <label htmlFor="checkbox"><span></span>Remember
                                                                    Me</label>
                                                            </li>
                                                            <li>
                                                                <p> <a href="#"> Forgot password?</a></p>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>


                        </div>
                    </div>
                </div>
            </section>

        )
    }}


