import  React, { Component } from 'react'
import Store from '../../utils/store';



export default class WishProduct extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');

        this.state = {
            store:store
        }

        this.addToCart=this.addToCart.bind(this);
        this.calcPrice=this.calcPrice.bind(this);
    }

    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies,val);
    }

    addToCart(index){
        const product = this.props.product;
        this.props.addToCartProduct(product, index);
    }

    render () {
        let product = this.props.product;
        let indexProduct = this.props.indexProduct;
        let currency = this.props.currency;

        let description = product.description;
        let title = product.title;

        if (description!="" && description.length > 30) {
            description = description.substring(0, 30) + "...";
        }
        if (title!="" && title.length > 15) {
            title = title.substring(0, 15) + "...";
        }

        return (
            <tr>
                <td>
                    <div className="product-img"><img
                        src={product.image} alt="Product"/></div>
                </td>
                <td>
                    <div className="product-description">
                        <h6 className="product-title"><a href="#">
                            {description}
                        </a></h6>

                        <div><i className="sizes-size">Taille: {product.sizes.map((s,sizeIndex) =>
                            <span>{s.active === true ? <span>  {s.size} </span> : null}
                            </span>
                        )
                        }
                        </i>
                        </div>
                        <div className="product-size-color">
                            <ul className="product-color">
                                <i className="sizes-size">{product.sizes.map((size, sizeIndex) => size.active ? size.colors.map((color, colorIndex) =>
                                    <React.Fragment>
                                        {color.active ?
                                            <li style={{backgroundColor: color.color_code, border: '1px solid lightgray'}}
                                              className='color-circle'>
                                                <span>  </span>
                                            </li> : null
                                        }
                                    </React.Fragment>

                                    ) : null
                                )}
                                </i>
                            </ul>

                        </div>

                    </div>
                </td>
                <td>
                    <div className="product-model">
                        <p>
                            {title}
                        </p>
                    </div>
                </td>
                <td>
                    <div className="product-price">
                        <p>{product.price} {currency}
                            {/*{wishProduct.sellPrice}*/}
                        </p>
                    </div>
                </td>

                <td>
                    <div className="product-edit">
                        <button className='btn btn-danger btn-sm addToCart' style={{backgroundColor:'#e06377'}}
                            onClick={()=>this.addToCart(indexProduct)}><i className='flaticon-shopping-cart ' aria-hidden="true"> Ajouter au chariot </i></button>
                        <ul>
                            {/*<li><a href="#"><i className="fal fa-pencil-alt"> </i></a></li>*/}
                            <li></li>
                        </ul>
                    </div>
                </td>
                <td style={{width:'7%'}}>
                    <div className="product-edit">
                        <button className='btn  btn-sm  bin' title="Remove product"  onClick={()=>this.props.deleteWishProduct(indexProduct)}><i className="fal fa-trash-alt"> </i></button>
                        <ul>
                            {/*<li><a href="#"><i className="fal fa-pencil-alt"> </i></a></li>*/}
                            <li></li>
                        </ul>
                    </div>
                </td>
            </tr>
        )


    }

}
