import React,{ Component } from 'react'
import slider2 from "../../../../../public/assets/images/cover.jpg";
import Swal from "sweetalert2";

export default class SentMessage extends Component {

    constructor(props) {
        super(props);
        this.state = {
            errorMessage: '',
            ticket:{
                subject: '',
                message: ''
            }

        }
        this.inputSubject = this.inputSubject.bind(this);
        this.inputMessage = this.inputMessage.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
        this.showTicketInChat = this.showTicketInChat.bind(this);
    }

    inputSubject(event) {
        console.log('subject', event.target.value);
        this.setState({
            ...this.state,
            ticket: {
                ...this.state.ticket,
                subject:event.target.value
            }
        });
    }

    inputMessage(event) {
        console.log('message', event.target.value);
        this.setState({
            ...this.state,
            ticket: {
                ...this.state.ticket,
                message:event.target.value
            }
        });
    }

    showTicketInChat() {
        const subject = this.state.ticket.subject;
        const message = this.state.ticket.message;

        this.props.addTicket({
            subject,
            message
        });
    }

    handleSubmit() {
        let valid=true;
        const subject = this.state.ticket.subject;
        const message = this.state.ticket.message;
        if (!subject || !message) {
            this.setState({
                ...this.state,
                errorMessage: "Please fill in all required fields."
            });
            valid = false;
        }
        if (valid) {
            this.setState({
                ...this.state,
                errorMessage: ""
            });
            Swal.fire("Your message has been successfully sent!", "We will contact you very soon! Thank you for contacting us.", "success");
            // const add = this.showTicketInChat;
            // add();
        }
    }




    render () {

        return (
            <React.Fragment>
                <div className="col-lg-9">
                    <div className="contact-form mt-45">
                        <h4 className="contact-title">You have a question?</h4>
                        <div>
                            <span style={{color: "red"}} >{this.state.errorMessage}</span>
                        </div>
                        <br/>
                        <form id="contact-form" method="post" data-toggle="validator">
                            <div className="row">

                                <div className="col-md-11">
                                    <div className="single-form form-group">
                                        <label>Subject :</label>
                                        <input type="text" className="form-control"  name="subject" onChange={this.inputSubject} data-error="Subject is required."
                                               required="required"/>
                                        <div className="help-block with-errors" > </div>
                                    </div>
                                </div>
                                <div className="col-md-11">
                                    <div className="single-form form-group">
                                        <label>Write a Message :</label>
                                        <textarea name="message" className="form-control" onChange={this.inputMessage} data-error="Please,leave us a message." rows="10"> </textarea>
                                        <div className="help-block with-errors"> </div>
                                    </div>
                                </div>
                                <p className="form-message"> </p>
                                <div className="col-md-12">
                                    <div className="single-form form-group">
                                        <button className="main-btn" type="button" onClick={this.handleSubmit}>Submit</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </React.Fragment>

        )
    }
}


