import  {Component} from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'
import Product from './Product'
import { Link } from 'react-router-dom'
import {  MDBRow, MDBCol, MDBIcon,  MDBInput, MDBBtn , MDBContainer } from "mdbreact"
import FooterPart from '../mainComponents/FooterPart'
import {Redirect} from 'react-router-dom'




const ProductsPageContainer = styled.div`
  background-color:   white;

  padding: 10% 10%;
`;

const Header = styled.div`
  padding-bottom: 20px;
  h1 {
    display: block;
    margin: 0;
    font-size: 48px;
    color: #8597A3;
  }
`;

const ProductsContainer = styled.div`
  width: 100%;
  display: flex;
  flex-wrap: wrap;
  justify-content: space-between;
`;

const Hr = styled.hr`

`;



export default class ProductsList extends Component {
    constructor(props) {
        super(props);

    }


    render() {
        const { products } = this.props;
        console.log("PRODUCTS", products)
        console.log("VID OBJEKT", typeof products, {products})
        const visibleProducts = products

        return (
            <div>


                <MDBContainer>
                    <ProductsPageContainer>

                        {/*<img src={cover} className="img-fluid z-depth-1 " alt="" />*/}




                        <MDBRow>
                            <MDBCol md="12" className="mb-3">

                                {/* <img className="img" src={cover}/> */}
                                <Hr/>
                                <ProductsContainer>
                                    {
                                        visibleProducts &&
                                        visibleProducts.map((product) => <Product product={product} />)}
                                </ProductsContainer>

                                <Hr/>


                                <MDBBtn outline color="secondary">
                                    <Link to="/addProduct"> </Link><MDBIcon far icon="plus-square" className="ml-1"/>
                                </MDBBtn>

                                <Hr/>
                                {/* <div>
                        <ExtendButton onClick={this.toggleExpanded}>{(this.state.expanded ? <i style={{fontSize: 50}}></i> : <i style={{fontSize: 40}}></i>)}</ExtendButton>
                    </div>*/}

                            </MDBCol>
                        </MDBRow>


                    </ProductsPageContainer>

                </MDBContainer>
                <FooterPart/>
            </div>
        );
    }
}

ProductsList.propTypes = {
    products: PropTypes.arrayOf(PropTypes.shape({
    }))
};

