import React from 'react'
import styled from 'styled-components'
import PropTypes from 'prop-types'

const Card = styled.div`
    margin: 1.5%;
    width: 30%;
    background-color: #E4CFBE;
      font-family: Vedana;
      cursor: pointer;
`;

const Image = styled.div`
height: 100%;
width: 100%;
object-fit: fill;
`;

const InfoContainer = styled.div`
  background-color: white;
  padding: 20px 0 10px 0;

    text-align: center;
    font-size: 30px;

`;

const ImageContainer = styled.div`
`;

const Title = styled.h1`
  color: #4A545A;
  margin: 0 0 9.76px;
  font-size: 20px;


`;

const Desc = styled.h1`
  margin-top: 0 0 9.76px;
  font-size: 15px;
  color: #4C5357;

`;

const Price = styled.h1`
  color: #8597A3;
  font-size: 13px;
  display: flex;
  background-color: #E4CFBE;
  padding: 3px 8px;

`;


const Product = ({ product }) => {

    return (

        <Card onClick={"window.location='http://google.com';"}>
            <InfoContainer>
                {/* <Image>
                     <img src={pic}/>
                </Image> */}

                <Title>
                    {product.name}
                </Title>
                <Desc>
                    {product.description}

                </Desc>
                <Price>
                    {product.price}
                </Price>

            </InfoContainer>
        </Card>

    )
};

Product.propTypes = {
    product: PropTypes.shape({
        id: PropTypes.string,
        name: PropTypes.string,
        description: PropTypes.string,
        price: PropTypes.number,
        status: PropTypes.bool,
        image: PropTypes.string
    })
};

export default Product;
