import React,{ Component } from 'react'
import slider2 from "../../../../../public/assets/images/cover35.jpg";
// import Swal from "sweetalert2";
import SentMessage from "../Support/SentMessage";
import Store from "../../utils/store";
import copy from "copy-to-clipboard";
import SingleOfferCard from "./SingleOfferCard";
// import './CopyBoard.css';



export default class Offer extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');

        this.state = {
            store: store,
            coupons: [{
                type: '',
                code: '',
                price: '',
                end_date: ''
            }],
            config: {
                address: '',
                tel: '',
                main_email: '',
                hotline_support: '',
                hotline_num: ''
            },
            textToCopy: '',

        }

        this.copytext = this.copytext.bind(this);
        this.handleInputChange = this.handleInputChange.bind(this);


    }
    async componentDidMount () {
        await this.state.store.api_post_call('getShopConfig', {}).then(res=> {
            this.setState({config:  res.data.values});
            // console.log('config', res.data.values);

        }).catch(err => {
            console.log(err);
        })

    }
    async componentWillMount() {
        await this.state.store.api_post_call('getCoupons', {}).then(res=> {
            this.setState({coupons : res.data.values})
            console.log('coupon offer', res.data.values);


        }).catch(err => {
            console.log(err);
        });
    }

    copytext() {
        copy(this.state.textToCopy);
    }

    handleInputChange(e) {
        this.setState({
            textToCopy: e.target.value,
        });
    }



    render () {

        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Home</a></li>
                            <li className="breadcrumb-item active">Contact</li>
                        </ol>
                    </div>
                </section>

                <section className="contact-area pt-30 pb-100 ">
                    <div className="container">
                        <div className='row '>
                                {this.state.coupons.map( (coupon,couponIndex) =>
                                    <div className='col-lg-4 col-md-6 col-xs-12'>
                                        <SingleOfferCard
                                            coupon={coupon}
                                            couponIndex={couponIndex}
                                        />

                                    </div>
                                )
                                }
                        </div>
                        <a href='/checkout' className='apply p-t-15'  >Apply Code</a>
                    </div>
                </section>

            </div>




        )
    }
}


