import React, { Component } from 'react'
import Swal from "sweetalert2";
import slider2 from "../../../../../public/assets/images/cover31.jpg";

import Store from "../../utils/store";
import { StickyContainer, Sticky } from 'react-sticky';


export default class Checkout extends Component {

    constructor(props) {
        super(props);
        const store = new Store('mangopaid');
        this.state = {
            // store: store,
            secondStore: store,

            store: {
                loggedUser: {
                    name: '',
                    address: '',
                    email: '',
                    city: '',
                    zip: '',
                    tel: ''
                },
                updatedGuest: {
                    name: '',
                    address: '',
                    email: '',
                    city: '',
                    zip: '',
                    tel: ''
                }
            },
            user: {
                address: '',
                city: '',
                zip: '',
                tel: ''
            },
            cartProds: [],
            cardNumber: '',
            cvv: '',
            month: '',
            year: '',
            guest: {
                name: '',
                email: '',
                tel: '',
                address: '',
                city: '',
                zip: '',
            },
            paymentOption: '',
            deliveryOption: '',
            couponCode: '',
            coupons: null,
            invalidCodeMessage: '',
            totalPrice: '',
            productsPrice: '',
            discount: 0,
            sh_fee: 0,
            totalIncludesShipping: 0,
            totalIncludesPayment: 0,
            TOTALTOTAL: 0

        }
        this.placeOrder = this.placeOrder.bind(this);
        this.inputCardNumber = this.inputCardNumber.bind(this);
        this.inputCVV = this.inputCVV.bind(this);
        this.inputMonth = this.inputMonth.bind(this);
        this.inputYear = this.inputYear.bind(this);
        this.makeOrder = this.makeOrder.bind(this);
        this.inputGuestName = this.inputGuestName.bind(this);
        this.inputTel = this.inputTel.bind(this);
        this.inputGuestEmail = this.inputGuestEmail.bind(this);
        this.inputGuestAddress = this.inputGuestAddress.bind(this);
        this.inputGuestCity = this.inputGuestCity.bind(this);
        this.inputGuestZip = this.inputGuestZip.bind(this);
        this.setPayment = this.setPayment.bind(this);
        this.setDelivery = this.setDelivery.bind(this);
        this.inputCouponCode = this.inputCouponCode.bind(this);
        this.applyCouponCode = this.applyCouponCode.bind(this);
        this.calculateTotal = this.calculateTotal.bind(this);
        this.setDiscount = this.setDiscount.bind(this);
        this.calcPrice = this.calcPrice.bind(this);
        this.setTotalPrice = this.setTotalPrice.bind(this);
        this.inputZipLogged = this.inputZipLogged.bind(this);
        this.inputCityLogged = this.inputCityLogged.bind(this);
        this.inputAddressLogged = this.inputAddressLogged.bind(this);
        this.inputTelLogged = this.inputTelLogged.bind(this);
        this.saveUser = this.saveUser.bind(this);
        this.paypalCompleted = this.paypalCompleted.bind(this);
        this.checkData = this.checkData.bind(this);
        this.saveGuest = this.saveGuest.bind(this);

    }

    inputCouponCode(event) {
        // console.log('coupon', this.state.couponCode);
        this.setState({
            ...this.state,
            couponCode: event.target.value

        });
    }

    calcPrice(val) {
        let store = null;
        store = new Store('mangopaid');
        return store.calculateCurrencies(this.props.calculateCurrencies, val);
    }

    inputCardNumber(event) {
        this.setState({
            ...this.state,
            cardNumber: event.target.value,

        });
    }

    inputCVV(event) {
        this.setState({
            ...this.state,
            cvv: event.target.value
        });
    }

    inputMonth(event) {
        this.setState({
            ...this.state,
            month: event.target.value
        });
    }

    inputYear(event) {
        this.setState({
            ...this.state,
            year: event.target.value
        });
    }

    inputGuestName(event) {
        this.setState({
            ...this.state,
            guest: {
                ...this.state.guest,
                name: event.target.value
            }
        });
    }

    inputGuestEmail(event) {
        this.setState({
            ...this.state,
            guest: {
                ...this.state.guest,
                email: event.target.value
            }
        });
    }

    inputTel(event) {
        this.setState({
            ...this.state,
            guest: {
                ...this.state.guest,
                tel: event.target.value
            }
        });
    }

    inputTelLogged(event) {
        this.setState({
            ...this.state,
            user: {
                ...this.state.user,
                tel: event.target.value
            }
        });
    }

    inputAddressLogged(event) {
        this.setState({
            ...this.state,
            user: {
                ...this.state.user,
                address: event.target.value
            }
        });
    }

    inputCityLogged(event) {
        this.setState({
            ...this.state,
            user: {
                ...this.state.user,
                city: event.target.value
            }
        });
    }

    inputZipLogged(event) {
        this.setState({
            ...this.state,
            user: {
                ...this.state.user,
                zip: event.target.value
            }
        });
    }

    inputGuestAddress(event) {
        this.setState({
            ...this.state,
            guest: {
                ...this.state.guest,
                address: event.target.value
            }
        });
    }

    inputGuestCity(event) {
        this.setState({
            ...this.state,
            guest: {
                ...this.state.guest,
                city: event.target.value
            }
        });
    }

    inputGuestZip(event) {
        this.setState({
            ...this.state,
            guest: {
                ...this.state.guest,
                zip: event.target.value
            }
        });

    }

    async componentDidMount() {
        const store = new Store('mangopaid');
        let ss = store.get();
        ss.updatedGuest = {
            name: '',
            address: '',
            email: '',
            city: '',
            zip: '',
            tel: ''
        };
        await this.setState({store: ss});
        const user = this.state.store.loggedUser;
        console.log('storeeee---',this.state.store);

        this.state.secondStore.api_post_call('getCoupons', {}).then(res => {
            this.setState({coupons: res.data.values})
            console.log('coupon', res.data.values);


        }).catch(err => {
            console.log(err);
        });
        // let self = this;
        // window['paypal'].Buttons({
        //     style: {
        //         shape: 'pill',
        //         color: 'gold',
        //         layout: 'horizontal',
        //         label: 'paypal',
        //     },
        //     createOrder: function (data, actions) {
        //         return actions.order.create({
        //             purchase_units: [{
        //                 "amount": {
        //                     "currency_code": "EUR",
        //                     "value": parseFloat(self.state.productsPrice) + parseFloat(self.props.shipping_fee)
        //                 }
        //             }],
        //             application_context: {"shipping_preference": "NO_SHIPPING"}
        //         });
        //     },
        //     onApprove: function (data, actions) {
        //         // self.loading = true;
        //         return actions.order.capture().then(function (details) {
        //             console.log('paypal', details);
        //             if (details.status === 'COMPLETED') {
        //                 self.paypalCompleted(details);
        //             } else {
        //                 // self.lodaing = false;
        //                 alert('Paypal payment has not been completed.');
        //             }
        //         });
        //     },
        //     onError: function (err) {
        //         console.log(err);
        //     }
        // }).render('#paypal-button-container');

        console.log('adasda123123sd');
        if(this.props.isLogged){
            console.log('adasdasdasdsadasd');
            if(user.zip != null && user.tel!=null && user.address != null && user.city!=null)
             {
                 console.log('adasdasd');
                let self = this;
                window['paypal'].Buttons({
                    style: {
                        shape: 'pill',
                        color: 'gold',
                        layout: 'horizontal',
                        label: 'paypal',
                    },
                    createOrder: function (data, actions) {
                        return actions.order.create({
                            purchase_units: [{
                                "amount": {
                                    "currency_code": "EUR",
                                    "value": parseFloat(self.state.productsPrice) + parseFloat(self.props.shipping_fee)
                                }
                            }],
                            application_context: {"shipping_preference": "NO_SHIPPING"}
                        });
                    },
                    onApprove: function (data, actions) {
                        // self.loading = true;
                        return actions.order.capture().then(function (details) {
                            console.log('paypal', details);
                            if (details.status === 'COMPLETED') {
                                self.paypalCompleted(details);
                            } else {
                                // self.lodaing = false;
                                alert('Paypal payment has not been completed.');
                            }
                        });
                    },
                    onError: function (err) {
                        console.log(err);
                    }
                }).render('#paypal-button-container');
            }

        }
    }

    paypalCompleted(ppdetails) {
        let shippingOption = this.state.deliveryOption;
        let couponCode = this.state.couponCode;
        let dataCart = this.state.cartProds;
        let products = [];
        for (let i = 0; i < dataCart.length; i++) {
            // let p={id: p_id, details: {size: s_id, color: c_id}};
            let product = dataCart[i];
            let sizes = product.sizes;
            for (let j = 0; j < sizes.length; j++) {
                if (sizes[j].active === true) {
                    let colors = sizes[j].colors;
                    for (let k = 0; k < colors.length; k++) {
                        if (colors[k].active === true) {
                            let p_id = product.id;
                            let s_id = sizes[j].id;
                            let c_id = colors[k].id;
                            let product_quantity = product.quantity;
                            let p = {id: p_id, details: {size: s_id, color: c_id, quantity: product_quantity}};
                            products.push(p);
                        }
                    }
                }
            }
        }
        // console.log('tel', this.state.guest.tel)

        let user = null;
        if (this.props.isLogged)
            user = null;
        else {
            user = {
                id: 0,
                name: this.state.guest.name,
                email: this.state.guest.email,
                address: this.state.guest.address,
                city: this.state.guest.city,
                tel: this.state.guest.tel,
                zip: this.state.guest.zip
            }
        }

        let paypal_payment = JSON.stringify(ppdetails);


        let params = {
            paypal_payment: paypal_payment,
            method: shippingOption,
            schedule: 'paypal',
            products: JSON.stringify(products),
            user: JSON.stringify(user), // {id: 0, email: , name: },
            coupon: couponCode
        }
        this.state.secondStore.api_post_call('placeOrder', params).then(res => {
            console.log('place order', res.data);
            if (res.data.status) {
                Swal.fire("Bon choix!!", "Votre commande a réussi!", "success");
            }
            else {

                Swal.fire("Erreur!", res.data.message, "warning");
            }

        }).catch(err => {
            Swal.fire("Données invalides!", "Une erreur est survenue", "warning");
            console.log(err);
        })
        console.log('my params', params);

    }

    checkData() {
        if(this.state.guest.name=='' || this.state.guest.email=='' ||
            this.state.guest.address=='' || this.state.guest.city=='' || this.state.guest.tel==''
            || this.state.guest.zip=='')
        {
            return false;
        } else {
            return true;
        }
    }
    async UNSAFE_componentWillMount() {

        // let storeData =  this.state.store.get();
        const store = new Store('mangopaid');
        await this.setState({store: store.get()});
        const self = this;
        self.setState({cartProds: self.state.store.cart});
        self.setState({guest: self.state.store.updatedGuest});

        let total = 0;
        let dataCart = self.state.store.cart;

        for (let i = 0; i < dataCart.length; i++) {
            total += parseInt(dataCart[i].quantity * dataCart[i].price);

        }
        this.setState({
            totalPrice: total,
            productsPrice: total,
            TOTALTOTAL: total
        })
    }

    setDiscount(val) {
        this.setState({
            discount: val
        })
    }

    setTotalPrice(val) {
        this.setState({
            totalPrice: val
        })
    }

    async applyCouponCode() {
        let oldTotal = this.state.totalPrice;
        let coupons = this.state.coupons;
        let TOTAL = this.state.TOTALTOTAL;
        let flag = false;
        let code = this.state.couponCode;
        let setDiscount = 0;
        let setNewTotal = 0;
        let setTotal = 0;


        if (this.state.discount === 0) {

            for (let i = 0; i < coupons.length; i++) {
                if (coupons[i].code === code) {
                    flag = true;
                    if (coupons[i].type === "%") {
                        setNewTotal = parseFloat(oldTotal) - parseFloat(oldTotal) * (parseFloat(coupons[i].price) / 100);
                        setDiscount = parseFloat(oldTotal) * (parseFloat(coupons[i].price) / 100);
                    } else {
                        setNewTotal = parseFloat(oldTotal) - parseFloat(coupons[i].price);
                        setDiscount = parseFloat(coupons[i].price);
                    }


                    if (TOTAL === oldTotal) {
                        setTotal = setNewTotal;
                    } else {
                        setTotal = TOTAL - this.state.discount;
                    }

                    console.log('discount ', setDiscount);
                    console.log('Total Price ', setNewTotal);
                    await this.setState({
                        totalPrice: setNewTotal,
                        discount: setDiscount,
                        TOTALTOTAL: setTotal
                    })

                    console.log('disc', this.state.discount);
                    console.log('newT', this.state.totalPrice);
                    console.log('TOTAL TOTAL', this.state.TOTALTOTAL);

                    Swal.fire("Coupon appliqué avec succès!");
                }
            }
        } else if (this.state.discount !== 0) {
            flag = true;
            Swal.fire("Vous avez appliqué le code promo!");
        }

        if (flag === false) {
            Swal.fire("Code invalide!");
        }

    }

    async calculateTotal() {
        let productsPrice = parseFloat(this.state.productsPrice);
        // let min_o_fee = parseFloat(this.props.min_o_fee);
        // let processing_fee = parseFloat(this.props.processing_fee);
        let shipping_fee = parseFloat(this.props.shipping_fee);
        let superTotal = productsPrice + shipping_fee;


        console.log('superTotal', superTotal);
        console.log('productsPrice', productsPrice);

        this.setState({
            productsPrice: parseFloat(productsPrice),
            totalIncludesShipping: parseFloat(superTotal),
            TOTALTOTAL: parseFloat(superTotal)
        });


        console.log('TOTAL', this.state.TOTALTOTAL);


    }


    makeOrder() {
        let dataCart = this.state.cartProds;
        let products = [];
        for (let i = 0; i < dataCart.length; i++) {
            // let p={id: p_id, details: {size: s_id, color: c_id}};
            let product = dataCart[i];
            let sizes = product.sizes;
            for (let j = 0; j < sizes.length; j++) {
                if (sizes[j].active === true) {
                    let colors = sizes[j].colors;
                    for (let k = 0; k < colors.length; k++) {
                        if (colors[k].active === true) {
                            let p_id = product.id;
                            let s_id = sizes[j].id;
                            let c_id = colors[k].id;
                            let product_quantity = product.quantity;
                            let p = {id: p_id, details: {size: s_id, color: c_id, quantity: product_quantity}};
                            products.push(p);
                        }
                    }
                }
            }
        }
        // console.log('view order', products);
        this.placeOrder(products);
    }

    async setPayment(str) {
        await this.setState({
            paymentOption: str
        })
        let paymentOption = this.state.paymentOption;

        let productsPrice = parseFloat(this.state.productsPrice);
        let processing_fee = parseFloat(this.props.processing_fee);
        let totalIncludesShipping = parseFloat(this.state.totalIncludesShipping);
        let totalIncludesPFee = 0;


        if (this.state.paymentOption === 'CC') {
            if (this.state.totalIncludesShipping === 0) {
                totalIncludesPFee = productsPrice + processing_fee;
            } else {
                totalIncludesPFee = this.state.totalIncludesShipping + processing_fee;
            }

        }
        console.log('total after payment option', totalIncludesPFee);
        this.setState({
            totalIncludesPayment: totalIncludesPFee
        })

        if (this.state.totalIncludesShipping !== 0) {
            this.setState({
                TOTALTOTAL: totalIncludesPFee
            })
        }

    }

    setDelivery(str) {
        this.setState({
            deliveryOption: str
        })
    }


    placeOrder(products) {
        let shippingOption = this.state.deliveryOption;
        let couponCode = this.state.couponCode;
        // console.log('tel', this.state.guest.tel)

        if (this.state.paymentOption === 'POD') {
            let user = null;
            if (this.props.isLogged)
                user = null;
            else
                user = {
                    id: 0,
                    name: this.state.guest.name,
                    email: this.state.guest.email,
                    address: this.state.guest.address,
                    city: this.state.guest.city,
                    tel: this.state.guest.tel,
                    zip: this.state.guest.zip
                }


            let params = {
                method: shippingOption,
                schedule: 'POD',
                products: JSON.stringify(products),

                user: JSON.stringify(user), // {id: 0, email: , name: },
                coupon: couponCode
            }
            this.state.secondStore.api_post_call('placeOrder', params).then(res => {
                console.log('place order', res.data);
                if (res.data.status) {
                    Swal.fire("Bon choix!!", "Votre commande a réussi!", "success");
                } else {

                    Swal.fire("Erreur!", res.data.message, "warning");
                }

            }).catch(err => {
                Swal.fire("Données invalides!", "Une erreur est survenue", "warning");
                console.log(err);
            })
            console.log('my params', params);

        } else {
            let valid = true;
            if (this.state.cardNumber.length != 16)
                valid = false;
            if (this.state.cvv.length != 3)
                valid = false;
            if (this.state.month > 12 || this.state.month < 1)
                valid = false;
            if (this.state.year < 20 && this.state.year > 99)
                valid = false;
            if (valid === true) {

                let user = null;
                if (this.props.isLogged)
                    user = null;
                else
                    user = {
                        id: 0,
                        name: this.state.guest.name,
                        email: this.state.guest.email,
                        tel: this.state.guest.tel,
                        address: this.state.guest.address,
                        city: this.state.guest.city,
                        zip: this.state.guest.zip
                    }


                let params = {
                    method: 'CC',
                    schedule: 'delivery',
                    products: JSON.stringify(products),
                    user: JSON.stringify(user), // {id: 0, email: , name: }
                    card_details: JSON.stringify({
                        number: this.state.cardNumber,
                        exp_month: this.state.month,
                        exp_year: this.state.year,
                        cvc: this.state.cvv
                    }),
                    coupon: couponCode
                }
                console.log('print params', params);
                this.state.secondStore.api_post_call('placeOrder', params).then(res => {
                    console.log('place order', res.data);
                    if (res.data.status) {
                        Swal.fire("Bon choix!", "Votre commande a réussi!", "success");
                    } else {

                        Swal.fire("Erreur!", res.data.message, "warning");
                    }

                }).catch(err => {
                    Swal.fire("Données invalides!", "Une erreur est survenue", "warning");
                    console.log(err);
                })
                console.log('my params', params);


            } else
                Swal.fire("ATTENTION", "La carte saisie n'est pas valide. Vérifiez que tous les détails sont corrects.", "warning");
        }
    }



    // placeOrder(products){
    //     let shippingOption = this.state.deliveryOption;
    //     let paymentOption = this.state.paymentOption;
    //     // let couponCode = this.state.couponCode;
    //
    //
    //         let user=null;
    //         if(this.props.isLogged)
    //             user = null;
    //         else
    //             user = {id:0, name: this.state.guest.name ,email: this.state.guest.email,tel: this.state.guest.tel,address:this.state.guest.address , city: this.state.guest.city ,zip: this.state.guest.zip }
    //
    //
    //         let params = {
    //             method: paymentOption,
    //             schedule: 'delivery',
    //             currency:  this.state.secondStore.get().currency,
    //             products: JSON.stringify(products),
    //             user: JSON.stringify(user) // {id: 0, email: , name: },
    //             // coupon: couponCode
    //         }
    //         this.state.secondStore.api_post_call('placeOrder', params).then(res=> {
    //             console.log('place order', res.data);
    //             if (res.data.status) {
    //                 Swal.fire("Good choice!", "Your order was successful!", "success");
    //             }
    //
    //         }).catch(err => {
    //             Swal.fire("Invalid data!", "An error has occurred", "warning");
    //             console.log(err);
    //         })
    //
    //
    // }
    saveUser(){
        let newUser = this.state.store.loggedUser;
        if(newUser.tel==null){newUser.phone = this.state.user.tel;}
        if(newUser.address==null){newUser.address = this.state.user.address;}
        if(newUser.zip==null){newUser.zip = this.state.user.zip;}
        if(newUser.city==null){newUser.city = this.state.user.city;}
        this.state.secondStore.api_post_call('updateUser', newUser).then(res => {
            if (res.data.status) {
                this.state.secondStore.saveLoggedUser(res.data.values);
                Swal.fire('Succès!', res.data.message, 'success');
            } else {
                this.setState({
                    ...this.state,
                    errorMessage: res.data.message
                })
                // Swal.fire('Error!', res.data.message, 'error');
                // alert(res.data.message);
            }
        }).catch(err => {
            console.log('some error thing for maya naumoska od ohrid', err)
        });
        let self = this;
        window['paypal'].Buttons({
            style: {
                shape: 'pill',
                color: 'gold',
                layout: 'horizontal',
                label: 'paypal',
            },
            createOrder: function (data, actions) {
                return actions.order.create({
                    purchase_units: [{
                        "amount": {
                            "currency_code": "EUR",
                            "value": parseFloat(self.state.productsPrice) + parseFloat(self.props.shipping_fee)
                        }
                    }],
                    application_context: {"shipping_preference": "NO_SHIPPING"}
                });
            },
            onApprove: function (data, actions) {
                // self.loading = true;
                return actions.order.capture().then(function (details) {
                    console.log('paypal', details);
                    if (details.status === 'COMPLETED') {
                        self.paypalCompleted(details);
                    } else {
                        // self.lodaing = false;
                        alert('Paypal payment has not been completed.');
                    }
                });
            },
            onError: function (err) {
                console.log(err);
            }
        }).render('#paypal-button-container');

        // location.reload();
    }

    saveGuest(){
        let newUser = this.state.store.updatedGuest;
        console.log('guest', this.state.guest);
        if(newUser.name==null){newUser.name = this.state.guest.name;}
        if(newUser.email==null){newUser.email = this.state.guest.email;}
        if(newUser.tel==null){newUser.tel = this.state.guest.tel;}
        if(newUser.address==null){newUser.address = this.state.guest.address;}
        if(newUser.zip==null){newUser.zip = this.state.guest.zip;}
        if(newUser.city==null){newUser.city = this.state.guest.city;}
        // this.state.secondStore.api_post_call('updateUser', newUser).then(res => {
        //     if (res.data.status) {
        //         this.state.secondStore.saveGuest(res.data.values);
        //         Swal.fire('Succès!', res.data.message, 'success');
        //     } else {
        //         this.setState({
        //             ...this.state,
        //             errorMessage: res.data.message
        //         })
        //         // Swal.fire('Error!', res.data.message, 'error');
        //         // alert(res.data.message);
        //     }
        // }).catch(err => {
        //     console.log(err)
        // });
        this.state.secondStore.saveGuest(this.state.guest);
        let storeData = this.state.store;
        storeData.updatedGuest = this.state.guest;
        this.setState({store:storeData});
        $('#inputname').prop('disabled',true);
        $('#inputemail').prop('disabled',true);
        $('#inputtel').prop('disabled',true);
        $('#inputaddress').prop('disabled',true);
        $('#inputcity').prop('disabled',true);
        $('#inputzip').prop('disabled',true);
        let self = this;
        window['paypal'].Buttons({
            style: {
                shape: 'pill',
                color: 'gold',
                layout: 'horizontal',
                label: 'paypal',
            },
            createOrder: function (data, actions) {
                return actions.order.create({
                    purchase_units: [{
                        "amount": {
                            "currency_code": "EUR",
                            "value": parseFloat(self.state.productsPrice) + parseFloat(self.props.shipping_fee)
                        }
                    }],
                    application_context: {"shipping_preference": "NO_SHIPPING"}
                });
            },
            onApprove: function (data, actions) {
                // self.loading = true;
                return actions.order.capture().then(function (details) {
                    console.log('paypal', details);
                    if (details.status === 'COMPLETED') {
                        self.paypalCompleted(details);
                    } else {
                        // self.lodaing = false;
                        alert('Paypal payment has not been completed.');
                    }
                });
            },
            onError: function (err) {
                console.log(err);
            }
        }).render('#paypal-button-container');
    }

    render () {
        let isLogged = this.props.isLogged;
        let dataCart = this.state.cartProds;
        let cash = this.props.cash;
        let shipping = this.props.shipping_fee;
        let couponCode=this.state.couponCode;
        let currency=this.props.currency;


        return (
            <div>
                <section className="page-banner bg_cover" style={{backgroundImage: "url("+slider2+")"}} >
                    {/*<img src={slider2} alt="slider"/>*/}

                    <div className="container">
                        <ol className="breadcrumb">
                            <li className="breadcrumb-item"><a href="/">Accueil</a></li>
                            <li className="breadcrumb-item active">Check-out
                            </li>
                        </ol>
                    </div>
                </section>

                <section className="checkout-page pt-30 pb-100">
                    <div className="container">
                        {/*{!isLogged ?*/}
                        {/*    <React.Fragment>*/}
                        {/*        <StickyContainer>*/}
                        {/*            <div className="row">*/}
                        {/*                <div className="col-lg-8">*/}
                        {/*                    <div className="row">*/}
                        {/*                        <div className="col-lg-12">*/}
                        {/*                            <div className="checkout-box mt-50" style={{ borderRadius: '0'}}>*/}
                        {/*                                <div className="checkout-title" style={{backgroundColor: '#222'}}>*/}
                        {/*                                    <h5 className="title" style={{color:'white', float:'right'}}>Billing Details</h5>*/}
                        {/*                                </div>*/}
                        {/*                                <div className="details">*/}
                        {/*                                    <div className="details-title">*/}
                        {/*                                        <h6>Product <span>Price</span></h6>*/}
                        {/*                                    </div>*/}
                        {/*                                    <div className="order-list">*/}
                        {/*                                        <ul>*/}
                        {/*                                            {*/}
                        {/*                                                dataCart.map(prod =>*/}
                        {/*                                                    <li key={prod.id}>{prod.title} <span>{prod.quantity*prod.price} {this.props.currency}</span></li>*/}
                        {/*                                                )}*/}
                        {/*                                        </ul>*/}
                        {/*                                    </div>*/}
                        {/*                                    <div className="order-total">*/}
                        {/*                                        <h5>Order total <span>{this.state.productsPrice} {this.props.currency}</span></h5>*/}
                        {/*                                    </div>*/}
                        {/*                                </div>*/}
                        {/*                            </div>*/}
                        {/*                        </div>*/}
                        {/*                    </div>*/}
                        {/*                    <div className='row d-block d-lg-none d-xl-none'>*/}
                        {/*                        <div className='col-12'>*/}
                        {/*                            <div className="checkout-box mt-50" style={{ borderRadius: '0'}}>*/}
                        {/*                                <div className="checkout-title d-flex justify-content-between" style={{backgroundColor: '#222'}}>*/}
                        {/*                                    <h5 className="title" style={{color:'white'}}>Buyer Info</h5>*/}
                        {/*                                    <h5 className="title"><a className="linkColor" href="/login" style={{color:'white'}}>Login Here</a></h5>*/}
                        {/*                                </div>*/}
                        {/*                                <div className="buyer-info" style={{padding: '30px 30px 50px'*/}
                        {/*                                }} >*/}
                        {/*                                    <form action="#">*/}
                        {/*                                        <div className="form-box">*/}
                        {/*                                            <label>Name :</label>*/}
                        {/*                                            <input onChange={this.inputGuestName} type="text"/>*/}
                        {/*                                        </div>*/}
                        {/*                                        <div className="form-box">*/}
                        {/*                                            <label>Email :</label>*/}
                        {/*                                            <input onChange={this.inputGuestEmail} type="email"/>*/}
                        {/*                                        </div>*/}
                        {/*                                        <div className="form-box">*/}
                        {/*                                            <label>Address :</label>*/}
                        {/*                                            <input onChange={this.inputGuestAddress} type="text"/>*/}
                        {/*                                        </div>*/}
                        {/*                                        <div className="form-box">*/}
                        {/*                                            <label>City :</label>*/}
                        {/*                                            <input onChange={this.inputGuestCity} type="text"/>*/}
                        {/*                                        </div>*/}
                        {/*                                        <div className="form-box">*/}
                        {/*                                            <label>Zip :</label>*/}
                        {/*                                            <input onChange={this.inputGuestZip} type="text"/>*/}
                        {/*                                        </div>*/}

                        {/*                                    </form>*/}
                        {/*                                </div>*/}
                        {/*                            </div>*/}
                        {/*                        </div>*/}
                        {/*                    </div>*/}


                        {/*                    <div className="checkout-box mt-50" style={{width: '100%', maxWidth: '100%', borderRadius: '0'}}>*/}
                        {/*                        <div className="checkout-title" style={{backgroundColor: '#222'}}>*/}
                        {/*                            <h5 className="title" style={{color:'white'}}>Payment and Delivery Methods</h5>*/}
                        {/*                        </div>*/}
                        {/*                        <div className="row">*/}
                        {/*                            <div className='col-lg-6'>*/}

                        {/*                            <div className="payment-methods" style={{paddingLeft: '30px', paddingRight: '10px'}}>*/}
                        {/*                                <div className="payment">*/}
                        {/*                                            <div>*/}
                        {/*                                                <i style={{paddingLeft: '10px', paddingRight:'10px'}} className="fa fa-truck"> </i>*/}
                        {/*                                                <b>DELIVERY</b>*/}
                        {/*                                                <p style={{color: '#555', paddingLeft: '10px', paddingTop: '10px'}}>*/}
                        {/*                                                    Delivery in 10 working days*/}
                        {/*                                                </p>*/}
                        {/*                                            </div>*/}
                        {/*                                    </div>*/}
                        {/*                                </div>*/}
                        {/*                            </div>*/}
                        {/*                            </div>*/}
                        {/*                            <div className="col-lg-6">*/}
                        {/*                            <div className="payment-methods" style={{paddingLeft: '30px', paddingRight: '10px'}}>*/}
                        {/*                                <div className="payment">*/}
                        {/*                                    <img src="https://static.zara.net/static/images/payment/payment/po-den.svg" style={{maxWidth:'70px', maxHeight: '70px'}} />*/}
                        {/*                                    <b>Payment on delivery</b>*/}
                        {/*                                    <p style={{color: '#555', paddingLeft: '12px'}}>*/}
                        {/*                                        100% secured payment*/}
                        {/*                                    </p>*/}
                        {/*                                </div>*/}
                        {/*                            </div>*/}
                        {/*                        </div>*/}
                        {/*                    </div>*/}
                        {/*                    <div className='row'>*/}
                        {/*                        <div className='col-lg-12'>*/}
                        {/*                            <div className="checkout-box mt-50" style={{ borderRadius: '0'}}>*/}
                        {/*                                <div className="checkout-title" style={{ backgroundColor: '#222'}}>*/}
                        {/*                                    <h5 className="title" style={{marginBottom: '0', color: 'white'}}>Total</h5>*/}
                        {/*                                </div>*/}
                        {/*                                <div className="details" style={{background: 'linear-gradient(90deg, #4b6cb7 0%, #182848 100%)'}}>*/}

                        {/*                                    <div className="details-title">*/}
                        {/*                                        <h6>    </h6>*/}
                        {/*                                    </div>*/}
                        {/*                                    <div className="order-list">*/}
                        {/*                                        <ul>*/}
                        {/*                                            <li> Order total<span> {this.state.productsPrice} {this.props.currency}</span></li>*/}
                        {/*                                            <li> Shipping fee <span> {this.state.sh_fee} {this.props.currency}</span></li>*/}
                        {/*                                        </ul>*/}
                        {/*                                    </div>*/}
                        {/*                                    <div className="order-total" style={{color:'white'}}>*/}
                        {/*                                        <h5 style={{color: 'white'}}>Grand total <span>{this.state.TOTALTOTAL} {this.props.currency} </span></h5>*/}
                        {/*                                    </div>*/}
                        {/*                                </div>*/}
                        {/*                            </div>*/}
                        {/*                        </div>*/}
                        {/*                    </div>*/}


                        {/*                </div>*/}
                        {/*                /!*<div className='col-lg-4 .d-none .d-lg-block .d-xl-none'>*!/*/}
                        {/*                */}

                        {/*            </div>*/}
                        {/*        </StickyContainer>*/}
                        {/*            </React.Fragment>*/}
                        {/*             :*/}

                            <React.Fragment>
                                <StickyContainer>
                                    <div className="row">
                                        <div className="col-lg-8">
                                            <div className="row">
                                                <div className="col-lg-12">
                                                    <div className="checkout-box mt-50  " style={{ borderRadius: '0'}}>
                                                        <div className="checkout-title" style={{backgroundColor: '#222'}}>
                                                            <h5 className="title" style={{color:'white', float:'right'}}>Détails de la facturation</h5>
                                                        </div>
                                                        <div className="details">
                                                            <div className="details-title">
                                                                <h6>Produit <span>Prix</span></h6>
                                                            </div>
                                                            <div className="order-list">
                                                                <ul>
                                                                    {
                                                                        dataCart.map(prod =>
                                                                            <li key={prod.id}>{prod.title} <span>{prod.quantity*prod.price} {currency}</span></li>
                                                                        )}
                                                                </ul>
                                                            </div>
                                                            <div className="order-total">
                                                                <h5>Total de la commande <span>{this.state.productsPrice} {currency}</span></h5>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className='row d-block d-lg-none d-xl-none'>
                                                <div className='col-12'>
                                                    <div className="checkout-box mt-50" style={{ borderRadius: '0'}}>
                                                        <div className="checkout-title d-flex justify-content-between" style={{backgroundColor: '#222'}}>
                                                            <h5 className="title" style={{color:'white'}}>Acheteur</h5>
                                                            <h5 className="title"><a className="linkColor" href="/updateInfo">Éditer</a></h5>                                                            </div>
                                                        <div className="buyer-info" style={{padding: '30px 30px 50px'
                                                        }} >
                                                            <form action="#">
                                                                <div className="form-box">
                                                                    <label className='pr-0'>Nom :</label>
                                                                    {this.state.store.loggedUser.name}
                                                                </div>
                                                                <div className="form-box">
                                                                    <label className='pr-0'>Email :</label>
                                                                    {this.state.store.loggedUser.email}
                                                                </div>
                                                                <div className="form-box">
                                                                    <label className='pr-0'>Numéro de contact :</label>
                                                                    {this.state.store.loggedUser.tel}
                                                                </div>
                                                                <div className="form-box">
                                                                    <label className='pr-0'>Adresse :</label>
                                                                    {this.state.store.loggedUser.address}
                                                                </div>
                                                                <div className="form-box">
                                                                    <label className='pr-0'>Ville :</label>
                                                                    {this.state.store.loggedUser.city}
                                                                </div>
                                                                <div className="form-box">
                                                                    <label className='pr-0'>Code postal :</label>
                                                                    {this.state.store.loggedUser.zip}
                                                                </div>

                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            {/*<div className='row'>*/}
                                            {/*    <div className='col-lg-12'>*/}
                                            {/*        <div className="checkout-box mt-50  ">*/}
                                            {/*            <div className="checkout-title" style={{ backgroundColor: '#222', borderTopLeftRadius: '15px', borderTopRightRadius: '15px'}}>*/}
                                            {/*                <a href='/offer' className="checkoutOffer" style={{marginBottom: '0', color: 'white'}}>GET OFFER</a>*/}
                                            {/*            </div>*/}
                                            {/*            <div className="details" style={{background: 'linear-gradient(90deg, #4b6cb7 0%, #182848 100%)', borderBottomLeftRadius: '15px', borderBottomRightRadius: '15px', color: 'white'}}>*/}

                                            {/*                <div className="single-cart-form" style={{padding: '30px 0'}}>*/}
                                            {/*                    <label style={{paddingRight: '15px', color: 'white', textTransform:'uppercase', fontSize:'larger'}}>Enter your coupon code if you have one.</label>*/}
                                            {/*                    <div> <input style={{border:'0', borderRadius: '60px',  height: '30px', padding: '30px', width: '70%', marginRight:'15px'}} type="text" onChange={this.inputCouponCode}/>*/}

                                            {/*                        <span className="single-cart-form">*/}
                                            {/*                        <button className="applyButton" onClick={this.applyCouponCode}>*/}
                                            {/*                            <i style={{fontSize:'20px',textAlign: 'center',*/}
                                            {/*                                verticalAlign: 'middle'}} className="fa fa-check" aria-hidden="true"> </i>*/}

                                            {/*                        </button>*/}
                                            {/*                    </span>*/}
                                            {/*                    </div>*/}
                                            {/*                    /!*<div style={{color: "#e06377"}} >{this.state.invalidCodeMessage}</div>*!/*/}

                                            {/*                </div>*/}
                                            {/*                /!*<div className="single-cart-form">*!/*/}
                                            {/*                /!*    <button className="applyButton" onClick={()=>{this.applyCouponCode(couponCode, total)}}>*!/*/}
                                            {/*                /!*        <i style={{fontSize:'20px',textAlign: 'center',*!/*/}
                                            {/*                /!*            verticalAlign: 'middle'}} className="fa fa-check" aria-hidden="true"> </i>*!/*/}

                                            {/*                /!*    </button>*!/*/}
                                            {/*                /!*</div>*!/*/}

                                            {/*            </div>*/}
                                            {/*        </div>*/}
                                            {/*    </div>*/}
                                            {/*</div>*/}
                                            <div className="checkout-box mt-50" style={{width: '100%', maxWidth: '100%'}}>
                                                <div className="checkout-title" style={{backgroundColor: '#222', borderTopLeftRadius: '15px', borderTopRightRadius: '15px'}}>
                                                    <h5 className="title" style={{color:'white'}}>Modes de paiement et de livraison</h5>
                                                </div>

                                                <div className="row">

                                                    <div className="col-lg-12">
                                                        <div className="payment-methods" style={{paddingLeft: '60px', paddingRight: '10px'}}>
                                                            <div className="payment">
                                                                {/*<div className="radio">*/}
                                                                {/*    <label style={{cursor:'pointer'}}>*/}
                                                                {/*        <input type="radio" name="optradio" />*/}
                                                                {/*        <i className="fab fa-cc-paypal ccStyle"> </i>*/}
                                                                {/*        /!*<b>PayPal</b>*!/*/}
                                                                {/*    </label>*/}
                                                                {/*</div>*/}
                                                            </div>
                                                            {cash===0 ?
                                                                <React.Fragment>
                                                                    <div className="payment">
                                                                        <div className="radio">
                                                                            <label style={{cursor:'pointer'}}>
                                                                                <input type="radio" name="optradio" disabled/>
                                                                                <img src="https://static.zara.net/static/images/payment/payment/po-den.svg" style={{maxWidth:'70px', maxHeight: '70px'}} />
                                                                                <b>Paiement à la livraison</b>
                                                                            </label>



                                                                        </div>
                                                                    </div>
                                                                </React.Fragment> :
                                                                <React.Fragment>
                                                                    <div className="payment">
                                                                        <div className="radio">
                                                                            <label style={{cursor:'pointer'}}>
                                                                                <input type="radio" name="optradio" onChange={()=>{this.setPayment('POD')}}/>
                                                                                <img src="https://static.zara.net/static/images/payment/payment/po-den.svg" style={{maxWidth:'70px', maxHeight: '70px'}} />
                                                                                <b>Paiement à la livraison</b>
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                </React.Fragment>
                                                            }
                                                            <div className="row">
                                                                <div className="payment">
                                                                    <div className="radio disabled">
                                                                        <label style={{marginLeft: '15px', cursor: 'pointer'}}>
                                                                            <input type="radio" name="optradio" onChange={()=>{this.setPayment('CC')}} />
                                                                            {/*<a href="#"><i className="fab fa-cc-paypal ccStyle"> </i></a>*/}
                                                                            <a href="#"><i className="fab fa-cc-visa ccStyle"> </i></a>
                                                                            <a href="#"><i className="fab fa-cc-mastercard ccStyle"> </i></a>
                                                                        </label>
                                                                    </div>
                                                                    <div className="card-info">
                                                                        <form action="#">
                                                                            <div className="form-box">
                                                                                <label>Numéro de carte :</label>
                                                                                <input type="text" maxLength="16" minLength="16" onChange={this.inputCardNumber}/>
                                                                            </div>
                                                                            <div className="form-box">
                                                                                <label>cvv :</label>
                                                                                <input type="text" maxLength="3" minLength="3" onChange={this.inputCVV}/>
                                                                            </div>
                                                                            <div className="month-year">
                                                                                <div className="form-box">
                                                                                    <label>Mois :</label>
                                                                                    <input type="text" maxLength="2"  minLength="2" onChange={this.inputMonth}/>
                                                                                </div>
                                                                                <div className="form-box">
                                                                                    <label>An :</label>
                                                                                    <input type="text" maxLength="2" minLength="2" onChange={this.inputYear}/>
                                                                                </div>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div className="row" >
                                                    <div className='col-lg-12'>
                                                        <div className="payment-methods" style={{paddingLeft: '30px', paddingRight: '10px'}}>
                                                            <div className="payment">
                                                                <div className="radio" style={{borderTop: '1px solid rgba(34, 34, 34, 0.2)', paddingTop:'30px'}}>
                                                                    <div>
                                                                        <i style={{paddingLeft: '10px', paddingRight:'10px'}} className="fa fa-truck"> </i>
                                                                        <b>LIVRAISON</b>
                                                                    </div>
                                                                    <p style={{color: '#555' , paddingLeft: '10px', paddingTop: '10px'}}>
                                                                        Livraison en quelques jours.                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>

                                            {/*<div className='row'>*/}
                                            {/*    <div className='col-lg-12'>*/}
                                            {/*        <div className="checkout-box mt-50  ">*/}
                                            {/*            <div className="checkout-title" style={{ backgroundColor: '#222', borderTopLeftRadius: '15px', borderTopRightRadius: '15px'}}>*/}
                                            {/*                <h5 className="title" style={{marginBottom: '0', color: 'white'}}>Total</h5>*/}
                                            {/*            </div>*/}
                                            {/*            <div className="details" style={{backgroundColor: 'rgb(235, 241, 246)', borderBottomLeftRadius: '15px', borderBottomRightRadius: '15px'}}>*/}

                                            {/*                <div className="details-title">*/}
                                            {/*                    <h6>    </h6>*/}
                                            {/*                </div>*/}
                                            {/*                <div className="order-list">*/}
                                            {/*                    <ul>*/}
                                            {/*                        <li> Order total<span> {this.state.productsPrice} {this.props.currency}</span></li>*/}
                                            {/*                        <li> Shipping fee <span> {this.state.sh_fee} {this.props.currency}</span></li>*/}
                                            {/*                        {*/}
                                            {/*                            this.state.paymentOption==='CC' ?*/}
                                            {/*                                <li> Processing fee <span> {this.props.processing_fee} {this.props.currency}</span></li> :*/}
                                            {/*                                <li> Processing fee <span> 0 {this.props.currency}</span></li>*/}

                                            {/*                        }*/}

                                            {/*                        <li> Coupon discount <span> {this.state.discount} {this.props.currency}</span></li>*/}
                                            {/*                    </ul>*/}
                                            {/*                </div>*/}
                                            {/*                <div className="order-total">*/}
                                            {/*                    <h5>Grand total <span>{this.state.TOTALTOTAL} {this.props.currency}</span></h5>*/}
                                            {/*                </div>*/}
                                            {/*            </div>*/}
                                            {/*        </div>*/}
                                            {/*    </div>*/}

                                        {/*</div>*/}

                                            <div className='row'>
                                                <div className='col-lg-12'>
                                                    <div className="checkout-box mt-50  " style={{  borderRadius: '0'}}>
                                                        <div className="checkout-title" style={{ backgroundColor: '#222'}}>
                                                            <h5 className="title" style={{marginBottom: '0', color: 'white'}}>Total</h5>
                                                        </div>
                                                        <div className="details" style={{background: 'linear-gradient(90deg, rgb(34, 34, 34) 0%, rgb(34, 34, 34) 100%)', color: 'white'}}>

                                                            <div className="details-title">
                                                                <h6>    </h6>
                                                            </div>
                                                            <div className="order-list">
                                                                <ul>
                                                                    <li> Total de la commande<span> {this.state.productsPrice} {currency}</span></li>
                                                                    <li> Frais d'expédition <span> {shipping} {currency}</span></li>
                                                                </ul>
                                                            </div>
                                                            <div className="order-total">
                                                                <h5 style={{color: '#888'}}> Somme finale <span>{parseFloat(this.state.productsPrice) + parseFloat(shipping) } {currency}</span></h5>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                        {/*<div className='col-lg-4 .d-none .d-lg-block .d-xl-none'>*/}

                                        { isLogged ?
                                            <React.Fragment>
                                                <div className='col-lg-4 d-none d-lg-block d-xl-block'>
                                                    <Sticky>
                                                        {({
                                                              style,

                                                              // the following are also available but unused in this example
                                                              isSticky,
                                                              wasSticky,
                                                              distanceFromTop,
                                                              distanceFromBottom,
                                                              calculatedHeight
                                                          }) => (
                                                            <header style={style}>
                                                                <div className="checkout-box mt-50" style={{ borderRadius: '0'}}>
                                                                    <div className="checkout-title d-flex justify-content-between" style={{backgroundColor: '#222'}}>
                                                                        <h5 className="title" style={{color:'white'}}>Acheteur</h5>
                                                                        <h5 className="title"><a className="linkColor" href="/updateInfo">Éditer</a></h5>                                                            </div>
                                                                        <div className="buyer-info" style={{padding: '30px 30px 50px'}} >
                                                                            <form action="#">
                                                                                <div className="form-box">
                                                                                    <label className='pr-0'>Nom :</label>
                                                                                    {this.state.store.loggedUser.name}
                                                                                </div>
                                                                                <div className="form-box">
                                                                                    <label className='pr-0'>Email :</label>
                                                                                    {this.state.store.loggedUser.email}
                                                                                </div>
                                                                                {
                                                                                    this.state.store.loggedUser.tel!= null  ?
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <label className='pr-0'>Numéro de contact :</label>
                                                                                                {this.state.store.loggedUser.tel}
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                        :
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <label>Numéro de contact :</label>
                                                                                                <input type="text" className="form-control" onChange={this.inputTelLogged}  required/>
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                }
                                                                                {
                                                                                    this.state.store.loggedUser.address != null ?
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <label className='pr-0'>Adresse :</label>
                                                                                                {this.state.store.loggedUser.address}
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                        :
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <label>Adresse :</label>
                                                                                                <input type="text" className="form-control" onChange={this.inputAddressLogged}  required/>
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                }
                                                                                {
                                                                                    this.state.store.loggedUser.city != null ?
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <label className='pr-0'>Ville :</label>
                                                                                                {this.state.store.loggedUser.city}
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                        :
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <label>Ville :</label>
                                                                                                <input type="text" className="form-control" onChange={this.inputCityLogged} required/>
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                }
                                                                                {
                                                                                    this.state.store.loggedUser.zip != null ?
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <label className='pr-0'>Code postal :</label>
                                                                                                {this.state.store.loggedUser.zip}
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                        :
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <label>Code postal :</label>
                                                                                                <input type="text" className="form-control" onChange={this.inputZipLogged}  required/>
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                }

                                                                                {
                                                                                    (this.state.store.loggedUser.zip == null || this.state.store.loggedUser.tel==null || this.state.store.loggedUser.address == null || this.state.store.loggedUser.city==null) ?
                                                                                        <React.Fragment>
                                                                                            <div className="form-box">
                                                                                                <button className="btn btn-primary" onClick={()=>this.saveUser()}>Sauver</button>
                                                                                            </div>
                                                                                        </React.Fragment>
                                                                                        : null
                                                                                }
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                            </header>
                                                        )}
                                                    </Sticky>
                                                </div>

                                            </React.Fragment> :

                                            <React.Fragment>

                                                <div className='col-lg-4 d-none d-lg-block d-xl-block'>
                                                    <Sticky>
                                                        {({
                                                              style,

                                                              // the following are also available but unused in this example
                                                              isSticky,
                                                              wasSticky,
                                                              distanceFromTop,
                                                              distanceFromBottom,
                                                              calculatedHeight
                                                          }) => (
                                                            <header style={style}>
                                                                <div className="checkout-box mt-50" style={{ borderRadius: '0'}}>
                                                                    <div className="checkout-title d-flex justify-content-between" style={{backgroundColor: '#222'}}>
                                                                        <h5 className="title" style={{color:'white'}}>Acheteur</h5>
                                                                        <h5 className="title"><a className="linkColor" href="/login" style={{color:'white'}}>S'identifier</a></h5>
                                                                    </div>
                                                                    <div className="buyer-info" style={{padding: '30px 30px 50px'
                                                                    }} >
                                                                        <form action="#">
                                                                            <div className="form-box">
                                                                                <label>Nom :</label>
                                                                                <input onChange={this.inputGuestName} id="inputname" type="text" className="form-control" required/>

                                                                            </div>
                                                                            <div className="form-box">
                                                                                <label>Email :</label>
                                                                                <input onChange={this.inputGuestEmail} id="inputemail" type="email" className="form-control" required/>
                                                                            </div>
                                                                            <div className="form-box">
                                                                                <label>Téléphone :</label>
                                                                                <input onChange={this.inputTel} id="inputtel" type="tel" className="form-control" required/>
                                                                            </div>
                                                                            <div className="form-box">
                                                                                <label>Adresse :</label>
                                                                                <input onChange={this.inputGuestAddress} id="inputaddress" type="text" className="form-control" required/>
                                                                            </div>
                                                                            <div className="form-box">
                                                                                <label>Ville :</label>
                                                                                <input onChange={this.inputGuestCity} id="inputcity" value={this.state.guest.city} type="text" className="form-control" required/>
                                                                            </div>
                                                                            <div className="form-box">
                                                                                <label>Postal code :</label>
                                                                                <input onChange={this.inputGuestZip} id="inputzip" type="text" className="form-control" required/>
                                                                            </div>

                                                                            {
                                                                                (this.state.store.updatedGuest.name=='' || this.state.store.updatedGuest.email==='' ||
                                                                                    this.state.store.updatedGuest.address==='' || this.state.store.updatedGuest.city==='' || this.state.store.updatedGuest.tel===''
                                                                                    || this.state.store.updatedGuest.zip==='') ?
                                                                                    <React.Fragment>
                                                                                        <div className="form-box">
                                                                                            <button type="button" className="btn btn-primary" onClick={()=>this.saveGuest()}>Sauver</button>
                                                                                        </div>
                                                                                    </React.Fragment>
                                                                                    : null
                                                                            }

                                                                        </form>
                                                                    </div>
                                                                </div>

                                                            </header>
                                                        )}
                                                    </Sticky>
                                                </div>
                                            </React.Fragment>



                                        }




                                    </div>

                                </StickyContainer>
                            </React.Fragment>

                        { isLogged ?

                            (this.state.store.loggedUser.zip == null || this.state.store.loggedUser.tel==null || this.state.store.loggedUser.address == null || this.state.store.loggedUser.city==null) ?
                                <React.Fragment>
                                    <div className="alert alert-danger mt-30">
                                        Veuillez remplir toutes vos informations personnelles avant de passer la commande.                                    </div>
                                </React.Fragment>
                                :
                                <React.Fragment>
                                    <div className="row">
                                        <div className="col-lg-6">
                                            <div className="order-btn text-center mt-50">
                                                <a className="main-btn" onClick={this.makeOrder}>Passer la commande</a>
                                                {/*<div style={{fontSize: '9px', color: '#222 !important'}}>*/}
                                                {/*    <a style={{fontSize: '9px', color: '#222 !important'}} href='/orders'>View orders</a>*/}
                                                {/*</div>*/}
                                            </div>
                                        </div>
                                        <div className="col-lg-6">
                                            <div id="paypal-button-container" ></div>
                                        </div>

                                    </div>

                                </React.Fragment>
                            :
                            <React.Fragment>
                                    <div className="row">
                                        <div className="col-lg-6">
                                            <div className="order-btn text-center mt-50">
                                                <a className="main-btn" onClick={this.makeOrder}>Passer la commande</a>
                                                {/*<div style={{fontSize: '9px', color: '#222 !important'}}>*/}
                                                {/*    <a style={{fontSize: '9px', color: '#222 !important'}} href='/orders'>View orders</a>*/}
                                                {/*</div>*/}
                                            </div>
                                        </div>

                                        <div className="col-lg-6 mt-50">
                                            <div id="show-hide">
                                                <div id="paypal-button-container" ></div>
                                            </div>

                                        </div>

                                    </div>

                            </React.Fragment>

                        }

                    </div>
                </section>

            </div>


        )
    }
}


