import { Component } from 'react'
import ReactDOM from 'react-dom'
import {BrowserRouter, Link, Route, Switch} from 'react-router-dom'
import HeaderPart from "./pages/mainComponents/HeaderPart"
import BrandPart from "./pages/mainComponents/BrandPart"
//import NewsletterPart from "./pages/homePage/HomePageParts/NewsletterPart"
import FooterPart from "./pages/mainComponents/FooterPart"
import ProductCardDetails from "./pages/productPage/productView/ProductCard/ProductDetails/ProductCardDetails";

import './assets/js/vendor/jquery-3.5.1.min'
import './assets/js/vendor/modernizr-3.7.1.min'
import './assets/js/slick.min'
import './assets/js/jquery.magnific-popup.min'
import './assets/js/jquery.countdown.min'
import './assets/js/jquery-ui.min'
import './assets/js/jquery.nice-select.min'
import './assets/js/main'
import ProductsList from "./pages/productPage/productView/ProductsList";
import Checkout from "./pages/CheckoutPage/Checkout";
import ContactUs from "./pages/ContactUsPage/ContactUs";
import AboutUs from "./pages/AboutPage/AboutUs";
import Wishlist from "./pages/WishList/Wishlist";
import Cart from "./pages/UpdateWishlistPage/Cart";
import HomePage from './pages/homePage/HomePage';
import './assets/css/style.css'
import axios from 'axios';
import {any} from "prop-types";
import API from "./utils/API";
import {createStore} from "redux";
import Store from './utils/store'
import MyProfile from "./pages/MyProfilePage/MyProfile";

export default class App extends Component {

    constructor(props) {
        super(props);
        this.logged = false;
        this.state = {
        }

        if (this.props.logged === 'true') {this.logged = true;}
        const store = new Store('mangopaid');
        let storeData = store.get();
    }

    // componentDidMount() {
    //     let localState = JSON.parse(localStorage.getItem('state'));
    //     let wishlistProds = localState.wishlistProds;
    //     this.setState({wishListProducts: wishlistProds});
    //     console.log('wishlisttest', wishlistProds)
    // }

    render () {

        return (

            <BrowserRouter>
            <div>
                    <HeaderPart isLogged={this.logged} />
                    <Switch>
                        <Route exact path='/' component={HomePage}  />
                        <Route exact path='/list' component={ProductsList} />
                        <Route exact path='/checkout' component={Checkout} />
                        <Route exact path='/contact' component={ContactUs} />
                        <Route exact path='/about' component={AboutUs} />
                        <Route exact path='/wishlist' component={Wishlist} />
                        <Route exact path='/cart' component={Cart}  />
                        <Route exact path='/profile' component={MyProfile}  />


                        {/*<div> {products.map((product, id) => <div key={'product_item_'+id}><ProductCardDetails product={product} /> </div>)} </div>*/}

                        <Route exact path='/detailed/:id' component={ProductCardDetails}  />
                        {/*<Route exact path='/detailed/:id' render={(props)=>{*/}
                        {/*    <ProductCardDetails id={props.match.params.id}/>*/}
                        {/*}} />*/}
                        {/*<Route exact path='/cart/product/:id' render={() => <ProductCardDetails />} />*/}
                        {/*<Link to={`/detailed/${product.id}`}>*/}
                    </Switch>
                    <BrandPart/>
                    {/*<NewsletterPart/>*/}
                    <FooterPart/>
                    <a href="#" className="back-to-top"><i className="fal fa-chevron-up"> </i> </a>

            </div>
            </BrowserRouter>
        )
    }
}

if (document.getElementById('myExp')) {
    const element = document.getElementById('myExp');
    const data = $('#authenticatedToken').attr('data');
    const logged = $('#authenticatedToken').attr('logged');
    ReactDOM.render(<App data={data} logged={logged}/>, element);

}
