"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _KeyboardArrowLeft = _interopRequireDefault(require("../internal/svg-icons/KeyboardArrowLeft"));

var _KeyboardArrowRight = _interopRequireDefault(require("../internal/svg-icons/KeyboardArrowRight"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _ButtonBase = _interopRequireDefault(require("../ButtonBase"));

var styles = {
  /* Styles applied to the root element. */
  root: {
    color: 'inherit',
    width: 56,
    flexShrink: 0
  }
};
/**
 * @ignore - internal component.
 */

exports.styles = styles;

var _ref = _react.default.createElement(_KeyboardArrowLeft.default, null);

var _ref2 = _react.default.createElement(_KeyboardArrowRight.default, null);

function TabScrollButton(props) {
  var classes = props.classes,
      classNameProp = props.className,
      direction = props.direction,
      onClick = props.onClick,
      visible = props.visible,
      other = (0, _objectWithoutProperties2.default)(props, ["classes", "className", "direction", "onClick", "visible"]);
  var className = (0, _classnames.default)(classes.root, classNameProp);

  if (!visible) {
    return _react.default.createElement("div", {
      className: className
    });
  }

  return _react.default.createElement(_ButtonBase.default, (0, _extends2.default)({
    className: className,
    onClick: onClick,
    tabIndex: -1
  }, other), direction === 'left' ? _ref : _ref2);
}

process.env.NODE_ENV !== "production" ? TabScrollButton.propTypes = {
  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css-api) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * Which direction should the button indicate?
   */
  direction: _propTypes.default.oneOf(['left', 'right']),

  /**
   * Callback to execute for button press.
   */
  onClick: _propTypes.default.func,

  /**
   * Should the button be present or just consume space.
   */
  visible: _propTypes.default.bool
} : void 0;
TabScrollButton.defaultProps = {
  visible: true
};

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiPrivateTabScrollButton'
})(TabScrollButton);

exports.default = _default;