"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("@material-ui/utils");

/**
 * NoSsr purposely removes components from the subject of Server Side Rendering (SSR).
 *
 * This component can be useful in a variety of situations:
 * - Escape hatch for broken dependencies not supporting SSR.
 * - Improve the time-to-first paint on the client by only rendering above the fold.
 * - Reduce the rendering time on the server.
 * - Under too heavy server load, you can turn on service degradation.
 */
var NoSsr =
/*#__PURE__*/
function (_React$Component) {
  (0, _inherits2.default)(NoSsr, _React$Component);

  function NoSsr() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, NoSsr);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(NoSsr)).call.apply(_getPrototypeOf2, [this].concat(args)));
    _this.mounted = false;
    _this.state = {
      mounted: false
    };
    return _this;
  }

  (0, _createClass2.default)(NoSsr, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.mounted = true;

      if (this.props.defer) {
        // Wondering why we use two RAFs? Check this video out:
        // https://www.youtube.com/watch?v=cCOL7MC4Pl0
        //
        // The componentDidMount() method is called after the DOM nodes are inserted.
        // The UI might not have rendering the changes. We request a frame.
        requestAnimationFrame(function () {
          // The browser should be about to render the DOM nodes
          // that React committed at this point.
          // We don't want to interrupt. Let's wait the next frame.
          requestAnimationFrame(function () {
            // The UI is up-to-date at this point.
            // We can continue rendering the children.
            if (_this2.mounted) {
              _this2.setState({
                mounted: true
              });
            }
          });
        });
      } else {
        this.setState({
          mounted: true
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.mounted = false;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          fallback = _this$props.fallback;
      return this.state.mounted ? children : fallback;
    }
  }]);
  return NoSsr;
}(_react.default.Component);

process.env.NODE_ENV !== "production" ? NoSsr.propTypes = {
  children: _propTypes.default.node.isRequired,

  /**
   * If `true`, the component will not only prevent server-side rendering.
   * It will also defer the rendering of the children into a different screen frame.
   */
  defer: _propTypes.default.bool,

  /**
   * The fallback content to display.
   */
  fallback: _propTypes.default.node
} : void 0;

if (process.env.NODE_ENV !== 'production') {
  process.env.NODE_ENV !== "production" ? NoSsr.propTypes = (0, _utils.exactProp)(NoSsr.propTypes) : void 0;
}

NoSsr.defaultProps = {
  defer: false,
  fallback: null
};
var _default = NoSsr;
exports.default = _default;