<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageConfigsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('page_configs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('admin_id');
            $table->string('company_name');
            $table->string('logo');
            $table->mediumText('about_desc')->nullable()->default(null);
            $table->string('address')->nullable()->default(null);
            $table->string('main_email')->nullable()->default(null);
            $table->string('tel')->nullable()->default(null);
            $table->tinyInteger('hotline_support')->default(0);
            $table->string('hotline_num')->nullable()->default(null);
            $table->decimal('shipping_fee', 10,2)->default(0);
            $table->decimal('min_o_free', 10,2)->default(0);
            $table->decimal('processing_fee', 10,2)->default(0);
            $table->string('currency')->default('$');
            $table->tinyInteger('cash_payment')->default(0);
            $table->tinyInteger('shipping_type')->default(0);
            $table->integer('status')->default(1);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('page_configs');
    }
}
