<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model
{
        public function category() {
            return $this->belongsTo(Category::class, 'cat_id');
        }
        public function products() {
            return $this->hasMany(Products::class, 'sub_category_id')->where('status', 1)->with('sizes');
        }
        public function related() {
            return $this->hasMany(Products::class, 'sub_category_id')->where('status', 1)->with('sizes')->inRandomOrder()->limit(4);
        }
}
