<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class Sizes extends Model
{
    public function colors() {
        return $this -> hasMany(Colors::class, 'size_id');
    }

    public function scopeFiltcolors(Builder $query, $color) {
//        dd($color);
        return $query->whereHas('colors', function ($q) use ($color) {
            $q->where('color', $color[0]);
            foreach ($color as $c) {
                if ($c != $color[0])
                    $q->orWhere('color', $c);
            }
            return $q;
        });
    }
}
