<?php
namespace App\Library;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
class ImageHelper{
    static function uploadImage($file, $user, $type, $width = null, $height = null)
    {
        $ext = $file->getClientOriginalExtension();
        if ($type == 'logo') {
            $filename = 'logo.'.$ext;
        } else {
            $filename = uniqid().'.'.$ext;
        }
        $img = Image::make($file->getRealPath());
        if($width != null && $img->width() > $width){
            $img->resize($width, $height, function ($constraint) {
                $constraint->aspectRatio();
            });
        }
        $path = base_path('/public/images/'.$user->id.'/'.$type.'/');

        $upload_success = $file->move($path, (string) $filename);
        if($upload_success){
            return url('/images/'.$user->id.'/'.$type.'/'.$filename);
        }else{
            return null;
        }

//        Storage::put("/public/images/$user->id/$type/$filename", (string) $img->encode());
//        chmod(asset("/storage/images/$user->id/$type/$filename"), 0775);
//        return asset("/storage/images/$user->id/$type/$filename");

    }

    static function uploadFile($file, $path){
        if (!file_exists($path)) { mkdir($path,0775, true);}
        $filename = uniqid().".".$file->getClientOriginalExtension();
        $upload_success = $file->move($path, $filename);
        if($upload_success){
            return $filename;
        }else{
            return '';
        }
    }
}
