<?php

namespace App\Http\Controllers;

use App\ProductImage;
use App\Products;
use Illuminate\Http\Request;

class ProductsController extends Controller
{
    public function getProducts() {
        $pag = 15;
        $filter = json_decode(request('filter'));
        $query = Products::query();
        $query->where('status','!=',0)->with('sizes');
        $query->when(isset($filter->priceFrom), function ($q) {
            return $q->where('price', '>', json_decode(request('filter'))->priceFrom)->where('price', '<', json_decode(request('filter'))->priceTo);
        });

        if (isset($filter->size) && count($filter->size) > 0) {
            if (count($filter->color) > 0)
            {
                $query->filtswcolors($filter->size, $filter->color);
            } else {
                $query->filtsize($filter->size);
            }
        } else {
            if (isset($filter->color) && count($filter->color) > 0)
            {
//                dd($filter->color);
                $query->filtercolor($filter->color);
            } else {
                $query->with('sizes');
            }
        }
//        dd(json_decode(request('filter')));
        if (isset($filter->sub_id) && $filter->sub_id != null && $filter->sub_id != "") {
//            dd('here');
            $query->where('sub_category_id', $filter->sub_id);
        } else if (isset($filter->cat_id) && $filter->cat_id != null && $filter->cat_id != "") {
            $query->filtercat($filter->cat_id);
        }
        if (\request('number')) {
            $pag = request('number');
        }
        if(\request('search') != null){
            $query->where('title','like',"%".request('search')."%");
        }
        if (isset($filter->order_by) && $filter->order_by != '') {
            if ($filter->order_by == 'low')
                $query->orderBy('price', 'asc');
            else
                $query->orderBy('price', 'desc');
        }
        $query->with('images');
        $products = $query->paginate($pag);
        return $this->returnData(true, 'Products', $products);
    }

    public function getProductsAdmin() {
        $products   = Products::where('status','!=',0)->with('sizes')->get();
        return $this->returnData(true, 'Products', $products);
    }
    public function getAllProducts() {
        $pag = 30;
        $query   = Products::query();
        $query->with('sizes');
        if(\request('search') != null){
            $query->where('title','like',"%".request('search')."%");
        }
        if (\request('number')) {
            $pag = request('number');
        }
        $products = $query->paginate($pag);
        return $this->returnData(true, 'Products', $products);
    }
    public function getSingleProduct() {
        $product   = Products::where('id', request('id'))->where('status', '!=', 0)->with('sizes')->with('sub_cat')->with('images')->first();
        return $this->returnData(true, 'Product', $product);
    }
    public function getSingleProductAdmin() {
        $product   = Products::where('id', request('id'))->with('sizes')->with('sub_cat')->with('images')->first();
        return $this->returnData(true, 'Product', $product);
    }
//    public function deleteDuplicates() {
//        $images = ProductImage::all();
//        $occurence = [];
//        foreach ($images as $i) {
//            if(in_array($i->image, $occurence)) {
//                $i->delete();
//            } else {
//                $occurence[] = $i->image;
//            }
//        }
//        return $this->returnData(true, 'deleted', null);
//    }
}
