<?php

namespace App\Http\Controllers;

use App\CustomClients;
use App\Library\PaymentHelper;
use App\LiveOrders;
use App\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use RealRashid\SweetAlert\Facades\Alert;

class LiveOrdersController extends Controller
{
    public function index(){
        $clients = CustomClients::orderBy('name','asc')->get();
        return view('admin.live-order',compact('clients'));
    }
    public function liveOrders(){
        $clients = CustomClients::orderBy('name','asc')->get();
        $lastOrder = LiveOrders::latest()->first();
        if (\request()->isMethod('post')) {
            $pag = 30;
            $query   = LiveOrders::query();
            if(\request('search') != null){
                $query->where('fullname','like',"%".request('search')."%")->orWhere('nickname','like',"%".request('search')."%")->orWhere('email','like',"%".request('search')."%");
            }
            if (\request('type') == 'Pending') {
                $query->where('status', 0);
            } else if (\request('type') == 'Completed') {
                $query->where('status', 1);
            } else if (\request('type') == 'Rejected') {
                $query->where('status', 2);
            }

            if (\request('number')) {
                $pag = request('number');
            }
            $query->orderBy('id','desc');
            $orders = $query->paginate($pag);
            return $this->returnData(true, '', $orders);
        }
        return view('admin.Manage.live-orders',compact('clients','lastOrder'));
    }
    public function livePayment($id) {
        $data = request()->all();
        $liveOrder = LiveOrders::find($id);
        if ($liveOrder->status == 1) {
            return Redirect::back();
        }
        $validate = Validator::make($data,[
            'card_number'=>'required',
            'month'=>'required',
            'year'=>'required',
            'cvv'=>'required',
        ]);
        if ($validate->errors()->messages() != null) {
//            dd($validate->errors()->first());
            Alert::warning('Incorect data!', $validate->errors()->first());
            return Redirect::back();
        }
        $transaction = new Transaction();
        $payment = new PaymentHelper();
        $user = new \stdClass();
        $user->email = $liveOrder->email;
        $b = $payment->charge([
            'amount' => $liveOrder->total,
            "number" => $data['card_number'],
            "exp_month" => $data['month'],
            "exp_year" => $data['year'],
            "cvc" => $data['cvv'],
            'description' => 'new order',
            //            'token' => request('stripeToken'),
            'user' => $user
        ], 'eur');

//                dd($b);
        if (!isset($b->id)) {
            Alert::warning('Incorect data!', $b);
            return Redirect::back();
        }
//                if ($b->code = )
        $transaction->trans_id = $b->id;
        $transaction->trans_data = json_encode($b);
        $transaction->save();

        $liveOrder->status = 1;
        $liveOrder->save();

        return Redirect::back();
    }
    public function paypalSuccess() {
        $id = \request('id');
        $liveOrder = LiveOrders::find($id);
        if ($liveOrder->status == 1) {
            return $this->returnData(true, 'completed already', null);
        }
        $pp = json_decode(\request('paypal'));
        if ($pp->status != 'COMPLETED') {
            Alert::warning('Error !', 'Payment rejected.');
            return $this->returnData(false, 'Payment rejected', null);
        }
        $liveOrder->status = 1;
        $liveOrder->save();

        return $this->returnData(true, 'completed', null);
    }
    public function store(){

        request()->validate([
            'fullname'=>'required',
            'nickname'=>'required',
            'address'=>'required',
            'zip'=>'required',
            'city'=>'required',
            'country'=>'required',
            'email'=>'required',
            'phone'=>'required',
            'products'=>'required',
            'total'=>'required'
        ]);

        $liveOrder = new LiveOrders();
        $liveOrder->fullname = request('fullname');
        $liveOrder->nickname = request('nickname');
        $liveOrder->address = request('address');
        $liveOrder->zip = request('zip');
        $liveOrder->city = request('city');
        $liveOrder->country = request('country');
        $liveOrder->email = request('email');
        $liveOrder->phone = request('phone');
        $liveOrder->products = request('products');
        $liveOrder->total = request('total');
        $liveOrder->save();

        return redirect()->back()->with('success','Order Registered Successfully.');
    }
    public function show($id){
        $liveOrder = LiveOrders::findOrFail($id);
        if ($liveOrder->status == 1) {
            Alert::success('Payment completed.', 'Thank you for your purchase.');
        } else if ($liveOrder->status == 2) {
            Alert::warning('Error !', 'Payment rejected.');
        }
        return view('live-order',compact('liveOrder'));
    }
    public function changeType() {
        $id = request('id');
        $type = request('type');
        $liveOrder = LiveOrders::find($id);

        if ($type == 1 || $type == 2) {
            $liveOrder->status = $type;
        } else {
            return $this->returnData(false, 'Something went wrong, try again later.', null);
        }
        $liveOrder->status = $type;
        $liveOrder->save();

        return $this->returnData(true, 'Status changed', $liveOrder);
    }
}
