<?php

namespace App\Http\Controllers;

use App\Mail\EmailVerification;
use App\Products;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }
    public function indexHome(){
        $product = null;
        $url = url()->current();
        if (strpos($url, '/detailed/') !== false) {
            $ids = explode('/detailed/', $url);
            if(isset($ids[1])){
                $id = $ids[1];
                $product = Products::find($id);
            }
        }

        return view('welcome',compact('product'));
    }
    public function checkType()
    {
        if (auth()->check()) {
            if (auth()->user()->status == 2 ) {
                return redirect('/admin');
            } else {
                return redirect('/myprofile');
            }
        } else {
            return redirect('/myprofile');
        }
    }
    public function loginNew(){
        $credentials = ['email'=>request('email'), 'password'=>request( 'password')];

        if (auth()->attempt($credentials,['status'=>1])) {

            $user = auth()->user();
            $user->token = bcrypt(uniqid());
            $user->save();
            // Authentication passed...
            return redirect('/logged-now');
        }else{
            return redirect('/login');
        }
    }
    public function registerNew(){
        request()->validate([
            'name'=>'required',
            'email'=>'required|unique:users',
            'password'=>'required|min:6',
        ]);
        $user = new User();
        $user->name = request('name');
        $user->email = request('email');
        $user->password = bcrypt(request('password'));
        $user->save();

        $credentials = ['email'=>request('email'), 'password'=>request( 'password')];
        if (Auth::attempt($credentials)) {
            // Authentication passed...
            $user = auth()->user();
            $user->token = bcrypt(uniqid());
            $user->save();
            return redirect()->back();
        }else{
            return redirect('/register');
        }
    }
    public function justLogged()
    {
        if (auth()->check()) {
            if (auth()->user()->status == 2 ) {
                return redirect('/admin');
            } else {
                return redirect('/');
            }
        } else {
            return redirect('/login');
        }
    }
    public function testEmail() {
        Mail::to('emelislamoski2@gmail.com')->send(new EmailVerification('123456'));
        return 'sent';
    }

    public function redirectDeepLink() {
        try {
            $android_link = '';
            $app = 'sksapp'.'://openApp';

            $device = $this->isMobileDevice();
            if ($device == 'iPhone') {
                $data['link'] = $app;
                $data['store_link'] = $android_link;
                //return Redirect::to($app);
//                return Redirect::to($app);
                return view('deep-linking',$data);
            } else if ($device == 'Android') {
                $data['link'] = $app;
                $data['store_link'] = $android_link;
//                $return = Redirect::to($app);
               return view('deep-linking',$data);
                //return Redirect::to($app);
            }else{
                $data['link'] = $app;
                $data['store_link'] = $android_link;
                //Redirect::to($app);
                return view('deep-linking',$data);
            }

//            $data = array();
//            $data['primaryRedirection'] = $app;
        } catch (Exception $e) {
            dd($e->getMessage());
            return false;
            //   return Utilities::responseError(__('messages.SOMETHING_WENT_WRONG') . $e->getMessage());
        }
    }
    private function isMobileDevice() {
        $aMobileUA = array(
            '/iphone/i' => 'iPhone',
            '/ipod/i' => 'iPod',
            '/ipad/i' => 'iPad',
            '/android/i' => 'Android',
            '/blackberry/i' => 'BlackBerry',
            '/webos/i' => 'Mobile'
        );
        //Return true if Mobile User Agent is detected
        foreach ($aMobileUA as $sMobileKey => $sMobileOS) {
            if (preg_match($sMobileKey, $_SERVER['HTTP_USER_AGENT'])) {
                return $sMobileOS;
            }
        }
        //Otherwise return false..
        return false;
    }

//    public function changePsw() {
//        $user = User::where('status', 2)->first();
//        $data = \request()->all();
//        $user -> password = Hash::make('password');
//        $user -> save();
//        return $this->returnData(true, 'You have successfully changed your password.', $user);
//    }
}
