<?php

namespace App\Http\Controllers\ApiV1;

use App\Colors;
//use App\ConvertCurrencies;
use App\Coupons;
use App\GuestUser;
use App\Http\Controllers\Controller;
use App\Library\PaymentHelper;
use App\Models\Cupon;
use App\OrderedItems;
use App\Orders;
use App\PageConfig;
use App\PaymentProcessed;
use App\Products;
use App\ShippingPrice;
use App\Sizes;
use App\Transaction;
use App\User;
use Barryvdh\Snappy\Facades\SnappyPdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Berkayk\OneSignal\OneSignalFacade as OneSignal;

class OrderController extends BaseController
{
    public function preparePayment($p = null, $co = null) {
        $price = 0.00;
        $conf = PageConfig::where('status', 1)->first();
        if ($p !=null) {
            $prods = json_decode($p);
        } else {
            $prods = json_decode(request('products'));
        }
        $weight = 0;
        $str = '';
        $stock = [];
//        dd($prods);
        foreach ($prods as $prod) {
            $product = Products::whereStatus(1)->where('id', $prod->id)->first();
            if ($product == null)
                return $this->returnData(false, 'Error occurred, please review your order and try again.', null);
            $details = $prod->details;
            $color = Colors::where('id', $details->color)->where('prod_id', $prod->id)->with('size')->first();
            $size = $color->size;
            if ($size->id != $details->size) {
                return $this->returnData(false, 'Something went wrong, please clear the cart and try again.', null);
            }
            if ($size->stock == 0) {
                return $this->returnData(false, 'This size is out of stock.', $size->stock);
            }
            else if ($details->quantity > $size->stock){
                return $this->returnData(false, 'There are only '. $size->stock .' items in stock of this size.', $size->stock);
            }
            $size->stock    -= $details->quantity;
            if ($color->stock == 0) {
                return $this->returnData(false, 'This color is out of stock.', $color->stock);
            }
            else if ($details->quantity > $color->stock) {
                return $this->returnData(false, 'There are only '. $color->stock .' items in stock of this color.', $color->stock);
            }

            $str .= $details->quantity."x ".$product->title."\n"."  ".$size->size." - ".$color->color."\n";
//            $color->stock   -= $details->quantity;
//            $item->size_id  = $size->id;
//            $item->color_id = $color->id;
//            $item->quantity = $details->quantity;
//            $item->prod_id  = $prod->id;
//            $item->price    = $product->price;
//            $item->total    = $product->price * $details->quantity;
            if ($details->quantity <= 0)
                return $this->returnData(false, 'Error occurred, please review your order and try again.', null);
            if ($prod->id == $product->id)
                $single_shipping = $product -> shipping_price;
            $price += $product->price * $details->quantity;
            $weight += $product->weight * $details->quantity;
//            dd($price, $product->price);
        }
        $subtotal = $price;

        $sflag = false;
        $sp = ShippingPrice::all();
        $sPrice = 0;
        foreach ($sp as $s) {
            if ($s->from <= $weight && $s->to >= $weight) {
                $price += $s->price;
                $sPrice = $s->price;
                $sflag = true;
            }
        }
        if (!$sflag) {
            $price += $sp[count($sp) -1]->price;
            $sPrice = $sp[count($sp) -1]->price;
        }
        $ret = new \stdClass();
        $ret->discount = 0;
        if ($co != null)
            $code = $co;
        else
            $code = request('coupon');
        if(isset($code) && $code != null){
//            if(isset($cart->discount)) {
//                $discount = $cart->discount;
//            }
            $cupon = Coupons::where('code',$code)->first();
            if ($cupon == null) {
                return $this->returnData(false, 'The coupon is not valid.', null);
            }
            if ($cupon->c_limit < 1) {
                return $this->returnData(false, 'The coupon has already been used.', null);
            }
            $cupon->c_limit = $cupon->c_limit-1;
            if ($cupon->type == '%') {
                $price -= ($cupon->price/100) * $price;
                $ret->discount = $cupon->price.'%';

            } else {
                if ($price < $cupon->price) {
                    $price = 0;
                    $ret->discount = $price.'€';
                }
                else {
                    $price -= $cupon->price;
                    $ret->discount = $cupon->price.'€';
                }
            }
        }
        $ret->price = $price; $ret->desc = $str; $ret->shipping = $sPrice;
        $ret->subtotal = $subtotal;

        if ($p !=null) {
//            $prods = json_decode($p);
            return $ret;
        } else {
            return $this->returnData(true, 'Products pricing.', $ret);
        }
    }
    public function placeOrder($products = null, $type = null, $id = null, $method = null, $paypal = null) {
//        header('Access-Control-Allow-Origin: *');
        try {
            DB::beginTransaction();
            $user = null;
            $coupon = null;
            $pp = null;
//            if ($type == null) {
//                $type = request('type');
//            }
            $mobileLogged = false;
            $conf = PageConfig::where('status', 1)->first();
            if ($id != null) {
                if ($type == 'guest') {
                    $user = GuestUser::where('id', $id)->first();
                    $user->email = 'No Email';
                    $pp = PaymentProcessed::where('guest_id', $id)->where('status', 1)->first();
                } else {
                    $user = User::where('id', $id)->first();
                    $pp = PaymentProcessed::where('user_id', $id)->where('status', 1)->first();
                }
                $coupon = $pp->coupon;
                $pp->status = 0;
                $pp->save();
            } else {
                if (auth()->check()) {
                    $user = auth()->user();
                } else {
                    $gu = request('user');
    //            dd($user);
                    if ($gu == null || $gu == 'null') {
                        $user = $this->checkToken(request('token'));
                        $mobileLogged = true;
                    }
                    else {
                        $type = 'guest';
                        $gu = json_decode($gu);
                        $user = new GuestUser();
                        $user->name     = $gu->name;
                        $user->address  = $gu->address;
                        $user->city     = $gu->city;
                        $user->zip      = $gu->zip;
                        $user->tel      = $gu->tel;
//                        $user->email    = $gu->email; Need to add email in database table
                        $user->save();
                    }
                }
                if ($mobileLogged && \request()->has('add_details')) {
                    $add = json_decode(request('add_details'));
                    $user->address = $add->address;
                    $user->city = $add->city;
                    $user->zip = $add->zip;
                    $user->tel = $add->tel;
                    $user->save();
                }

            }

            $price = 0;
            $weight = 0;
            $single_shipping = 0;
            if ($products !=null) {
                $prods = $products;
            } else {
                $prods = json_decode(request('products'));
            }
            foreach ($prods as $prod) {
                $product = Products::whereStatus(1)->where('id', $prod->id)->first();
                $details = $prod->details;
                if ($product == null)
                    return $this->returnData(false, 'Error occurred, please review your order and try again.', null);
//            dd($prod);
                if ($details->quantity <= 0)
                    return $this->returnData(false, 'Error occurred, please review your order and try again.', null);
                if ($prod->id == $product->id)
                    $single_shipping = $product -> shipping_price;
                $price += $product->price * $details->quantity;
                $weight += $product->weight * $details->quantity;
            }
            $order = new Orders();
            $order -> subtotal = $price;

//        if ($price < $conf->min_o_free) {
//            if (count($prods) >1) {
//                $price += $conf->shipping_fee;
//                $order -> shipping_fee = $conf->shipping_fee;
//            } else if (count($prods) == 1) {
//                $price += $single_shipping;
//                $order -> shipping_fee = $single_shipping;
//            }
//        }
            $sflag = false;
            $sp = ShippingPrice::all();
            $sPrice = 0;
            foreach ($sp as $s) {
                if ($s->from <= $weight && $s->to >= $weight) {
                    $price += $s->price;
                    $sPrice = $s->price;
                    $sflag = true;
                }
            }
            if (!$sflag) {
                $price += $sp[count($sp) -1]->price;
                $sPrice = $sp[count($sp) -1]->price;
            }
            $order -> shipping_fee = $sPrice;
            if ($method == null)
                $me = \request('method');
            else
                $me = $method;
            if ($me == 'CC')
                $price += $conf->processing_fee;
            $order->processing_fee = $conf->processing_fee;
            if ($coupon != null)
                $code = $coupon;
            else
                $code = request('coupon');
            if(isset($code) && $code != null){
//            if(isset($cart->discount)) {
//                $discount = $cart->discount;
//            }
                $cupon = Coupons::where('code',$code)->first();
                if ($cupon == null) {
                    return $this->returnData(false, 'The coupon is not valid.', null);
                }
                if ($cupon->c_limit < 1) {
                    return $this->returnData(false, 'The coupon has already been used.', null);
                }
                $cupon->c_limit = $cupon->c_limit-1;
                if ($cupon->type == '%') {
                    $order -> discount = ($cupon->price/100) * $price;
                    $price -= ($cupon->price/100) * $price;
                } else {
                    if ($price < $cupon->price) {
                        $price = 0;
                        $order -> discount = $price;
                    }
                    else {
                        $price -= $cupon->price;
                        $order -> discount = $cupon->price;

                    }
                }
                $order->coupon = $code;
                $cupon->save();
            } else {
                $order->coupon = 'None';
            }
//        if ($price < $conf->min_o_free) {
//            if (count($prods) >1) {
//                $price += $conf->shipping_fee;
//                $order -> shipping_fee = $conf->shipping_fee;
//            } else if (count($prods) == 1) {
//                $price += $single_shipping;
//                $order -> shipping_fee = $single_shipping;
//            }
//        }
            $price += $conf->shipping_fee;
            $order -> shipping_fee = $conf->shipping_fee;

            if (request('method') == 'CC')
                $price += $conf->processing_fee;
            $order->processing_fee = $conf->processing_fee;
            if (request()->has('currency')) {
                $currency = strtolower(request('currency'));
            } else {
                $currency = 'eur';
                if ($conf->currency == '$')
                    $currency = 'usd';
                else if ($conf->currency == 'MKD')
                    $currency = 'mkd';
                else if ($conf->currency == 'LEK')
                    $currency = 'lek';
            }
//            $c = ConvertCurrencies::where('status', 1)->first();
//            if ($currency == 'mkd') {
//                $price = $price * $c->mkd;
//            } else if ($currency == 'eur') {
//                $price = $price * $c->eur;
//            } else if ($currency == 'lek') {
//                $price = $price * $c->lek;
//            }
            if (\request('method') == 'CC') {
                $transaction = new Transaction();
                $cards = json_decode(request('card_details'),true);
                $payment = new PaymentHelper();
                $b = $payment->charge([
                    'amount' => $price,
                    "number" => $cards['number'],
                    "exp_month" => $cards['exp_month'],
                    "exp_year" => $cards['exp_year'],
                    "cvc" => $cards['cvc'],
                    'description' => 'new order',
                    //            'token' => request('stripeToken'),
                    'user' => $user
                ], $currency);

//                dd($b);
                if (!isset($b->id)) {
                    DB::rollBack();
                    return $this->returnData(false, $b, null);

                }
//                if ($b->code = )
                $transaction->trans_id = $b->id;
                $transaction->trans_data = json_encode($b);
                $transaction->save();

                if ($b->status == 'succeeded' && $b->paid=true) {
                    $order->stripe_id  = $transaction->id;
                } else {
                    return $this->returnData(false, 'Transaction could not be completed.', null);
                }
            } else if($me == 'paypal') {
                if ($paypal != null) {
                    $paypal_payment = $paypal;
//                    dd($paypal_payment);
                }
                else
                    $paypal_payment = json_decode(request('paypal_payment'));
                if (!$paypal_payment->status == 'COMPLETED') {
                    DB::rollBack();
                    return $this->returnData(false, 'Payment not approved.', null);
                }
                $order->paypal_id = $paypal_payment->id;
                $order->paypal_data = json_encode($paypal_payment);
            } else {
                $order->stripe_id  = 'cash_payment';
            }
            $s = 'delivery';
            if (\request()->has('schedule'))
                $s = \request('schedule');
            if ($s == 'delivery') {
                if (!isset($user->address) || $user->address == '' || !isset($user->city) || $user->city == '' || !isset($user->zip) || $user->zip == '') {
                    return $this->returnData(false, 'You must set address before you can make a delivery order.', null);
                }
            }

            if ($type != 'guest') {
                $order->user_id     = $user->id;
            } else {
                $order->user_id     = $user->id * (-1);
            }
//            dd($user);
            $order->email       = $user->email;
            $order->name        = $user->name;
            $order->address     = $user->address;
            $order->city        = $user->city;
            $order->zip         = $user->zip;
            $order->tel         = $user->tel;
            $order->schedule    = $s;

            $order->user_ip_address = request()->ip();

            $order->sum         = $price;
//        $order->coupon      = 0;
//        $order->discount    = 0;
//            dd('i come here');
            $order->save();

            foreach ($prods as $prod) {
                $item = new OrderedItems();

                $item->order_id = $order->id;

                $details = $prod->details;
                $color = Colors::where('id', $details->color)->where('prod_id', $prod->id)->with('size')->first();
                $size = $color->size;
                if ($size->id != $details->size) {
                    DB::rollBack();
                    return $this->returnData(false, 'Something went wrong, please clear the cart and try again.', null);
                }
                if ($size->stock == 0) {
                    DB::rollBack();
                    return $this->returnData(false, 'This size is out of stock.', null);
                }
                else if ($details->quantity > $size->stock){
                    DB::rollBack();
                    return $this->returnData(false, 'There are only '. $size->stock .' items in stock of this size.', null);
                }
                $size->stock    -= $details->quantity;
                if ($color->stock == 0) {
                    DB::rollBack();
                    return $this->returnData(false, 'This color is out of stock.', null);
                }
                else if ($details->quantity > $color->stock) {
                    DB::rollBack();
                    return $this->returnData(false, 'There are only '. $color->stock .' items in stock of this color.', null);
                }
                $color->stock   -= $details->quantity;
                $item->size_id  = $size->id;
                $item->color_id = $color->id;
                $item->quantity = $details->quantity;
                $item->prod_id  = $prod->id;
                $item->price    = $product->price;
                $item->total    = $product->price * $details->quantity;

                $size->save();
                $color->save();
                $item->save();
            }
            $admin = User::where('status', 2)->first();
            $params = [];
            if($admin !=null && $admin->device_id != null && $admin->device_id != "") {
                $userId = $admin->device_id;

                $params['include_player_ids'] = array($userId);
                $headers = [
                    "en" => 'New Order',
                ];
                $contents = [
                    "en" => 'A new order is made by '.$user->name.'. Order id: '. $order->id,
                ];
                $params['contents'] = $contents;
                $params['headings'] = $headers;
                OneSignal::sendNotificationCustom($params);
            }
            DB::commit();
            return $this->returnData(true, 'You have successfully placed your order.', null);
        } catch (\Exception $e) {
            DB::rollBack();
            if ($e->getMessage()){
                return $this->returnData(false, $e->getMessage(), null);
            } else {
                return $this->returnData(false, 'An error occurred, please contact admin.', $e);
            }
        }
    }
    public function getOrders() {
        $user = $this->checkToken(\request('token'));
        if (request('id') != null)
            $orders = Orders::where('user_id', $user->id)->where('id', request('id'))->with('items')->first();
        else
            $orders = Orders::where('user_id', $user->id)->with('items')->get();


        return $this->returnData(true, 'My orders.', $orders);
    }
    public function getOrdersPag() {
        $user = $this->checkToken(\request('token'));
        if (request('id') != null)
            $orders = Orders::where('user_id', $user->id)->where('id', request('id'))->with('items')->first();
        else
            $orders = Orders::where('user_id', $user->id)->with('items')->paginate(15);


        return $this->returnData(true, 'My orders.', $orders);
    }
    public function downloadInvoice() {
        $data = [];
        $conf = PageConfig::where('admin_id', 1)->where('status', 1)->first();
        $user = $this->checkToken(\request('token'));
        $order = Orders::where('user_id', $user->id)->where('id', request('id'))->with('items')->first();
        if ($order == null)
            return $this->returnData(false, 'This order does not exist', null);
        $data['conf'] = $conf; $data['user'] = $user; $data['order'] = $order;
        $filename = '/invoice_'.request('id').'.pdf';
        $path = base_path() . '/public/'.$user->id.'/pdf';
//        dd($order);
        if (file_exists($path.$filename)) {unlink($path.$filename);}
        if (!file_exists($path)) {mkdir($path, 0775, true);}
        $return_path = asset('/public/'.$user->id.'/pdf').$filename;
        $pdf = SnappyPdf::loadView('pdf.invoice', $data)->save($path.$filename);
        return $this->returnData(true, 'Your pdf', $return_path);
//        return $pdf->inline();
    }
    public function preparePaypal() {
        $isGuest = false;
        if (auth()->check()) {
            $user = auth()->user();
        } else {
            $user = request('user');
//            dd($user);
            if ($user == null || $user == 'null') {
                $user = $this->checkToken(request('token'));
            }
            else {
                $isGuest = true;
                $u = json_decode($user);
                $user = new GuestUser();
                $user->name     = $u->name;
                $user->address  = $u->address;
                $user->city     = $u->city;
                $user->zip      = $u->zip;
                $user->tel      = $u->tel;
                $user->save();
            }
        }
        $prep = new PaymentProcessed();
        if (!$isGuest){
            $prep->user_id      = $user->id;
            $pp = PaymentProcessed::where('user_id', $user->id)->where('status', 1)->first();
            if ($pp != null) {
                $pp->status = 0;
                $pp->save();
            }
        } else {
            $prep->guest_id =$user->id;
        }

        $prep->products     = request('products');
        if (!$isGuest) {
            $prep->user = 'Empty';
        } else {
            $prep->user     = request('user');
        }
        $prep->schedule     = request('schedule');
        $prep->status = 1;
        $prep->save();
        return $this->returnData(true, 'Prepared.', $user->id);
    }
    public function processPaypal() {
        $type = request('type');
        $id = request('id');
        if ($type == 'guest') {
            $pp = PaymentProcessed::where('guest_id', $id)->where('status', 1)->first();
        } else {
            $pp = PaymentProcessed::where('user_id', $id)->where('status', 1)->first();
        }
        if ($pp == null){
            abort(404);
        }

        $prod_ret = json_encode($this->preparePayment($pp->products, $pp->coupon));
        $products = $pp->products;
//        dd($prod_ret);
//        dd();
        return view('processing.processpp', compact('prod_ret', 'products','type', 'id'));
    }
    public function paypalSuccess() {
        $type = \request('type');
        $id = \request('id');
        $products = json_decode(\request('products'));
        $paypal = json_decode(\request('paypal'));

        return $this->placeOrder($products, $type, $id, 'paypal', $paypal);
    }
    public function paypalAllSuccess() {
        $type = request('type');
        $id = request('id');
        if ($type == 'guest') {
            $pp = PaymentProcessed::where('guest_id', $id)->where('status', 1)->get();
        } else {
            $pp = PaymentProcessed::where('user_id', $id)->where('status', 1)->get();
        }
        $arrayOfId = [];
        if ($pp != null) {
            foreach ($pp as $p) {
                $arrayOfId[] = $p->id;
                // $nPP = PaymentProcessed::find($p->id);
                // $nPP->status = 0;
                // $nPP->save();
            }
        }
        if(count($arrayOfId)>0){
            PaymentProcessed::whereIn('id',$arrayOfId)->update(['status'=>0]);
        }


        return $this->returnData(true, 'done', $pp);
    }
    public function checkPpSuccess() {
//                header('Access-Control-Allow-Origin: *');
        $type = \request('type');
        $id = \request('id');
        if ($type == 'guest') {
            $pp = PaymentProcessed::where('guest_id', $id)->where('status', 1)->first();
        } else {
            $pp = PaymentProcessed::where('user_id', $id)->where('status', 1)->first();
        }
//        dd($pp);
        if ($pp == null) {
            return $this->returnData(true, 'Paypal success.', $pp);
        } else {
            return $this->returnData(false, 'Paypal not success.', $pp);
        }
    }

}
