<?php

namespace App\Http\Controllers\ApiV1;

use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;

class BaseController extends Controller
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct(){
        header('Access-Control-Allow-Headers: *');
//        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Credentials: true");
        header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    }

    public function returnData($status, $message, $values, $errors=null,$error=200,$action=null){
        return response()->json([
            'status'    =>$status,
            'message'   =>$message,
            'values'    =>$values,
            'errors'    =>$errors,
            'error'     =>$error,
            'action'    =>$action
        ]);
        //   ->header('Access-Control-Allow-Origin', '*')
        // ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
        // ->header('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, X-Token-Auth, Authorization');;
    }
    public function checkToken($token){
        if($token!=null){
            $user = User::where('token', $token)->first();
            if($user!=null){
                return $user;
            }
            abort($this->tokenInvalid());
        }
        abort($this->tokenInvalid());
    }

    public function tokenInvalid(){
        return response()->json(array(
            'status'    => false,
            'message'   => 'Invalid Token!',
            'values'    => null,
            'error'     => 401
        ));
    }
    public function errorOccurred() {
        return $this->returnData(false, 'An error occurred, please try again.', null);
    }
}
