<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    public function editAdminInfo() {
        $user = auth()->user();
        $data = \request()->all();
        $validate_email = 'required|email';
        if ($data['email'] != auth()->user()->email) {
            $validate_email = 'required|email|unique:users';
        }
        $validate = Validator::make($data, [
            'email' => $validate_email,
            'current_password' => 'required',
            'new_password' => 'required|min:8|confirmed',
//            'confirm_password' => ['required']
        ]);

        if($validate->errors()->messages() != null){
            return $this->returnData(false, $validate->errors()->first(), null);
        }
        if (Hash::check($data['current_password'], $user->password)) {
            $user -> email = $data['email'];
            $user -> password = Hash::make($data['new_password']);
            $user -> save();
            return $this->returnData(true, 'Your info has been changed.', null);
        } else {
            return $this->returnData(false, 'Your current password does not match.', null);
        }
    }
}
