<?php

namespace App\Http\Controllers\Admin;

use App\Colors;
use App\Http\Controllers\Controller;
use App\Library\ImageHelper;
use App\ProductImage;
use App\Products;
use App\Sizes;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use RealRashid\SweetAlert\Facades\Alert;

class ProductsController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'isAdmin']);
    }
    public function product($prod_id = 0) {
        $sizes = json_decode(request("sizes"),true);
        $prod = json_decode(request('product'),true); // this true decodes the data to array, no true means data is decoded in object
        $cat = json_decode(request('category'), true);
//            dd(request('category'));
        $prod["image"] = request()->file('image');
        $imageValid = '';
        if(\request()->hasFile("image") && \request()->file("image")->isValid())
            $imageValid = 'required|image|mimes:jpeg,png,jpg';
        $validate = Validator::make($prod, [
            'title' => ['string', 'required'],
            'prod_desc' => ['string', 'required'],
            'code' => ['string', 'required'],
            'price' => ['numeric','gt:0', 'required'],
            'weight' => ['string', 'required'],
            'image' =>$imageValid,
        ]);
        if($validate->errors()->messages() != null){
            return $this->returnData(false, $validate->errors()->first(), '');
        }
        try {
            DB::beginTransaction();

            if($prod_id == 0){
                $message = "created";
                $product = new Products();
            }else{
                $message = "updated";
                $product = Products::find($prod_id);
                if($product == null){
                    return $this->returnData(false,"Product was not found on the server.",null,500);
                }
            }
            if(\request()->hasFile("image") && \request()->file("image")->isValid()){
                $url = ImageHelper::uploadImage(request()->file('image'), auth()->user(), 'product_image', null, 320);
                $product->image = $url;

            }
            $product->title             = $prod["title"];
            $product->description       = $prod["prod_desc"];
            $product->code              = $prod["code"];
            $product->price             = $prod["price"];
            $product->shipping_price    = $prod["shipping_price"];
            $product->weight            = $prod["weight"];
            $product->sub_category_id   = $cat["sub_cat"];
            $product->save();
            ProductImage::where('prod_id',$product->id)->whereIn("status",[0,1,9])->delete();


            if(isset($product->image)){
                $img = new ProductImage();
                $img->prod_id = $product->id;
                $img->image = $product->image;
                $img->status = 1;
                $img->save();
            }

            $fs = \request("files");
            if (isset($fs)) {
                foreach($fs as $key => $file) {
                    $img = new ProductImage();
                    if(!is_string($file) && $file->isValid()){
                        $url = ImageHelper::uploadImage($file, auth()->user(), 'product_image', null, 320);
                        $urls[] = $url;
                    }else{
                        $url = $file;
                    }
                    $img->prod_id = $product->id;
                    $img->image = $url;
                    $img->status = 1;
                    $img->save();
                }
            }
            $newSizes = new Collection();
//            dd($sizes);
            foreach($sizes as $s){
                if(array_key_exists("id",$s) && $s["id"] != 0){
                    $size = Sizes::find($s["id"]);
                }else{
                    $size = new Sizes();
                }
                $size->prod_id = $product->id;
                $size->size = $s["size"];
                $size->stock = $s['stock'];
                $size->save();
                $tmpClrs = Colors::where('size_id', $size->id)->get();
                foreach ($tmpClrs as $tc) {
                    $tc->delete();
                }
                foreach($s["colors"] as $c){
//                    if(array_key_exists("id",$c) && $c["id"] != 0){
//                        $color = Colors::find($c["id"]);
//                    }else{
//                        $color = new Colors();
//                    }
                    $color = new Colors();

                    $color->prod_id = $product->id;
                    $color->size_id = $size->id;
                    $color->stock = $c['stock'];
                    $color->color = $c['color'];
                    $color->color_code = $c['color_code'];
                    $color->save();
                }
//                dd('here');
                $size->colors = $size->colors()->get();

                $newSizes->push($size);
            }
            DB::commit();
            return $this->returnData(true,"Product $message successfully",["product" => $product, "sizes" => $newSizes]);
        }catch (\Exception $e){
            DB::rollBack();
            return $this->returnData(false,"Server error, Please contact Administrator",null,$e->getMessage(),500);
        }


    }
    public function deleteProduct($id) {
        try {
            DB::beginTransaction();

//            $sizes = json_decode(request("sizes"),true);
            $product = Products::where('id', $id)->with('sizes')->first();
//            dd($product->sizes);
            $type = request('type');
            $message = '';
            if ($type == 'delete') {
                if(isset($product->sizes)){
                    foreach($product->sizes as $s){
                            $size = Sizes::find($s["id"]);
                            $size->delete();

                        foreach($s["colors"] as $c){
                                $color = Colors::find($c["id"]);
                                $color->delete();
                        }
                    }
                }
                $product -> delete();
                $message = 'Product deleted successfully';
            } else if ($type == 'deactivate') {
                $product -> status = 0;
                $product -> save();
                $message = 'Product deactivated successfully';
            } else if ($type == 'activate') {
                $product -> status = 1;
                $product -> save();
                $message = 'Product activated successfully';
            }

            DB::commit();

            return $this->returnData(true, $message, $product);

        }catch (\Exception $e){
            DB::rollBack();
            return $this->returnData(false,"Server error, Please contact Administrator",null,$e->getMessage(),500);
        }
    }

}
