<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Orders;
use Illuminate\Http\Request;
use Stripe\Order;

class OrderController extends Controller
{
    public function manageOrders() {
        return view('admin.Manage.orders');
    }
    public function getOrders() {
        $pag = 30;
        if (request()->has('number'))
            $pag = request('number');
        if (request()->has('search')) {
            $orders = Orders::with('items')->orderBy('created_at', 'desc')->where('name','like',"%".request('search')."%")->orWhere('id','like',"%".request('search')."%")->paginate($pag);
        } else {
            $orders = Orders::with('items')->orderBy('created_at', 'desc')->paginate($pag);
        }
        return $this->returnData(true, 'orders', $orders);
    }
    public function readyOrder() {
        $id = request('id');
        $info = request('info');
        if (!isset($info) || $info == '') {
            return $this->returnData(false, 'Please provide info for the order.', null);
        }
        $order = Orders::find($id);
        $order->info = $info;
        $order->status = 2;
        $order->save();
        return $this->returnData(true, 'Action performed successfully.', $order);
    }
    public function cancelOrder() {
        $id = request('id');
        $info = request('info');
        if (!isset($info) || $info == '') {
            return $this->returnData(false, 'Please provide info for the order.', null);
        }
        $order = Orders::find($id);
        $order->info = $info;
        $order->status = 4;
        $order->save();
        return $this->returnData(true, 'Action performed successfully.', $order);
    }
    public function completeOrder() {
        $id = request('id');
        $order = Orders::find($id);
        $order->status = 3;
        $order->save();
        return $this->returnData(true, 'Order reached its destination.', $order);
    }
    public function editOrderInfo() {
        $id = request('id');
        $info = request('info');
        if (!isset($info) || $info == '') {
            return $this->returnData(false, 'Please provide info for the order.', null);
        }
        $order = Orders::find($id);
        $order->info = $info;
        $order->save();
        return $this->returnData(true, 'Order edited successfully.', $order);
    }
}
