<?php

namespace App\Http\Controllers\Admin;

use App\Banners;
use App\Category;
use App\Coupons;
use App\CustomClients;
use App\Exports\ClientsExport;
use App\Exports\ExportExample;
use App\Http\Controllers\Controller;
use App\Imports\ClientsImport;
use App\Library\ImageHelper;
use App\Products;
use App\Section;
use App\ShippingPrice;
use App\SubCategory;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;

class ManageShopController extends Controller
{
    public function addBanner(){

        $type = request('type');
//        dd($type);
        $banners = Banners::where("type",$type)->whereIn("status",[0,1,9])->get();
        foreach($banners as $banner){
            $deleted = false;
            if($banner->status == 0)
                $banner->status = 9;
            elseif($banner->status == 1)
                $banner->status = 0;
            elseif($banner->status == 9){
                $deleted = true;
                $banner->delete();
            }
            if(!$deleted)
                $banner->save();
        }
        $desc = explode(",",\request("desc"));
        $prod_id = explode(",",\request("prod_ids"));
        $urls = [];
        $width  =   1280;
        $height = null;
        if ($type == 'collection') {
            $width = null;
            $height = 400;
        }
        foreach(\request("files") as $key => $file) {
            $banner = new Banners();
            if(!is_string($file) && $file->isValid()){
                $url = ImageHelper::uploadImage($file, auth()->user(), $type, $width, $height);
                $urls[] = $url;
            }else{
                $url = $file;
            }
            if(array_key_exists($key,$prod_id) && $prod_id[$key] != null && $prod_id[$key] != ""){
                $banner->prod_id = $prod_id[$key];
            }
            if(array_key_exists($key,$desc) && $desc[$key] != null && $desc[$key] != "")
                $banner->description = $desc[$key];

            $banner->image = $url;
            $banner->type = $type;
            $banner->save();
        }

        return $this->returnData(true,"Action performed successfully.",$urls);
    }
    public function addCategory($id = 0){
        $data = request()->all();
        $imageValid = '';
        $uniqueTitle = '';

        if ($id == 0) {
            $uniqueTitle = 'unique:categories,title';
        }
//        dd($uniqueTitle);

        if (\request()->hasFile("image") && \request()->file("image")->isValid())
            $imageValid = 'required|image|mimes:jpeg,png,jpg,svg';
        $validate = Validator::make($data, [
            'category' => ['required', 'string', $uniqueTitle],
            'ordered_by' => ['required', 'integer'],
            'image' =>$imageValid,
        ]);

        if ($validate->errors()->messages() != null) {
            return $this->returnData(false, $validate->errors()->first(), '');
        }

//        dd('here', $id);

        $catName = request('category');
        $catOrder = request('ordered_by');
        $categories = null;
        if ($id == 0) {
            $cat = new Category();
            $categories = Category::where('ordered_by', '>=', $catOrder)->get();
        } else {
            $cat = Category::find($id);
            if ($cat == null) {
                return $this->returnData(false, 'Category could not be edited.', null, 500);
            }
            $currentOrder = $cat->ordered_by;
            if ($currentOrder < $catOrder) {
                $categories = Category::where('id','!=', $cat->id)->where('ordered_by', '>=', $currentOrder)->where('ordered_by', '<=', $catOrder)->get();
            } else if ($currentOrder > $catOrder) {
                $categories = Category::where('id','!=', $cat->id)->where('ordered_by', '>=', $catOrder)->where('ordered_by', '<=', $currentOrder)->get();
            } else if ($currentOrder == $catOrder) {
                $categories = Category::where('id','!=', $cat->id)->where('ordered_by', '>=', $catOrder)->get();
            }
        }
        if (\request()->hasFile("image") && \request()->file("image")->isValid()) {
            $url = ImageHelper::uploadImage(request()->file('image'), auth()->user(), 'category_icon');
            $cat->icon = $url;
        }

//        dd($categories);
        if ($categories != null && count($categories) > 0) {

            if (isset($currentOrder) && $currentOrder < $catOrder) {
                $tmp = $categories[count($categories)-1]->ordered_by - 1;
                foreach ($categories as $cc) {
                    $cc->ordered_by = $tmp;
                    $cc->save();
                    $tmp--;
                }
            } else {
                $tmp = $categories[0]->ordered_by + 1;
                foreach ($categories as $cc) {
                    $cc->ordered_by = $tmp;
                    $cc->save();
                    $tmp++;
                }
            }
        }

        $cat -> title       = $catName;
        $cat -> ordered_by  = $catOrder;
        $cat -> status      = 1;
        $cat -> save();

//        $categories = Category::whereStatus(1)->get();

        return $this->returnData(true, 'Action performed successfully.', $cat);
    }
    public function deleteCategory($id) {

        $category = Category::with('subCategories')->find($id);
        $msg = '';
        if ($category == null) {
            return $this->returnData(false, 'Category not found.', null);
        }

        if ($category -> status == 1) {
            $category -> status = 0;
            foreach($category->subCategories as $sub_cat) {
                $sub_cat -> status = 0;
                $sub_cat -> save();
            }
            $category -> save();
            $msg = 'Category deactivated successfully.';
        } else if ($category -> status == 0) {
            foreach($category->subCategories as $sub_cat) {
                $sub_cat -> delete();
                $products = Products::where('sub_category_id', $sub_cat -> id)->update(array('sub_category_id' => 0));
            }
            $category -> delete();
            $category = null;
            $msg = 'Category, with all its subcategories, deleted successfully.';
        }

        return $this->returnData(true, $msg, $category);
    }
    public function activateCategory($id) {
        $category = Category::with('subCategories')->find($id);
        $msg = '';
        if ($category == null) {
            return $this->returnData(false, 'Category not found.', null);
        }

        $category -> status = 1;
        foreach($category->subCategories as $sub_cat) {
            $sub_cat -> status = 1;
            $sub_cat -> save();
        }

        $category -> save();

        return $this->returnData(true, 'Category activated.', $category);
    }
    public function addSubCategory($id, $sub_id = 0) {

        $data = request()->all();
        if ($sub_id == 0) {
            $cat = Category::with('subCategories')->find($id);
            foreach($cat->subCategories as $s) {
                if ($s -> title == $data['sub_category'])
                    return  $this->returnData(false, 'You already have created a sub category with that name.', null);
            }
            $sub_cat = new SubCategory();
        } else {
            $sub_cat = SubCategory::find($sub_id);
            if ($sub_cat == null) {
                return $this->returnData(false, 'Subcategory could not be edited.', null, 500);
            }
        }
        $validate = Validator::make($data, [
            'sub_category' => [ 'required', 'string'],
        ]);
        if ($validate->errors()->messages() != null) {
            return $this->returnData(false, $validate->errors()->first(), '');
        }
        $title = request('sub_category');

        $sub_cat -> cat_id  = $id;
        $sub_cat -> title   = $title;
        $sub_cat -> status   = 1;
        $sub_cat -> save();

        return $this->returnData(true, 'Action performed successfully.', $sub_cat);

    }
    public function deleteSubCategory($id) {
        $s_cat = SubCategory::find($id);
        $msg = '';
        if ($s_cat == null) {
            return $this->returnData(false, 'Subcategory not found.', null);

        }
        if ($s_cat -> status == 1) {
            $s_cat -> status = 0;
            $s_cat -> save();
            $msg = 'Sub category deactivated.';
        } else if ($s_cat -> status == 0) {
            $s_cat -> delete();
            $products = Products::where('sub_category_id', $s_cat -> id)->update(array('sub_category_id' => 0));
            $msg = 'Sub category deleted.';
            $s_cat = null;
        }
        return $this->returnData(true, $msg, $s_cat);
    }
    public function activateSubCategory($id) {
        $s_cat = SubCategory::find($id);
        if ($s_cat == null) {
            return $this->returnData(false, 'Subcategory not found.', null);

        }
        $s_cat -> status = 1;
        $s_cat -> save();

        return $this->returnData(true, 'Subcategory activated.', $s_cat);
    }
    public function addCoupon($id = 0){

        $data = request()->all();
        $imageValid = '';
        $uniqueTitle = '';
        if ($id == 0) {
            $uniqueTitle = 'unique:coupons,code';
        }
        if (\request()->hasFile("image") && \request()->file("image")->isValid())
            $imageValid = 'required|image|mimes:jpeg,png,jpg,svg';
        $validate = Validator::make($data, [
            'coupon' => ['required', 'string', $uniqueTitle],
            'coupon_type' => ['required', 'string', 'regex:/^[-, %]$/'],
            'price' => ['required', 'numeric'],
            'start_date' => ['required', 'string'],
            'end_date' => ['required', 'string'],
            'no_of_coupons' => ['required', 'numeric'],
            'image' =>$imageValid,
        ]);
        if ($validate->errors()->messages() != null) {
            return $this->returnData(false, $validate->errors()->first(), '');
        }
        $coupon = request('coupon');
        $type = request('coupon_type');

        if ($id == 0) {
            $c = new Coupons();
        } else {
            $c = Coupons::find($id);
            if ($c == null) {
                return $this->returnData(false, 'Coupon could not be edited.', null, 500);
            }
        }
        if (\request()->hasFile("image") && \request()->file("image")->isValid()) {
            $url = ImageHelper::uploadImage(request()->file('image'), auth()->user(), 'coupon_image');
            $c->image = $url;
        }

        $c -> code          = $coupon;
        $c -> start_date    = date("Y-m-d",strtotime(\request('start_date')));
        $c -> end_date      = date("Y-m-d",strtotime(\request('end_date')));
        $c -> type          = $type;
        $c -> price         = request('price');
        $c -> c_limit         = request('no_of_coupons');
        $c -> status        = 1;
        $c -> save();

//        $categories = Category::whereStatus(1)->get();

        return $this->returnData(true, 'Action performed successfully.', $c);
    }
    public function deleteCoupon($id = 0) {
        $coupon = Coupons::find($id);
        $msg = '';
        if ($coupon == null) {
            return $this->returnData(false, 'Category not found.', null);
        }

        if ($coupon -> status == 1) {
            $coupon -> status = 0;
            $coupon ->save();
            $msg = 'Coupon deactivated successfully.';
        } else if ($coupon -> status == 0) {
            $coupon -> delete();
            $coupon = null;
            $msg = 'Category, with all its subcategories, deleted successfully.';
        }

        return $this->returnData(true, $msg, $coupon);
    }
    public function activateCoupon($id) {
        $coupon = Coupons::find($id);
        $msg = '';
        if ($coupon == null) {
            return $this->returnData(false, 'Category not found.', null);
        }

        $coupon -> status = 1;

        $coupon -> save();

        return $this->returnData(true, 'Coupon activated.', $coupon);
    }
    public function getClients() {
        $pag = 30;
        $query   = User::query();
        $query->where('status', '!=', 2);
        if(\request('search') != null){
            $query->where('name','like',"%".request('search')."%")->orWhere('id','like',"%".request('search')."%")->orWhere('email','like',"%".request('search')."%");
        }
        if (\request('number')) {
            $pag = request('number');
        }
        $clients = $query->paginate($pag);
        return $this->returnData(true, 'clients', $clients);
    }
    public function getClientsCustom() {
        $pag = 30;
        $query   = CustomClients::query();
        if(\request('search') != null){
            $query->where('name','like',"%".request('search')."%")->orWhere('id','like',"%".request('search')."%")->orWhere('email','like',"%".request('search')."%");
        }
        if (\request('number')) {
            $pag = request('number');
        }
        $clients = $query->paginate($pag);
        return $this->returnData(true, 'clients', $clients);
    }
    public function manageClients() {
        $count = User::where('status', '!=', 2)->count();
        $count_un = CustomClients::count();
        return view('admin.Manage.clients-list', compact('count', 'count_un'));
    }
    public function addSection() {
//        dd(\request()->all());
        try {
            DB::beginTransaction();
            $type = request('type');
            $newSec = json_decode(request('sec'));
//            dd($newSec);
//        dd($type);
            $sections = Section::where("type", $type)->whereIn("status", [0, 1, 9])->get();
            if ($sections != null) {
                foreach ($sections as $sec) {
                    $deleted = false;
                    if ($sec->status == 0)
                        $sec->status = 9;
                    elseif ($sec->status == 1)
                        $sec->status = 0;
                    elseif ($sec->status == 9) {
                        $deleted = true;
                        $sec->delete();
                    }
                    if (!$deleted)
                        $sec->save();
                }
            }
            $files = request('files');
            foreach ($newSec as $key => $sec ) {
                $s = new Section();
                if ($sec->title != '') {
                    $s->title = $sec->title;
                } else {
                    $this->repError();
                }
                if ($sec->about_desc != '') {
                    $s->about_desc = $sec->about_desc;
                } else {
                    $this->repError();
                }
                $s->type = $type;
                if ($sec->styling != 'No Image') {
                    if(!is_string($files[$key]) && $files[$key]->isValid()){
                        $url = ImageHelper::uploadImage($files[$key], auth()->user(), $type);
                        $s->image = $url;
                    }else{
                        $s->image = $sec->image;
                    }
                } else {
                    $s->image = '';
                }
                $s->styling = $sec->styling;
                $s->status = 1;
                $s->save();
            }
            DB::commit();
            return $this->returnData(true,"Sections added successfully.", null);
        } catch (\Exception $e){
            DB::rollBack();
            return $this->returnData(false,"Server error, Please contact Administrator",null,$e->getMessage(),500);
        }
    }
    public function repError() {
        DB::rollBack();
        return $this->returnData(false,"Please make sure to fill the form first.", null);
    }
    public function addShippingRange() {
        $sp = ShippingPrice::all();
        if ($sp != null) {
            foreach ($sp as $s) {
                $s->delete();
            }
        }
        $ranges = \request('ranges');
//        dd($ranges);
        foreach ($ranges as $r) {
            $shipping_price = new ShippingPrice();
            $f = $r['from']; $t = $r['to'];
            if ($f < 0 || $t < 0)
                return $this->returnData(false, 'Ranges cant be negative.', null);
            $shipping_price->price = $r['price'];
            $shipping_price->from = $f;
            $shipping_price->to = $t;
            $shipping_price->save();
        }
        $p = ShippingPrice::all();
       return $this->returnData(true, 'Shipping prices.', $p);
    }
    public function exampleExcel() {
//        return Excel::download( new ExportExample, 'Example Custom.xlsx');

        $fileName = 'custom-clients.csv';

        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array("State","Postal / Zip Code", "Street Address", "City", "Street Address 2", "Pseudo Facebook", "Name", "Surname", "Email", "Phone Number", "Post Office / Place of delivery", "Secondary place of delivery", "Choice of Payment", "Name of Payer");

        $callback = function() use($columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

//            foreach ($tasks as $task) {
//                $row['Title']  = $task->title;
//                $row['Assign']    = $task->assign->name;
//                $row['Description']    = $task->description;
//                $row['Start Date']  = $task->start_at;
//                $row['Due Date']  = $task->end_at;
//
//                fputcsv($file, array($row['Title'], $row['Assign'], $row['Description'], $row['Start Date'], $row['Due Date']));
//            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }

    public function export()
    {
        return Excel::download(new ClientsExport, 'clients.xlsx');
    }
    public function import()
    {
        $data = Excel::toArray(new ClientsImport(), request()->file('file'));
        foreach($data[0] as $key => $row) {
            if ($key != 0) {
                $ch = CustomClients::where('name', $row[6].' '.$row[7])->first();
                if ($ch == null) {
                    $arr[] = [
                        'state' => $row[0],
                        'postal' => $row[1],
                        'address' => $row[2],
                        'city' => $row[3],
                        'address_2' => $row[4],
                        'fb_pseudo' => $row[5],
                        'name' => $row[6].' '.$row[7],
                        'email' => $row[8],
                        'telephone' => $row[9],
                        'post' => $row[10],
                        'post_2' => $row[11],
                        'payment_method' => $row[12],
                        'payer_name' => $row[13],
                    ];
                }
            }
        }
        // dd($products);

        if(!empty($arr)){
            DB::table('custom_clients')->insert($arr);
        }

        return back();
    }
}


