<?php

namespace App\Http\Controllers\Admin;

use App\Banners;
use App\Http\Controllers\Controller;
use App\PageConfig;
use App\Products;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use RealRashid\SweetAlert\Facades\Alert;

class DashboardController extends Controller
{
    // Available Currencies
    var $currencies = ['MKD', '$', '€', 'LEK'];

    public function index() {
        return view('admin.index')->with('curr', $this->currencies);
    }
    public function getConfig() {
        return  PageConfig::where('admin_id', 1)->where('status', 1)->first();
    }
    public function addProd($id = 0) {
        if($id != 0){
            $product = Products::find($id);
            if($product == null)
                return redirect("/admin/addProd");
        }
        return view('admin.Products.add_products',compact('id'));

    }
    public function manageProducts() {
        return view('admin.Products.manage_products');
    }
    public function manageCategories() {
        return view('admin.Manage.categories');
    }
    public function manageCollections() {
//        $banners = Banners::where("type","collection")->whereStatus(1)->get();
        return view('admin.Manage.collections');
    }
    public function manageBanners() {
//        $banners = Banners::where("type","banner")->whereStatus(1)->get();
//        dd($banners);
        return view('admin.Manage.banners');
    }
    public function manageCoupons() {
        return view('admin.Manage.coupons');
    }
    public function productBanners() {
        return view('admin.Products.horizontal');
    }
}
