<?php

namespace App\Http\Controllers\Admin;

//use App\Config;
use App\ConvertCurrencies;
use App\Http\Controllers\Controller;
use App\Library\ImageHelper;
use App\PageConfig;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\Facades\Image;
use RealRashid\SweetAlert\Facades\Alert;

class ConfigController extends DashboardController
{
    public function __construct()
    {
        $this->middleware(['auth', 'isAdmin']);
    }
    public function logoUpload( Request $request) {
        $conf = $this->getConfig();
        if ($request->hasFile('image')) {
            //  Let's do everything here
            if ($request->file('image')->isValid()) {
                //
                $validated = $request->validate([
                    'image' => 'mimes:jpeg,png',
                ]);
                $url = ImageHelper::uploadImage($request->file('image'), auth()->user(), 'logo', 80);

                $conf -> logo = $url;
                $conf -> save();

                Alert::image('Logo Updated!','Success!',$url,'200','200');
                return \Redirect::back();
            }
        }
//        Session::flash('imgError', "Please select a picture first!");
        Alert::warning('Error!', 'Please select a logo first.');

        return \Redirect::back();

    }
    public function updatePageName() {
        $conf = $this->getConfig();
        $name = request('shop_name');
        if ($name != '' && $name != null) {
            $conf -> company_name = $name;
            $conf -> save();
            Alert::success('Shop Updated!', 'You have successfully changed the name of your shop.');
            return \Redirect::back();
        }
        Alert::warning('Error!', 'Input a valid shop name.');

        return \Redirect::back();
    }
    public function updateShopData() {
        $data = \request()->all();
        $validate = Validator::make($data, [
//            'about_shop'            => ['string', 'nullable'],
//            'privacy_policy'        => ['string', 'nullable'],
//            'terms_and_conditions'  => ['string', 'nullable'],
            'address'               => ['string', 'max:255', 'nullable'],
            'email'                 => ['string', 'email', 'max:255', 'nullable'],
            'facebook'              => ['string', 'max:255', 'nullable'],
            'insta'                 => ['string', 'max:255', 'nullable'],
            'twitter'               => ['string', 'max:255', 'nullable'],
            'tel'                   => ['numeric', 'min:9', 'nullable'],
            'hotline_numbers'       => ['regex:/^[0-9]+(,[0-9]+)*$/', 'nullable'],
            'shipping_fee'          => ['numeric', 'nullable'],
            'min_free'              => ['numeric', 'nullable'],
            'p_fee'                 => ['numeric', 'nullable'],
            'currency'              => ['required', 'string'],
            'shipping'              => ['required'],
        ]);
        if($validate->errors()->messages() != null){
            Alert::warning('Incorect data!', $validate->errors()->first());
            return \Redirect::back();
        }
        $conf = $this->getConfig();
//        dd($data['shipping']);
        isset($data['hotline']) ? $conf -> hotline_support = 1 : $conf -> hotline_support = 0;

        $conf->shipping_type = $data['shipping'];

        if(isset($data['hotline']) && !isset($data['hotline_numbers'])) {
            Alert::warning('Incorect data!', 'You must provide hotline numbers if you want to make hotline available.');
            return \Redirect::back();
        } else {
            $conf -> hotline_num = $data['hotline_numbers'];
        }
        $conf -> about_desc         = null;
        $conf -> privacy_policy     = null;
        $conf -> terms_condition    = null;
        $conf -> address            = $data['address'];
        $conf -> main_email         = $data['email'];
        $conf -> tel                = $data['tel'];
        $conf -> shipping_fee       = $data['shipping_fee'];
        $conf -> min_o_free         = $data['min_free'];
        $conf -> processing_fee     = $data['p_fee'];
        $conf -> currency           = $data['currency'];
        $c = ConvertCurrencies::where('status', 1)->first();
        if ($conf -> currency == 'MKD') {
            $c->mkd = 1;
        } else if ($conf -> currency == 'LEK') {
            $c->lek = 1;
        } else if ($conf -> currency == '€') {
            $c->eur = 1;
        } else if ($conf -> currency == '$') {
            $c->eur = 1;
        }
        $c->save();
        $conf -> facebook           = $data['facebook'];
        $conf -> instagram          = $data['insta'];
        $conf -> twitter            = $data['twitter'];

        isset($data['pay_cash']) ? $conf -> cash_payment = 1 : $conf -> cash_payment = 0;

        $conf -> save();

        Alert::success('Successfully changed data');
        return \Redirect::back();

    }
    public function themeChange() {
        $theme = \request('theme');
        $conf = $this->getConfig();
        $conf->admin_theme = $theme;
        $conf->save();
        return $this->returnData(true, 'success', null);
    }
}
