<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <base href="/">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e($conf->company_name); ?></title>

    <!-- Scripts -->

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">
    <link rel="shortcut icon" href="<?php echo e($conf->logo); ?>" type="image/png">


    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/bootstrap/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/font-awesome/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/dropify/css/dropify.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/chartist/css/chartist.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/chartist-plugin-tooltip/chartist-plugin-tooltip.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/toastr/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/bootstrap-tagsinput/bootstrap-tagsinput.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/select2/select2.css')); ?>">
    <?php echo $__env->yieldContent('otherStyles'); ?>


    <!-- Styles -->

    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/css/color_skins.css')); ?>">

    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/vue"></script>
    <script src="https://rawgithub.com/timrwood/moment/2.9.0/min/moment.min.js"></script>
    <link rel="stylesheet" href="https://unpkg.com/element-ui/lib/theme-chalk/index.css">
</head>
<body class="theme-orange">
<div class="page-loader-wrapper">
    <div class="loader">
        <div class="m-t-30"><img src="<?php echo e($conf->logo); ?>" width="48" height="48" alt=""></div>
        <p>Please wait...</p>
    </div>
</div>
    <div id="wrapper">
        
        
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <!-- Javascript -->
    <script src=" <?php echo e(asset('assets/admin_styles/bundles/libscripts.bundle.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/bundles/vendorscripts.bundle.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/vendor/toastr/toastr.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/vendor/dropify/js/dropify.min.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/bundles/chartist.bundle.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/bundles/knob.bundle.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/bundles/mainscripts.bundle.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/js/index.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/js/pages/forms/dropify.js')); ?>"></script>

    <script src=" <?php echo e(asset('assets/admin_styles/js/widgets/infobox/infobox-1.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/vendor/bootstrap-tagsinput/bootstrap-tagsinput.js')); ?>"></script>
    <script src=" <?php echo e(asset('assets/admin_styles/vendor/select2/select2.min.js')); ?>"></script>

    <!-- import JavaScript -->
    <script src="https://unpkg.com/element-ui/lib/index.js"></script>


<?php echo $__env->yieldContent('footer'); ?>
    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>

<?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\manshop\resources\views/layouts/admin.blade.php ENDPATH**/ ?>