<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <base href="/">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e($conf->company_name); ?></title>

    <!-- Scripts -->

<!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">
    <link rel="shortcut icon" href="<?php echo e($conf->logo); ?>" type="image/png">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css" integrity="sha384-TX8t27EcRE3e/ihU7zmQxVncDAy5uIKz4rEkgIXeMed4M0jlfIDPvg6uqKI2xXr2" crossorigin="anonymous">
    <!-- VENDOR CSS -->

    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/vendor/font-awesome/css/font-awesome.min.css')); ?>">







    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/css/color_skins.css')); ?>">
<?php echo $__env->yieldContent('otherStyles'); ?>


<!-- Styles -->
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin_styles/css/color_skins.css')); ?>">

    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.12"></script>
    <script src="https://rawgithub.com/timrwood/moment/2.9.0/min/moment.min.js"></script>
    <link rel="stylesheet" href="https://unpkg.com/element-ui/lib/theme-chalk/index.css">
</head>
<body class="bg-light" style="padding: 0 4%">






<div style="width: 100%; text-align: center; margin-top: 10%">
    <img src="<?php echo e(asset('/logo-modapascher.png')); ?>" alt="" style="width: 100% !important;">

</div>

<div id="vue-content">
    <div style="width: 100vw; height: 100vh; position: absolute; z-index: 999999999; backdrop-filter: blur(5px); top: 0; left: 0;" v-if="loading">
        <div class="d-flex justify-content-center" style="margin-top: 50%;">
            <div class="spinner-border" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
    </div>
    <div class="container mx-auto" style="margin-top: 10% !important">
        <div class="card-body text-center">
            <div class="row">
                <div class="col-12">
                    <p v-html="ordered.desc" style="font-size: 1.3rem;"></p>
                </div>
            </div>
            <div class="row" style="font-size: 1.2rem;">
                <div class="col-6">Subtotal</div>
                <div class="col-6">{{ ordered.subtotal }} €</div>
            </div>
            <div class="row" style="font-size: 1.2rem;" v-if="ordered.discount > 0">
                <div class="col-6">Discount</div>
                <div class="col-6">{{ ordered.discount }}</div>

            </div>
            <div class="row" style="font-size: 1.2rem;">
                <div class="col-6">Shipping</div>
                <div class="col-6">{{ ordered.shipping }} €</div>
            </div>
            <div class="row" style="font-size: 1.2rem;font-weight: 500;">
                <div class="col-6">Total</div>
                <div class="col-6">{{ ordered.price }} €</div>
            </div>


        </div>
    </div>

</div>
<div class="mx-auto">
    <div id="paypal-button-container" ></div>

</div>



<script src="https://www.paypal.com/sdk/js?client-id=AdPFTmn-On7SAQkJD9RSbEQd2rf3OnimKIsYdJCbVBr6wVxytLWIaymutTNuaxZIQyXNGw8ji7e7qQW0&currency=EUR&commit=true&intent=capture"></script>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>
<script>
    const Vue_comp = new Vue({
        el:"#vue-content",
        data: {
            ordered: null, type: null, user_id: 0, products: null, loading: false
        },
        created() {
            this.ordered = JSON.parse(<?php echo json_encode($prod_ret); ?>);
            this.products = JSON.parse(<?php echo json_encode($products); ?>);
            this.type = '<?php echo $type; ?>';
            this.id = '<?php echo $id; ?>';
            console.log(this.ordered, this.products);
            self = this;
            window['paypal'].Buttons({
                style: {
                shape: 'pill',
                color: 'gold',
                layout: 'horizontal',
                label: 'paypal',

            },

                createOrder: function(data, actions) {
                return actions.order.create({
                    purchase_units: [{"amount":{"currency_code":"EUR","value": self.ordered.price}}],
                    application_context: {"shipping_preference": "NO_SHIPPING"}
                    });
                },
                onApprove: function(data, actions) {
                    self.loading = true;
                return actions.order.capture().then(function(details) {
                    console.log('paypal', details);
                    if (details.status === 'COMPLETED') {
                        axios.post('/api/V1/paypalSuccess', {products: JSON.stringify(self.products), type: self.type, id: self.id, paypal: JSON.stringify(details)}).then((res)=> {
                            if (res.data.status) {
                                console.log('success', res);
                                axios.post('/api/V1/paypalAllSuccess', {type: self.type, id: self.id}).then(res1 => {
                                    self.loading = false;
                                    console.log('allsuccess', res1);
                                    if (res1.data.status) {
                                        window.close();
                                    }
                                })
                            }
                        }).catch(err=> {
                            alert('Something went wrong please contact admin.');
                            self.loading = false;
                        })
                    } else {
                        self.lodaing = false;
                        alert('Paypal payment has not been completed.');
                    }

                    });
                },

                onError: function(err) {
                console.log(err);
            }
            }).render('#paypal-button-container');
        },
        methods: {
        }
    });
</script>
<?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH C:\htdocs\mangopaid-modapascher\resources\views/processing/processpp.blade.php ENDPATH**/ ?>