<?php $__env->startSection('content'); ?>
    <div id="main-content">

        <div class="row mt-5" id="manage-orders" v-if="apiData">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="header">
                        <h2>Registered Clients</h2>

                        <div class="ml-auto">
                            <div class="user-account">
                                <div class="dropdown" style="float: right">
                                    <a href="javascript:void(0);" class="dropdown-toggle user-name" data-toggle="dropdown">Clients per page: {{ paginate }}</a>
                                    <ul class="dropdown-menu dropdown-menu-right account animated flipInY">
                                        <li><a href="javascript:void(0);" v-on:click="changePag(15)">15</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(30)">30</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(45)">45</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(60)">60</a></li>
                                    </ul>
                                </div>
                            </div>
                            <button class="btn btn-dark" :disabled="apiData.prev_page_url === null" v-on:click="prevPage()">
                                Previous Page
                            </button>
                            <button class="btn btn-dark" :disabled="apiData.next_page_url === null" v-on:click="nextPage()">
                                Next Page
                            </button>
                            <input type="text" placeholder="Search User, email, id..." class="form-control" v-model="search" v-on:keyUp="getClients()" style="width: auto !important; display: initial !important;">

                        </div>
                    </div>
                    <div class="body">
                        <div class="table-responsive" v-if="clients.length > 0">
                            <table class="table table-hover m-b-0 text-center">
                                <thead class="thead-dark">
                                <tr>
                                    <th>Id</th>
                                    <th>User</th>
                                    <th>Address</th>
                                    <th>City</th>
                                    <th>Zip</th>
                                    <th>Email</th>
                                    <th>Telephone</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(client, i) in clients">
                                    <td>{{ client.id }}</td>
                                    <td><span>{{ client.name }}</span></td>
                                    <td><span>{{ client.address }}</span></td>
                                    <td><span>{{ client.city }}</span></td>
                                    <td><span>{{ client.zip }}</span></td>
                                    <td><span>{{ client.email }}</span></td>
                                    <td><span>{{ client.tel }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div v-else>
                            <h1 class="text-center" style="font-style: italic;">No clients available.</h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Products Modal -->





































    </div>



<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <script>
        const Vue_comp = new Vue({
            el:"#main-content",
            data: {
                clients: [],
                apiData: null,
                changePage: false,
                link: 'admin/getClients',
                paginate: 30,
                modProducts: [],
                search: '',
                orderLoading: 0
            },
            created() {
                this.getClients();
            },
            methods: {
                capitalizeFirstLetter(string) {
                    return string.charAt(0).toUpperCase() + string.slice(1);
                },
                dateStr(d) {
                    // return new Date(d).toDateString();
                    return moment(d).format('DD MMM, YYYY');
                },
                getClients() {
                    const self = this;
                    axios.post(this.link, {number: this.paginate, search: this.search}, {
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            },
                        }
                    ).then(function(response){
                        console.log('Clients', response)
                        if (response.data.status) {
                            self.apiData = response.data.values;
                            self.clients = self.apiData.data;
                        }
                        this.changePage = false;
                    }).catch(function(error){
                        this.changePage = false;
                    });
                },
                prevPage() {
                    if (this.apiData && this.apiData.prev_page_url) {
                        // this.changePage = true;
                        this.link = this.apiData.prev_page_url;
                        this.getClients();
                    }
                },
                nextPage() {
                    if (this.apiData && this.apiData.next_page_url) {
                        // this.changePage = true;
                        this.link = this.apiData.next_page_url;
                        this.getClients();
                    }
                },
                changePag(val) {
                    this.paginate = val;
                    this.getClients();
                },
                modalProds(order) {
                    this.modProducts = order.items;
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\manshop-SKS\resources\views/admin/Manage/clients-list.blade.php ENDPATH**/ ?>