<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//Route::middleware('auth:api')->get('/user', function (Request $request) {
//    return $request->user();
//});
//Route::post('deleteDuplicates', 'ProductsController@deleteDuplicates');

Route::group(['prefix' => 'V1'], function() {
    Route::group(['prefix' => 'auth'], function() {
        Route::post('login', 'ApiV1\AuthController@login');
        Route::post('logout', 'ApiV1\AuthController@logout');
        Route::post('signUp', 'ApiV1\AuthController@signup');
    });

    Route::post('getUser', 'ApiV1\UserController@getUser');
    Route::post('updateUser', 'ApiV1\UserController@updateUser');
    Route::post('changePsw', 'ApiV1\UserController@changePsw');


    Route::post('getBanners', 'ApiV1\HomeController@getBanners');
    Route::post('getCollections', 'ApiV1\HomeController@getCollections');
    Route::post('getAllCollections', 'ApiV1\HomeController@getAllCollections');
    Route::post('horizontalProducts', 'ApiV1\HomeController@productBanners');
    Route::post('getCategories', 'ApiV1\HomeController@getCategories');
    Route::post('getSingleCategory', 'ApiV1\HomeController@getSingleCategory');
    Route::post('getSubCategory', 'ApiV1\HomeController@getSubCategory');
    Route::post('getSubProducts', 'ApiV1\HomeController@getSubProducts');
    Route::post('relatedProds', 'ApiV1\HomeController@relatedProds');
    Route::post('getAllCategories', 'ApiV1\HomeController@getAllCategories');
    Route::post('getShopConfig', 'ApiV1\HomeController@getShopConfig');
    Route::post('getAllCoupons', 'ApiV1\HomeController@getAllCoupons');
    Route::post('getCoupons', 'ApiV1\HomeController@getCoupons');

    Route::post('getSections', 'ApiV1\HomeController@getSections');
    Route::post('getAbout', 'ApiV1\HomeController@getAbout');
    Route::post('getTerms', 'ApiV1\HomeController@getTerms');
    Route::post('getPrivacy', 'ApiV1\HomeController@getPrivacy');

    Route::post('getShippingPrices', 'ApiV1\HomeController@getShippingPrices');

    Route::post('getTopProducts', 'ApiV1\HomeController@getTopProducts');
    Route::post('getProducts', 'ProductsController@getProducts');
//    Route::post('filterProducts', 'ProductsController@filterProducts');
    Route::post('getAllProducts', 'ProductsController@getAllProducts');
    Route::post('getSingleProduct', 'ProductsController@getSingleProduct');
    Route::post('getSingleProductAdmin', 'ProductsController@getSingleProductAdmin');

    Route::post('preparePayment', 'ApiV1\OrderController@preparePayment');

    Route::post('placeOrder', 'ApiV1\OrderController@placeOrder');
    Route::post('getOrders', 'ApiV1\OrderController@getOrders');
    Route::post('getOrdersPag', 'ApiV1\OrderController@getOrdersPag');
    Route::post('downloadInvoice', 'ApiV1\OrderController@downloadInvoice');

    Route::post('setDeviceId', 'ApiV1\UserController@setDeviceId');

    Route::post('getCurrencies', 'ApiV1\HomeController@getCurrencies');
    Route::post('calculateCurrencies', 'ApiV1\HomeController@calculateCurrencies');

    Route::post('preparePaypal', 'ApiV1\OrderController@preparePaypal');
    Route::post('paypalSuccess', 'ApiV1\OrderController@paypalSuccess');
    Route::post('checkPpSuccess', 'ApiV1\OrderController@checkPpSuccess');
    Route::post('paypalAllSuccess', 'ApiV1\OrderController@paypalAllSuccess');

});
