<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <base href="/">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>{{ $conf->company_name }}</title>


        @if(isset($product) && $product!=null)
            <meta property="og:title" content="{{$product->title}}"/>
            <meta property="og:description" content="{{$product->description}}"/>
            <meta property="og:type" content="website"/>
            <meta property="og:url" content="{{url("/detailed/".$product->id)}}"/>
            <meta property="og:image" content="{{$product->image}}"/>
        @else
            <meta property="og:title" content="Manshop"/>
            <meta property="og:description" content="Website description"/>
            <meta property="og:type" content="website"/>
            <meta property="og:url" content={{url("/")}}/>
            <meta property="og:image" content="http://shop.mangosoft.mk/storage/images/1/logo/logo.jpg"/>
        @endif

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">
        <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" media="screen" />
        <!-- Styles -->
{{--        <link rel="stylesheet" href="/assets/css/style.css">--}}
        <style>
            html, body {
                background-color: #fff;
                color: #636b6f;
                font-family: 'Nunito', sans-serif;
                font-weight: 200;
                height: 100vh;
                margin: 0;
            }

            .full-height {
                height: 100vh;
            }

            .flex-center {
                align-items: center;
                display: flex;
                justify-content: center;
            }

            .position-ref {
                position: relative;
            }

            .top-right {
                position: absolute;
                right: 10px;
                top: 18px;
            }

            .content {
                text-align: center;
            }

            .title {
                font-size: 0;
            }

            .links > a {
                color: #636b6f;
                padding: 0 25px;
                font-size: 13px;
                font-weight: 600;
                letter-spacing: .1rem;
                text-decoration: none;
                text-transform: uppercase;
            }

            .m-b-md {
                margin-bottom: 30px;
            }
        </style>
        <!--====== Favicon Icon ======-->
        <link rel="shortcut icon" href="{{$conf->logo}}" type="image/png">

        <!--====== Animate CSS ======-->
        <link rel="stylesheet" href="assets/css/animate.css">

        <!--====== Magnific Popup CSS ======-->
        <link rel="stylesheet" href="assets/css/magnific-popup.css">

        <!--====== Slick CSS ======-->
        <link rel="stylesheet" href="assets/css/slick.css">

        <!--====== Font Awesome CSS ======-->
        <link rel="stylesheet" href="assets/css/fontawesome.min.css">

        <!--====== Brusher Font CSS ======-->
        <link rel="stylesheet" href="assets/css/brusher-fornt.css">

        <!--====== Flat Icon CSS ======-->
        <link rel="stylesheet" href="assets/css/flaticon.css">

        <!--====== Ico Font Icon CSS ======-->
        <link rel="stylesheet" href="assets/css/icofont.min.css">

        <!--====== Jquery Ui CSS ======-->
        <link rel="stylesheet" href="assets/css/jquery-ui.min.css">

        <!--====== Bootstrap CSS ======-->
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">

        <!--====== Default CSS ======-->
        <link rel="stylesheet" href="assets/css/default.css">

        <!--====== Style CSS ======-->
        <link rel="stylesheet" href="assets/css/style.css">

    </head>
    <body style="background: transparent">
        <div class="position-ref full-height">
                @auth
                    <div id="myExp">
                        <MainApp id="authenticatedToken" data="{{ auth()->user()->token }}" logged="true" url="{{url('/')}}" conf="{{$conf}}"/>
                    </div>
                @else
                    <div id="myExp">
                        <MainApp id="authenticatedToken" data="" logged="false" url="{{url('/')}}" conf="{{$conf}}"/>
                    </div>

                @endauth
        </div>

        <link href="/css/app.css" rel="stylesheet">
        {{--for prod--}}
        {{--<script src="https://www.paypal.com/sdk/js?client-id=AUA5MOxQC-8N2Q-LnPNnLSwW_8ONWS8xNdvdFuv3SmogJDgbv6hmGdzMeRsZxh4fCnkdQf_fm3VNRCY1&currency=EUR&commit=true&intent=capture"></script>--}}
        {{--for test--}}
        <script src="https://www.paypal.com/sdk/js?client-id=AdPFTmn-On7SAQkJD9RSbEQd2rf3OnimKIsYdJCbVBr6wVxytLWIaymutTNuaxZIQyXNGw8ji7e7qQW0&currency=EUR&commit=true&intent=capture"></script>

        <script src="{{ asset('/js/app.js') }}"></script>
        <script src="//code.tidio.co/rq6ghxw1afvohx6lsmez9wo021khbjwm.js" async></script>

        {{--        <script src="sweetalert2.all.min.js"></script>--}}
        <!-- Optional: include a polyfill for ES6 Promises for IE11 -->
{{--        <script src="https://cdn.jsdelivr.net/npm/promise-polyfill"></script>--}}

{{--        @include('sweetalert::alert')--}}
{{--        <link rel="stylesheet" href="sweetalert2.min.css">--}}
{{--        <script>--}}
{{--            @if(session()->has("error"))--}}
{{--                alert('{{session("error")}}')--}}
{{--            @endif--}}
{{--        </script>--}}
    </body>
</html>
