<!DOCTYPE html>
<html>
<head>
    <title>Client Form</title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700" rel="stylesheet">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.5.0/css/all.css" integrity="sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU" crossorigin="anonymous">
{{--    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css" integrity="sha384-HSMxcRTRxnN+Bdg0JdbxYKrThecOKuH5zCYotlSAcp1+c8xmyTe9GYg1l9a69psu" crossorigin="anonymous">--}}
{{--    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap-theme.min.css" integrity="sha384-6pzBo3FDv/PJ8r2KRkGHifhEocL+1X2rVCTTkUfGk7/0pbek5mMa1upzvWbrUbOZ" crossorigin="anonymous">--}}
    <!-- CSS only -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-giJF6kkoqNQ00vy+HMDP7azOuL0xtbfIcaT9wjKHr8RbDVddVHyTfAAsrekwKmP1" crossorigin="anonymous">

    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
</head>
<body>
<div id="loading-screen" style="position: absolute; width: 100vw; height: 100vh; z-index: 9999999; backdrop-filter: blur(5px); display: none">
    <div style="margin: 20% 50%;">
        <div class="spinner-grow" style="width: 3rem; height: 3rem;" role="status">
        </div>
    </div>
</div>
<div class="container text-center">
    <img src="{!! $conf->logo !!}" style="width:100px;"/>
    <div class="alert alert-warning">
        <h5 class="text-start">{{$liveOrder->fullname}}<br /><small>{{$liveOrder->nickname}}</small></h5>
        <p class="text-start">
            {{$liveOrder->address}},
            {{$liveOrder->zip}}
            {{$liveOrder->city}}<br />
            {{$liveOrder->country}}<br /><br />
            {{$liveOrder->email}}<br />
            {{$liveOrder->phone}}<br />
        </p>
        <p>Products:<br />{!! $liveOrder->products !!}</p>
        <h3>Total: {{$liveOrder->total}} &euro;</h3>
        <hr />
        <h3>Card</h3>
        <div class="row">
            <div class="col-md-6 offset-md-3">
                <div class="row">
                    <form action="/live-order/payment/{{$liveOrder->id}}" method="POST" >
                        @csrf
                        <div class="col-md-12">
                            <label>Card Number</label>
                            <input type="text" name="card_number" class="form-control" placeholder="Card Number" />
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label>Ex. Month</label>
                                <input type="text" name="month" class="form-control" placeholder="Ex Month" />
                            </div>
                            <div class="col-md-4">
                                <label>Ex. Year</label>
                                <input type="text" name="year" class="form-control" placeholder="Ex Year" />
                            </div>
                            <div class="col-md-4">
                                <label>CVV</label>
                                <input type="text" name="cvv" class="form-control" placeholder="CVV" />
                            </div>

                        </div>
                        <div class="col-md-12">
                            <hr />
                            <button type="submit" class="btn btn-primary" id="submit_payment" style="width: 100%;" @if($liveOrder->status != 0) disabled @endif>Buy</button>
                            @if($liveOrder->status == 1)
                                <p class="text-center text-success">You have completed the payment. Thank you for your purchase.</p>
                            @endif
                            <hr />
                            <div id="paypal-button-container"></div>
    {{--                        <button  type="submit" class="btn btn-warning" style="width: 100%;">Pay Pal</button>--}}
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
{{--for prod--}}
<script src="https://www.paypal.com/sdk/js?client-id=AUA5MOxQC-8N2Q-LnPNnLSwW_8ONWS8xNdvdFuv3SmogJDgbv6hmGdzMeRsZxh4fCnkdQf_fm3VNRCY1&currency=EUR&commit=true&intent=capture"></script>
{{--for test--}}
{{--<script src="https://www.paypal.com/sdk/js?client-id=AdPFTmn-On7SAQkJD9RSbEQd2rf3OnimKIsYdJCbVBr6wVxytLWIaymutTNuaxZIQyXNGw8ji7e7qQW0&currency=EUR&commit=true&intent=capture"></script>--}}
<script src="https://code.jquery.com/jquery-1.12.4.min.js" integrity="sha384-nvAa0+6Qg9clwYCGGPpDQLVpLNn0fRaROjHqs13t4Ggj3Ez50XnGQqc/r8MhnRDZ" crossorigin="anonymous"></script>

{{--<script src="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js" integrity="sha384-aJ21OjlMXNL5UyIl/XNwTMqvzeRMZH2w8c5cRVpzpU8Y5bApTppSuUkhZXN0VxHd" crossorigin="anonymous"></script>--}}
<!-- JavaScript Bundle with Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/js/bootstrap.bundle.min.js" integrity="sha384-ygbV9kiqUc6oa4msXn9868pTtWMgiQaeYH7/t7LECLbyPA2x65Kgf80OJFdroafW" crossorigin="anonymous"></script>

<script>
    $('#submit_payment').submit(function (event) {
        event.preventDefault();
    });
    window.onload = function () {
        if ('{{$liveOrder->status}}' !== '0') {
            return;
        }
        self = this;
        window['paypal'].Buttons({
            style: {
                shape: 'pill',
                color: 'gold',
                layout: 'horizontal',
                label: 'paypal',

            },

            createOrder: function(data, actions) {
                return actions.order.create({
                    purchase_units: [{"amount":{"currency_code":"EUR","value": '{{$liveOrder->total}}'}}],
                    application_context: {"shipping_preference": "NO_SHIPPING"}
                });
            },
            onApprove: function(data, actions) {
                let loader = document.getElementById('loading-screen');
                loader.style.display = 'unset';
                return actions.order.capture().then(function(details) {
                    console.log('paypal', details);
                    if (details.status === 'COMPLETED') {
                        axios.post('/live-order/paypalSuccess', {id: '{{$liveOrder->id}}', paypal: JSON.stringify(details)}).then((res)=> {
                            if (res.data.status) {
                                console.log('success', res);
                            }
                            loader.style.display = 'none';
                            location.reload();
                        }).catch(err=> {
                            alert('Something went wrong please contact admin.');
                            self.loading = false;
                        })
                    } else {
                        self.lodaing = false;
                        alert('Paypal payment has not been completed.');
                    }

                });
            },

            onError: function(err) {
                console.log(err);
            }
        }).render('#paypal-button-container');
    }
</script>
@include('sweetalert::alert')
</body>
</html>
