
<div style="padding:30px;">
    <form action="/admin/live-order" method="post">
        @csrf
        <h5>Personal Information</h5>

        @if($errors->any())
            @foreach ($errors->all() as $error)
                <p class="text text-danger text-center">{{ $error }}</p>
            @endforeach
        @endif
        @if(session('success'))
            <p class="alert alert-success text-center">{{ session('success') }}</p>
            <p class="text-center"><a href="/admin/live-orders">List of Live Orders</a></p>
        @endif
        <div class="item row">
            <div class="col-md-12">
                <label>Choose a Client</label>
                <div>
                    <select class="show-tick ms select2 mySelect2" style="width:100%;margin-bottom:10px;" name="client_id" data-placeholder="Select" onChange="selectClient()" id="client_id">
                        <option value="">Client</option>
                        @foreach($clients as $client)
                            <option value="{{$client->id}}">{{$client->name}} - {{$client->fb_pseudo}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-6">
                <label>Your Full Legal Name (As Enrolled)</label>
                <input type="text" name="fullname" id="fullname" class="form-control" value="{{old('fullname')}}" placeholder="Full name"/>
            </div>
            <div class="col-md-6">
                <label>&nbsp;</label>
                <input type="text" name="nickname" id="nickname" class="form-control" value="{{old('nickname')}}" placeholder="Nickname"/>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-6">
                <label>Address</label>
                <input type="text" name="address" id="address" class="form-control" value="{{old('address')}}" placeholder="Street address" required/>
                <br />
                <label>Zip Code</label>
                <input type="text" name="zip" id="zip" class="form-control" value="{{old('zip')}}" placeholder="Postal / Zip code" required/>
            </div>
            <div class="col-md-6">
                <label>City</label>
                <input type="text" name="city" id="city" class="form-control" value="{{old('city')}}" placeholder="City" required/>
                <br />
                <label>Country</label>
                <select class="form-control" id="country" name="country">
                    <option value="France">France</option>
                    <option value="Russia">Russia</option>
                    <option value="Germany">Germany</option>
                </select>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-6">
                <label>Email Address<span>*</span></label>
                <input type="text" name="email" class="form-control" id="email" value="{{old('email')}}" placeholder="E-Mail Address" required/>
            </div>
            <div class="col-md-6">
                <label>Phone Number</label>
                <input type="text" name="phone" id="phone" class="form-control" value="{{old('phone')}}" placeholder="Phone" required/>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-12">
                <label>Product</label>
                <textarea rows="5" name="products" class="form-control" value="{{old('products')}}">Live Products</textarea>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-12">
                <label>Total</label>
                <input type="number" name="total" class="form-control" value="{{old('total')}}" placeholder="Price"/>
            </div>
        </div>
        <div class="btn-block text-right">
            <hr />
            <button class="btn btn-primary btn-lg" type="submit" @click="copyLink()">SAVE</button>
        </div>
    </form>
</div>

<script>
    let clients = {!! json_encode($clients) !!};
    async function selectClient(){
        let client_id = $('#client_id').val();
        let client = {
            name:null,
            fb_pseudo:null,
            address:null,
            postal:null,
            email:null,
            telephone:null,
            city:null,
        };
        await clients.map(function(item, i){
            if(item.id==client_id){
                client = item;
            }
        });
            $('#fullname').val(client.name);
            $('#nickname').val(client.fb_pseudo);
            $('#address').val(client.address);
            $('#zip').val(client.postal);
            $('#email').val(client.email);
            $('#phone').val(client.telephone);
            $('#city').val(client.city);
    }
</script>
