
<!DOCTYPE html>
<html>
<head>
    <title>Client Form</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700" rel="stylesheet">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.5.0/css/all.css" integrity="sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU" crossorigin="anonymous">

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css" integrity="sha384-HSMxcRTRxnN+Bdg0JdbxYKrThecOKuH5zCYotlSAcp1+c8xmyTe9GYg1l9a69psu" crossorigin="anonymous">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap-theme.min.css" integrity="sha384-6pzBo3FDv/PJ8r2KRkGHifhEocL+1X2rVCTTkUfGk7/0pbek5mMa1upzvWbrUbOZ" crossorigin="anonymous">

    <style>
        html, body {
            min-height: 100%;
        }
        body, div, form, input, select, p {
            padding: 0;
            margin: 0;
            outline: none;
            font-family: Roboto, Arial, sans-serif;
            font-size: 14px;
            color: #666;
            line-height: 22px;
        }
        h1 {
            margin: 15px 0;
            font-weight: 400;
        }
        .testbox {
            display: flex;
            justify-content: center;
            align-items: center;
            height: inherit;
            padding: 20px;
        }
        .cartbox {
            height: inherit;
            padding: 20px;
        }
        .checkoutform {
            width: 50%;
            padding: 20px;
            background: #fff;
            box-shadow: 0 2px 5px #ccc;
        }
        form {
            width: 100%;
            padding: 20px;
            background: #fff;
            box-shadow: 0 2px 5px #ccc;
        }
        input, select, textarea {
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 3px;
        }
        input {
            width: calc(100% - 10px);
            padding: 5px;
        }
        select {
            width: 100%;
            padding: 7px 0;
            background: transparent;
        }
        textarea {
            width: calc(100% - 6px);
        }
        .item {
            position: relative;
            margin: 10px 0;
        }
        .item:hover p, .item:hover i {
            color: #095484;
        }
        input:hover, select:hover, textarea:hover, .preferred-metod label:hover input {
            box-shadow: 0 0 5px 0 #095484;
        }
        .preferred-metod label {
            display: block;
            margin: 5px 0;
        }
        .preferred-metod:hover input {
            box-shadow: none;
        }
        .preferred-metod-item input, .preferred-metod-item span {
            width: auto;
            vertical-align: middle;
        }
        .preferred-metod-item input {
            margin: 0 5px 0 0;
        }
        input[type="date"]::-webkit-inner-spin-button {
            display: none;
        }
        .item i, input[type="date"]::-webkit-calendar-picker-indicator {
            position: absolute;
            font-size: 20px;
            color: #a9a9a9;
        }
        .item i {
            right: 1%;
            top: 30px;
            z-index: 1;
        }
        [type="date"]::-webkit-calendar-picker-indicator {
            right: 0;
            z-index: 2;
            opacity: 0;
            cursor: pointer;
        }
        .btn-block {
            margin-top: 20px;
            text-align: center;
        }
        button {
            width: 150px;
            padding: 10px;
            border: none;
            -webkit-border-radius: 5px;
            -moz-border-radius: 5px;
            border-radius: 5px;
            background-color: #095484;
            font-size: 16px;
            color: #fff;
            cursor: pointer;
        }
        button:hover {
            background-color: #0666a3;
        }
        @media (min-width: 568px) {
            .name-item, .city-item {
                display: flex;
                flex-wrap: wrap;
                justify-content: space-between;
            }
            .name-item input, .city-item input {
                width: calc(50% - 20px);
            }
            .city-item select {
                width: calc(50% - 8px);
            }
        }
        .row {
            width:100%;
        }
    </style>
</head>
<body>
<div class="testbox">
    <form action="/admin/live-order" method="post">
        @csrf
        <h3><a href="/admin">BACK TO ADMIN</a> ---- <a href="/admin/live-orders">Live Orders</a> ---- Live Order</h3>
        <h5>Personal Information</h5>

        @if($errors->any())
            @foreach ($errors->all() as $error)
                <p class="text text-danger text-center">{{ $error }}</p>
            @endforeach
        @endif
        @if(session('success'))
            <p class="alert alert-success text-center">{{ session('success') }}</p>
            <p class="text-center"><a href="/admin/live-orders">List of Live Orders</a></p>
        @endif
        <div class="item row">
            <div class="col-md-12">
                <label>Choose a Client</label>
                <div class="city-item">
                    <select class="form-control" name="client_id" onChange="selectClient()" id="client_id">
                        <option value="">Client</option>
                        @foreach($clients as $client)
                            <option value="{{$client->id}}">{{$client->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-12">
                <label>Your Full Legal Name (As Enrolled)</label>
            </div>
            <div class="col-md-6">
                <input type="text" name="fullname" id="fullname" class="form-control" value="{{old('fullname')}}" placeholder="Full name"/>
            </div>
            <div class="col-md-6">
                <input type="text" name="nickname" id="nickname" class="form-control" value="{{old('nickname')}}" placeholder="Nickname"/>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-6">
                <label>Address</label>
                <input type="text" name="address" id="address" class="form-control" value="{{old('address')}}" placeholder="Street address" required/>
                <br />
                <label>Zip Code</label>
                <input type="text" name="zip" id="zip" class="form-control" value="{{old('zip')}}" placeholder="Postal / Zip code" required/>
            </div>
            <div class="col-md-6">
                <label>City</label>
                <input type="text" name="city" id="city" class="form-control" value="{{old('city')}}" placeholder="City" required/>
                <br />
                <label>Country</label>
                <select class="form-control" id="country" name="country">
                    <option value="France">France</option>
                    <option value="Russia">Russia</option>
                    <option value="Germany">Germany</option>
                </select>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-6">
                <label>Email Address<span>*</span></label>
                <input type="text" name="email" class="form-control" id="email" value="{{old('email')}}" placeholder="E-Mail Address" required/>
            </div>
            <div class="col-md-6">
                <label>Phone Number</label>
                <input type="text" name="phone" id="phone" class="form-control" value="{{old('phone')}}" placeholder="Phone" required/>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-12">
                <label>Product</label>
                <textarea rows="5" name="products" class="form-control" value="{{old('products')}}">Live Products</textarea>
            </div>
        </div>
        <div class="item row">
            <div class="col-md-12">
                <label>Total</label>
                <input type="number" name="total" class="form-control" value="{{old('total')}}" placeholder="Price"/>
            </div>
        </div>
        <div class="btn-block">
            <button style="float: right" type="submit">SAVE</button>
        </div>
    </form>
</div>

<!-- Latest compiled and minified CSS -->

<!-- Optional theme -->

<script src="https://code.jquery.com/jquery-1.12.4.min.js" integrity="sha384-nvAa0+6Qg9clwYCGGPpDQLVpLNn0fRaROjHqs13t4Ggj3Ez50XnGQqc/r8MhnRDZ" crossorigin="anonymous"></script>
<!-- Latest compiled and minified JavaScript -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js" integrity="sha384-aJ21OjlMXNL5UyIl/XNwTMqvzeRMZH2w8c5cRVpzpU8Y5bApTppSuUkhZXN0VxHd" crossorigin="anonymous"></script>
<script>
    let clients = {!! json_encode($clients) !!};
    function selectClient(){
        let client_id = $('#client_id').val();
        console.log(clients[client_id]);
        $('#fullname').val(clients[client_id].name);
        $('#nickname').val(clients[client_id].fb_pseudo);
        $('#address').val(clients[client_id].address);
        $('#zip').val(clients[client_id].postal);
        $('#email').val(clients[client_id].email);
        $('#phone').val(clients[client_id].telephone);
        $('#city').val(clients[client_id].city);
    }
</script>
</body>
</html>
