@extends('layouts.admin')

@section('content')
{{--{{dd(csrf_token())}}--}}
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="card">
                    <div class="card-body">
                        <form novalidate enctype="multipart/form-data">
                            @csrf
                            <div class="row text-center">
                                <div class="col-6">
                                    <div class="">
                                        <img src="" id="existingImg"  alt="" style=" height:200px;">
                                    </div>
                                    <div class="">
                                        <div class="form-group">
                                            <label>Product Name</label>
                                            <input type="text" id="product_title" v-model="product.title" class="form-control"  value="">
                                            <div v-if="titleIssue" style="height: 1px; width: 100%; border: 1px solid darkred"></div>
                                        </div>
                                    </div>
                                    <div class="">
                                        <div class="form-group">
                                            <label>Code</label>
                                            <input type="text" id="product_code" v-model="product.code" class="form-control" value="">
                                            <div v-if="codeIssue === true" style="height: 1px; width: 100%; border: 1px solid darkred"></div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label>Price</label>
                                                <input type="number" id="product_price" v-model="product.price" class="form-control" value="">
                                                <div v-if="priceIssue === true" style="height: 1px; width: 100%; border: 1px solid darkred"></div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label>Shipping Price (refers to the product by itself)</label>
                                                <input type="number" id="product_shipping" v-model="product.shipping_price" class="form-control" value="">
                                            </div>
                                        </div>

                                    </div>
                                    <div class="">
                                        <div class="form-group">
                                            <label>Product Description</label>
                                            <input type="text" id="product_desc" v-model="product.prod_desc" class="form-control" value="">
                                            <div v-if="descIssue === true" style="height: 1px; width: 100%; border: 1px solid darkred"></div>
                                        </div>
                                    </div>
                                    <div class="">
                                        <div class="form-group">
                                            <label>Category / Subcategory</label>
                                            <div class="row">
                                                <div class="col-6">
                                                    <select class="form-control show-tick ms select2" data-placeholder="Select" name="category" id="category" v-model="selectedCat" @change="selectCatChange()">
                                                        <option></option>
                                                        <option v-for="cat in categories" v-if="cat.sub_categories.length > 0" :value="cat.id"> @{{ cat.title }}</option>
                                                    </select>
                                                </div>

                                                <div class="col-6">
                                                    <select class="form-control show-tick ms select2" data-placeholder="Select" name="sCat" v-model="selectedSubCat" :disabled="subCategories.length <=0">
                                                        <option></option>
                                                        <option v-for="sCat in subCategories" :value="sCat.id"> @{{ sCat.title }}</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="">
                                        <div class="body" >
                                            <input type="file" id="image" name="image" class="dropify-product" v-on:change="onImageChange" data-allowed-file-extensions="png jpg jpeg">
                                        </div>
                                    </div>
                                    <div class="text-center mt-4">
                                        <a class="btn btn-dark" style="color: #fff0ff; width: 45%" @click="anotherSize()">Add Size</a>
                                        <a class="btn btn-primary" style=" color: #fff0ff; width: 45%"  v-if="isUploading">
                                            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                            Saving...
                                        </a>
                                        <a class="btn btn-primary" v-else style="color: #fff0ff; width: 45%" @click="saveProduct()">Save Product</a>
                                        <div v-if="added && product.status == 0">
                                            <a class="btn btn-success mt-2" style=" color: #fff0ff; width: 45%"  v-if="isActivating">
                                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                Activating...
                                            </a>
                                            <a class="btn btn-success mt-2"  v-else style="color: #fff0ff; width: 45%" @click="deleteProd('activate')">Activate Product</a>

                                            <a class="btn btn-danger mt-2" style=" color: #fff0ff; width: 45%"  v-if="isDeleting">
                                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                Deleting...
                                            </a>
                                            <a class="btn btn-danger mt-2"  v-else style="color: #fff0ff; width: 45%" @click="deleteProd('delete')">Delete Product</a>
                                        </div>
                                        <div v-if="added && product.status == 1">
                                            <a class="btn btn-warning mt-2" style=" color: #fff0ff; width: 45%"  v-if="isDeleting">
                                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                Deactivating...
                                            </a>
                                            <a class="btn btn-warning mt-2"  v-else style="color: #fff0ff; width: 45%" @click="deleteProd('deactivate')">Deactivate Product</a>
                                        </div>

                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <el-upload
                                        action="#"
                                        list-type="picture-card"
                                        :auto-upload="false">
                                        <i slot="default" class="el-icon-plus"></i>
                                        <div slot="file" slot-scope="{file}">
                                            <img
                                                class="el-upload-list__item-thumbnail"
                                                :src="file.url" alt=""
                                            >
                                            <span class="el-upload-list__item-actions">
{{--                                            <span--}}
{{--                                                class="el-upload-list__item-preview"--}}
{{--                                                @click="handlePictureCardPreview(file)"--}}
{{--                                            >--}}
{{--                                              <i class="el-icon-zoom-in"></i>--}}
{{--                                            </span>--}}
{{--                                            <span--}}
{{--                                                v-if="!disabled"--}}
{{--                                                class="el-upload-list__item-delete"--}}
{{--                                                @click="handleDownload(file)"--}}
{{--                                            >--}}
{{--                                              <i class="el-icon-download"></i>--}}
{{--                                            </span>--}}
                                            <span
                                                v-if="!disabled"
                                                class="el-upload-list__item-delete"
                                                @click="handleRemove(file)"
                                            >
                                              <i class="el-icon-delete"></i>
                                            </span>
                                          </span>
                                        </div>
                                    </el-upload>
                                    <el-dialog :visible.sync="dialogVisible">
                                        <img width="100%" :src="dialogImageUrl" alt="">
                                    </el-dialog>
                                </div>
                            </div>

                            <hr>
                            <div v-for="(item, sizeIndex) in sizes" class="ml-4">
                                <div class="row">
                                    <div class="col-lg-4 col-md-6 col-sm-11">
                                        <div class="form-group">
                                            <label>Size</label>
                                            <input type="text" class="form-control" :id="sizeIndex+'sizeSz'" v-model="item.size">
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <label>Total stock of size</label>
                                            <input type="number" class="form-control" :id="sizeIndex+'sizeStck'" v-model="item.stock" disabled>
                                        </div>
                                    </div>
                                    <div class="col-lg-1 col-md-1 col-sm-11">
                                        <a class="btn btn-danger mt-10" style="color: #fff0ff; margin-top: 1.6rem !important; width: 100%;" @click="removeSize(sizeIndex)">X</a>
                                    </div>
                                    <div class="col-lg-3 col-md-5 col-sm-12">
                                        <a class="btn btn-dark mt-10" style="color: #fff0ff; margin-top: 1.6rem !important; width: 100%;" @click="addColorToSize(sizeIndex)">Add Color</a>
                                    </div>

                                </div>
                                <div v-for="(color, colorIndex) in item.colors" class="ml-4">
                                    <div class="row">
                                        <div class="col-lg-4 col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label>Color</label>
                                                <input type="text" class="form-control" :id="colorIndex+'colorClr'" v-model="color.color">
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-5 col-sm-12">
                                            <div class="form-group">
                                                <label>Stock of Color</label>
                                                <input @change="colorStockChange(color.stock, sizeIndex, colorIndex)" @keyup="colorStockChange(color.stock, sizeIndex, colorIndex)"type="number" class="form-control" :id="colorIndex+'colorStck'" v-model="color.stock" >
                                                <div v-if="color.danger === true" style="height: 1px; width: 100%; border: 1px solid darkred"></div>
                                            </div>
                                        </div>
                                        <div class="col-lg-1 col-md-1 col-sm-11">
                                            <a class="btn btn-danger mt-10" style="color: #fff0ff; margin-top: 1.6rem !important; width: 100%;" @click="removeColor(sizeIndex, colorIndex)">X</a>
                                        </div>
                                    </div>
                                </div>
{{--                                <hr>--}}
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>



    <script>
        const Vue_comp = new Vue({
            el:"#main-content",
            data: {
                id:0,
                link:null,
                sizes: [],
                stockIssue: false,
                titleIssue: false,
                codeIssue: false,
                descIssue: false,
                priceIssue: false,
                imageIssue: false,
                added: false,
                isDeleting: false,
                isActivating: false,
                myImage: null,
                existingImg:null,
                isUploading: false,
                product: {
                    title: '',
                    prod_desc: '',
                    code: '',
                    price: 0,
                    shipping_price: 0
                },
                categories: [], subCategories: [], selectedCat: null, selectedSubCat: null,
                dialogImageUrl: '',
                dialogVisible: false,
                disabled: false
            },
            methods: {
                anotherSize: function () {
                    let s = {
                        id:0,
                        size: '',
                        stock: 0,
                        colors: [],
                    }
                    this.sizes.push(s);
                },
                onImageChange(e){
                    this.myImage = e.target.files[0];
                },
                addColorToSize: function (sizeIndex) {
                    let c = {
                        id:0,
                        color: '',
                        stock: 0,
                        danger: false
                    };
                    this.sizes[sizeIndex].colors.push(c);
                },
                handleRemove(file){
                    console.log(file);
                },
                colorStockChange: function (val, sizeIndex, colorIndex) {
                    let sumC = 0;
                    for (let i=0; i< this.sizes[sizeIndex].colors.length; i++) {
                        sumC += parseInt(this.sizes[sizeIndex].colors[i].stock);
                    }
                    this.sizes[sizeIndex].stock = sumC;
                    if (!this.sizes[sizeIndex].stock) {
                        this.stockIssue = true;
                        this.sizes[sizeIndex].colors[colorIndex].danger = true;
                        if (!this.stockIssue) {
                            showToast('warning', 'Please make sure that the stocks you entered correspond with each other.');
                        }
                    }  else {
                        this.stockIssue = false;
                        this.sizes[sizeIndex].colors[colorIndex].danger = false;
                    }
                    // if (parseInt(val) > parseInt(this.sizes[sizeIndex].stock) || sumC > parseInt(this.sizes[sizeIndex].stock) || parseInt(val) < 0) {
                    //     if (!this.stockIssue) {
                    //         showToast('warning', 'Please make sure that the stocks you entered correspond with each other.');
                    //     }
                    //     this.stockIssue = true;
                    //     this.sizes[sizeIndex].colors[colorIndex].danger = true;
                    // }  else {
                    //     this.stockIssue = false;
                    //     this.sizes[sizeIndex].colors[colorIndex].danger = false;
                    // }
                },
                removeSize: function (sizeIndex) {
                    this.sizes.splice(sizeIndex, 1);
                },
                removeColor: function (sizeIndex, colorIndex) {
                    this.sizes[sizeIndex].colors.splice(colorIndex, 1);
                    let sumC = 0;
                    for (let i=0; i< this.sizes[sizeIndex].colors.length; i++) {
                        sumC += parseInt(this.sizes[sizeIndex].colors[i].stock);
                    }
                    this.sizes[sizeIndex].stock = sumC;
                },
                saveProduct: function() {
                    const self = this;
                    if (this.product.title === '') {
                        this.prodIssue = true;
                        showToast('warning', 'Please enter the name of the product.');
                    }
                    else if (this.product.prod_desc === '') {
                        this.descIssue = true;
                        showToast('warning', 'Please enter a description for the product.');
                    }
                    else if (this.product.code === '') {
                        this.codeIssue = true;
                        showToast('warning', 'Please enter a code that will be a unique referer for the product.');
                    }
                    else if (this.product.price <= 0) {
                        this.priceIssue = true;
                        showToast('warning', 'Please enter a valid price for your product.');
                    }
                    else {
                        this.prodIssue = false;
                        this.descIssue = false;
                        this.codeIssue = false;
                        this.priceIssue = false;
                        this.imageIssue = false;
                        if (!this.stockIssue && this.sizes.length > 0) {
                            let colIssue = false;
                            for (let i = 0; i<this.sizes.length; i++) {
                                if(this.sizes[i].colors.length === 0) {
                                    colIssue = true;
                                    break;
                                }
                            }
                            if (colIssue) {
                                showToast('warning', 'Please provide your sizes with available attributes.');
                                return ;
                            }
                            if (!this.selectedCat || !this.selectedSubCat) {
                                showToast('warning', 'Make sure to place the product in its category.');
                                return;
                            }
                            let formData = new FormData();
                            formData.append('image', this.myImage);
                            formData.append('product', JSON.stringify(this.product));
                            formData.append('sizes', JSON.stringify(this.sizes));
                            formData.append('category', JSON.stringify({cat: this.selectedCat, sub_cat: this.selectedSubCat}));
                            self.isUploading = true;
                            axios.defaults.headers.post['Content-Type'] = 'multipart/form-data';
                            axios.defaults.headers.post['X-CSRF-TOKEN'] = '{{csrf_token()}}';
                            axios.post(self.link + '/'+self.id, formData).then(response => {
                                if (response.status) {
                                    // self.product = response.data.values.product;
                                    // self.id = response.data.values.product.id
                                    // self.product.prod_desc = response.data.values.product.description;
                                    // self.sizes = response.data.values.sizes;
                                    // self.existingImg = self.product.image;
                                    // self.added = true;
                                    // $('#existingImg').attr("src",self.existingImg);
                                    self.product =  {
                                        title: '',
                                        prod_desc: '',
                                        code: '',
                                        price: 0
                                    };
                                    self.product.prod_desc = '';
                                    self.sizes = [];
                                    $('#existingImg').attr("src",'');
                                    self.added = false;
                                    self.id = 0;
                                    showToast('success', 'You have successfully saved your product.');
                                } else {
                                    showToast('warning', response.message);
                                }
                                self.isUploading = false;
                            })
                        } else {
                            showToast('warning', 'Please first make regulations with the sizes and stocks of your product.');
                        }
                    }
                },
                deleteProd(type) {
                    const self = this;
                    if (type !== 'activate') {
                        self.isDeleting = true;
                    } else {
                        self.isActivating = true;
                    }
                    axios.post( 'admin/deleteProduct/'+self.id, {type}).then(response=>{
                        console.log(response);
                        if (response.status) {
                            if (type == 'delete'){
                                self.product =  {
                                    title: '',
                                    prod_desc: '',
                                    code: '',
                                    price: 0
                                };
                                self.product.prod_desc = '';
                                self.sizes = [];
                                $('#existingImg').attr("src",'');
                                self.added = false;
                                self.id = 0;
                            } else {
                                self.product = response.data.values;
                                self.product.prod_desc = response.data.values.description;
                                self.sizes = response.data.values.sizes;
                                self.existingImg = self.product.image;
                                $('#existingImg').attr("src",self.existingImg);
                            }
                        }
                        showToast('success', response.data.message);
                        self.isDeleting = false;
                        self.isActivating = false;
                    });
                },
                selectCatChange() {
                    if (this.selectedCat) {
                        this.categories.find(cat => {
                            if (cat.id === this.selectedCat){
                                this.subCategories = cat.sub_categories;
                            }
                        });
                    } else {
                        this.subCategories = [];
                    }
                },
                disableSelect(){
                    return this.subCategories <=0;
                }
            },
            created(){
                const self = this;
                self.link = '{{url("/admin/product")}}';
                self.id = {{$id}};
                if (self.id && self.id != 0){
                    console.log()
                    axios.post( 'api/V1/getSingleProduct',{'id':self.id}, {
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        self.product = response.data.values;
                        self.product.prod_desc = response.data.values.description;
                        self.sizes = response.data.values.sizes;
                        self.existingImg = self.product.image;
                        self.added = true;
                        self.selectedCat = response.data.values.sub_cat.cat_id;
                        self.selectedSubCat = response.data.values.sub_cat.id;
                        self.selectCatChange();
                        console.log(self.product);
                        $('#existingImg').attr("src",self.existingImg);
                    }).catch(function(error){});
                }else{
                    self.id = 0;
                }
                axios.post( 'api/V1/getCategories', {}, {
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{csrf_token()}}'
                        },
                    }
                ).then(function(res){
                    console.log('categories', res);
                    self.categories = res.data.values;
                }).catch(function(error){});
            }
        });
    </script>
@endsection
@section('footer')
    {{--<script>--}}
    {{--    window.onload = function () {--}}
    {{--        // showToast('danger', )--}}
    {{--    }--}}
    {{--</script>--}}

@endsection
