@extends('layouts.admin')

@section('content')
    <div id="main-content">

        <div class="row mt-5" id="manage-orders">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="header">
                        <h2>Live Orders</h2>
                    </div>
                    <div class="body">
                        @include('admin.live-order')

                        <div class="ml-auto row" style="width:100%;">
                            <div class="col-6" style="padding:5px 0;">
                                <button class="btn btn-dark" :disabled="apiData.prev_page_url === null" v-on:click="prevPage()">
                                    Previous Page
                                </button>
                                <button class="btn btn-dark" :disabled="apiData.next_page_url === null" v-on:click="nextPage()">
                                    Next Page
                                </button>
                                <input type="text" placeholder="Search User, order id..." class="form-control" v-model="search" v-on:keyUp="getOrders()" style="width: auto !important; display: initial !important;">


                                {{--                            <button class="btn btn-dark" :disabled="apiData.prev_page_url === null" v-on:click="prevPage()">--}}
                                {{--                                Previous Page--}}
                                {{--                            </button>--}}
                                {{--                            <button class="btn btn-dark" :disabled="apiData.next_page_url === null" v-on:click="nextPage()">--}}
                                {{--                                Next Page--}}
                                {{--                            </button>--}}
                                <div class="spinner-border" role="status" v-if="changePage">
                                    <span class="sr-only">Loading...</span>
                                </div>
                            </div>
                            <div class="col-6" style="padding:5px 0 15px 0;">
                                <div class="user-account">
                                    <div class="dropdown" style="float: right">
                                        <a href="javascript:void(0);" class="dropdown-toggle user-name" data-toggle="dropdown">Orders per page: @{{ paginate }}</a>
                                        <ul class="dropdown-menu dropdown-menu-right account animated flipInY">
                                            <li><a href="javascript:void(0);" v-on:click="changePag(15)">15</a></li>
                                            <li class="divider"></li>
                                            <li><a href="javascript:void(0);" v-on:click="changePag(30)">30</a></li>
                                            <li class="divider"></li>
                                            <li><a href="javascript:void(0);" v-on:click="changePag(45)">45</a></li>
                                            <li class="divider"></li>
                                            <li><a href="javascript:void(0);" v-on:click="changePag(60)">60</a></li>
                                        </ul>
                                    </div>
                                    <div class="dropdown" style="float: right; margin-right: 12px;">
                                        <a href="javascript:void(0);" class="dropdown-toggle user-name" data-toggle="dropdown">Order type: @{{ type }}</a>
                                        <ul class="dropdown-menu dropdown-menu-right account animated flipInY">
                                            <li><a href="javascript:void(0);" v-on:click="changeType('All')">All</a></li>
                                            <li class="divider"></li>
                                            <li><a href="javascript:void(0);" v-on:click="changeType('Pending')">Pending</a></li>
                                            <li class="divider"></li>
                                            <li><a href="javascript:void(0);" v-on:click="changeType('Completed')">Completed</a></li>
                                            <li class="divider"></li>
                                            <li><a href="javascript:void(0);" v-on:click="changeType('Rejected')">Rejected</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive" v-if="orders.length > 0">
                            <table class="table table-hover m-b-0 text-center">
                                <thead class="thead-dark">
                                <tr>
                                    <th>Id</th>
                                    <th>Products</th>
                                    <th>User</th>
                                    <th>Address</th>
                                    <th>Date</th>
                                    <th>Phone</th>
                                    <th>Nickname</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(order, i) in orders">
                                    <td>@{{ order.id }}</td>
                                    <td><span>@{{ order.products }}</span></td>
                                    <td><span>@{{ order.fullname }}</span></td>
                                    <td><span>@{{ order.city }}, @{{ order.address }} @{{ order.zip }}</span></td>
                                    <td><span>@{{ dateStr(order.created_at) }}</span></td>
                                    <td>@{{ order.phone }}</td>
                                    <td><span>@{{ order.nickname }}</span></td>
                                    <td><span>@{{ order.total }}</span></td>
                                    <td>
                                        <span class="badge badge-warning" v-if="order.status === 0">Pending</span>
                                        <span class="badge badge-success" v-if="order.status === 1">Payment Completed</span>
                                        <span class="badge badge-danger" v-if="order.status === 2">Rejected</span>
                                    </td>
                                    <td>
                                        <button class="btn btn-dark" :disabled="order.status !== 0"  v-on:click="makeSelection(order, i)" data-toggle="modal" data-target="#orderInfo">
                                            Action
                                        </button>
                                        <button class="btn btn-success" @click="copyLink(order)">
                                            Copy Link
                                        </button>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div v-else>
                            <h1 class="text-center" style="font-style: italic;">No orders available.</h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {{--        Order Info Modal--}}
        <div class="modal fade" id="orderInfo" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content" v-if="selectedOrder">
                    <div class="modal-header">
                        <h4 class="title text-center text-primary" id="largeModalLabel">Order Actions</h4>
                    </div>
                    <div class="row">
                        <div class="col-6 mt-2">
                            <div class="form-group text-right">
                                <button class="btn btn-success" @click="changeStatus(selectedOrder, '1')">
                                    Payment Completed
                                </button>
                            </div>
                        </div>
                        <div class="col-6 mt-2">
                            <div class="form-group text-left">
                                <button class="btn btn-danger" @click="changeStatus(selectedOrder, '2')">
                                    Payment Rejected
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="copyText" id="copyText" >
    </div>



@endsection
@section('footer')
    <script>
        const Vue_comp = new Vue({
            el:"#main-content",
            data: {
                orders: [],
                latestOrderId: '{{$lastOrder->id}}',
                apiData: {
                    prev_page_url:null,
                    next_page_url:null
                },
                changePage: false,
                link: 'admin/live-orders',
                type: 'All',
                paginate: 30,
                modProducts: [],
                search: '',
                orderLoading: 0,
                selectedOrder: null,
                orderInfo: '',
                currIndex: 0,
                actionLoading: false,
            },
            created() {
                this.getOrders();
            },
            methods: {
                capitalizeFirstLetter(string) {
                    return string.charAt(0).toUpperCase() + string.slice(1);
                },
                dateStr(d) {
                    // return new Date(d).toDateString();
                    return moment(d).format('DD MMM, YYYY');
                },
                getOrders() {
                    const self = this;
                    let params = {number: this.paginate, search: this.search, type: this.type};

                    axios.post(this.link, params, {
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        console.log('live orders', response)
                        if (response.data.status) {
                            self.apiData = response.data.values;
                            self.orders = self.apiData.data;
                        }
                        this.changePage = false;
                    }).catch(function(error){
                        this.changePage = false;
                    });
                },
                prevPage() {
                    if (this.apiData && this.apiData.prev_page_url) {
                        // this.changePage = true;
                        this.link = this.apiData.prev_page_url;
                        this.getOrders();
                    }
                },
                nextPage() {
                    if (this.apiData && this.apiData.next_page_url) {
                        // this.changePage = true;
                        this.link = this.apiData.next_page_url;
                        this.getOrders();
                    }
                },
                changePag(val) {
                    this.paginate = val;
                    this.getOrders();
                },
                modalProds(order) {
                    this.modProducts = order.items;
                },
                orderReady(order, link, msg = null, i = 0) {
                    const self = this;
                    this.orderLoading = order.id;
                    const info = this.orderInfo;
                    if (i != 0) {
                        this.currIndex = i;
                    }
                    axios.post(link, {id: order.id, info}, {
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        self.orderLoading = 0;
                        if (response.data.status) {
                            let m = '';
                            if (msg !== null) {
                                m = 'Order ' + msg;
                            } else {
                                m = response.data.message;
                            }
                            self.orders[self.currIndex] = response.data.values;
                            showToast('success', m);
                        } else {
                            showToast('warning', response.data.message);

                        }
                    }).catch(function(error){
                        self.orderLoading = 0;
                        showToast('warning', 'Something went wrong.');
                    });
                },
                editInfo(order) {
                    const self = this;
                    this.orderLoading = order.id;
                    const info = this.orderInfo;
                    axios.post('admin/editOrderInfo', {id: order.id, info}, {
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response) {
                        self.orderLoading = 0;
                        if (response.data.status) {
                            self.orders[self.currIndex] = response.data.values;
                            showToast('success', 'Order edited successfully.');
                        } else {
                            showToast('warning', response.data.message);

                        }
                    });
                },
                changeStatus(order, type) {
                    const self = this;
                    self.actionLoading = true;
                    axios.post('admin/live-order/change-type', {id: order.id, type}, {
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response) {
                        self.orderLoading = 0;
                        if (response.data.status) {
                            self.orders[self.currIndex] = response.data.values;
                            $('#orderInfo').modal('hide');
                            showToast('success', 'Action completed.');
                        } else {
                            showToast('warning', response.data.message);
                        }
                    }).finally(() => {
                        self.actionLoading = false;
                    });
                },
                copyLink(order=null) {
                    let id = parseInt(this.latestOrderId) + 1;
                    if(order!=null) {
                        id = parseInt(order.id);
                    }
                    let textToCopy = $('#copyText');
                    textToCopy.val('{!! url('/live-order') !!}' +`/${id}`);
                    textToCopy.attr('type', 'text');
                    textToCopy.select();
                    let successful = document.execCommand('copy');
                    let msg = successful ? 'successful' : 'unsuccessful';
                    showToast('success', 'Url copied ' + msg);
                    textToCopy.attr('type', 'hidden');
                    window.getSelection().removeAllRanges();
                },
                changeType(val) {
                    this.type = val;
                    this.getOrders();
                },
                makeSelection(order, i) {
                    this.selectedOrder = order;
                    this.currIndex = i;
                }
            }
        });
    </script>
@endsection
