@extends('layouts.admin')
@section('otherStyles')
    <link rel="stylesheet" href="{{ asset('assets/admin_styles/vendor/jquery-datatable/dataTables.bootstrap4.min.css') }}">
@endsection

@section('content')
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="/admin"><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item active">Manage Coupons</li>
                        </ul>
                    </div>
                </div>
            </div>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                        <div class="row mt-2">
                                            <div class="col-lg-4 col-sm-12">
                                                <div class="row">
                                                    <div class="col-lg-4 col-md-6 col-sm-11">
                                                        <div class="form-group">
                                                            <label>Coupon Code</label>
                                                            <input type="text" class="form-control" v-model="currentCoupon">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-11">
                                                        <div class="form-group text-center">
                                                            <p> <b>Coupon type</b> </p>
                                                            <label class="fancy-radio custom-color-green"><input name="shipping" v-model="couponType" value="%" type="radio" @><span><i></i>%</span></label>
                                                            <label class="fancy-radio custom-color-green"><input name="shipping" v-model="couponType" value="-" type="radio" ><span><i></i>-</span></label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-11">
                                                        <div class="form-group">
                                                            <label>Value</label>
                                                            <input type="number" class="form-control" v-model="couponPrice">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-11">
                                                        <div class="form-group">
                                                            <label>Start Date</label>
                                                            <input type="date" class="form-control" v-model="startDate" @change="testDate()" :min="cDate">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-11">
                                                        <div class="form-group">
                                                            <label>End Date</label>
                                                            <input type="date" class="form-control" v-model="endDate" :disabled="startDate === null" :min=" startDate">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-11">
                                                        <div class="form-group">
                                                            <label>No. of coupons</label>
                                                            <input type="number" class="form-control" v-model="couponNumbers">
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-sm-12">
                                                <div class="col-lg-12 col-md-12 col-sm-12" v-if="!isAdding">
                                                    <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-if="couponId === 0" @click="submitCoupon()">Add Coupon</a>
                                                    <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-else @click="submitCoupon()">Save Coupon</a>
                                                </div>
                                                <div class="col-lg-12 col-md-12 col-sm-12" v-else>
                                                    <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-if="couponId === 0" disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                        Adding...</a>
                                                    <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                        Saving...</a>
                                                </div>
                                                <div v-if="couponId !== 0">
                                                    <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                                        <a class="btn btn-warning" style="color: #fff0ff; width: 100%;" @click="clearSelection()">Clear</a>
                                                    </div>
                                                    <div class="col-lg-12 col-md-6 col-sm-12 mt-2">
                                                        <div  v-if="selectedCoupon.status == 1">
                                                            <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" @click="deleteCoupon()" v-if="!isDeleting">Deactivate</a>
                                                            <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                                Deactivating...</a>
                                                        </div>
                                                        <div v-else>
                                                            <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" @click="deleteCoupon()" v-if="!isDeleting">Delete</a>
                                                            <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                                Deleting...</a>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mt-2" v-if="selectedCoupon.status == 0">
                                                        <a class="btn btn-success" style="color: #fff0ff; width: 100%;" @click="activateCoupon()" v-if="!isActivating">Activate</a>
                                                        <a class="btn btn-success" style="color: #fff0ff; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Activating...</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-sm-12">
                                                <div class="row">
                                                    <div class="col-lg-12 col-md-12 col-sm-12 text-center" data-toggle="tooltip" data-original-title="Coupon Image" data-placement="bottom">
                                                        <el-upload
                                                            class="avatar-uploader"
                                                            action=""
                                                            :auto-upload=false
                                                            :show-file-list=false
                                                            :on-change="handlePreview"
                                                            :on-remove="handleRemove">
                                                            <img v-if="imageUrl" :src="imageUrl" class="avatar">
                                                            <i v-else class="el-icon-plus avatar-uploader-icon"></i>
                                                        </el-upload>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
{{--                                        <div class="row" v-if="couponId !== 0">--}}

{{--                                        </div>--}}
                                        <hr>
                                </div>
                            </div>
                            <div class="row clearfix" v-if="coupons.length > 0">
                                <div class="col-lg-12">
                                    <div class="card">
                                        <div class="body">
                                            <div class="table-responsive">
                                                <table class="table table-hover js-basic-example dataTable table-custom">
                                                    <thead>
                                                    <tr>
                                                        <th class="text-center">Icon</th>
                                                        <th class="text-center">Product</th>
                                                        <th class="text-center">Status</th>
                                                        <th class="text-center">Select</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(c, i) in coupons" class="text-center" >
                                                        <td ><img :src="c.image" alt="img" class="img-fluid" style="height: 40px"></td>
                                                        <td>@{{ c.code }}</td>
                                                        <td><span class="badge badge-success" v-if="c.status == 1">Active</span><span class="badge badge-danger" v-else>Inactive</span></td>
                                                        <td><a class="btn btn-primary" style="color: #fff0ff" @click="selectCoupon(c)">Select Coupon</a></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
        </div>
    </div>
@endsection
@section('footer')
    <style>
        .avatar-uploader .el-upload {
            border: 1px dashed #d9d9d9;
            border-radius: 6px;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            width: 100%;
            /*min-width: 30%;*/
            height: 200px;
        }
        .avatar-uploader .el-upload:hover {
            border-color: #409EFF;
        }
        .avatar-uploader-icon {
            font-size: 28px;
            color: #8c939d;
            width: 100%;
            height: 100%;
            line-height: 200px;
            text-align: center;
        }
        .avatar {
            width: auto;
            height: 200px;
            display: block;
            margin: 0 auto;
        }
        .blur-card {
            filter: blur(4px);
        }
        .text-on-top {
            position: absolute;
            top: 27px;
            width: 100%;
            text-align: center;
            font-weight: 500;
            font-size: 1.25rem;
        }
    </style>
    <script>

        const Vue_comp = new Vue({
            el:"#main-content",
            data: {
                currentCoupon: '',
                couponType: '-', couponPrice: 0, couponNumbers: 0,
                coupons: [],  startDate: null, endDate:null, cDate: new Date().toISOString().split('T')[0],
                selectedCoupon: null,
                couponId: 0,
                imageUrl: '',
                file: null,
                isActivating: false, isAdding: false, isDeleting: false,
            },
            created() {
                const self = this;
                axios.post( 'api/V1/getAllCoupons',{}, {
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{csrf_token()}}'
                        },
                    }
                ).then(function(response){
                    self.coupons = response.data.values;
                    console.log('coupons', response.data);
                    // if(self.banners.length > 0){
                    //     $.each(self.banners,function (index,value){
                    //         self.fileList.push({name: 'banner', url: value.image});
                    //         self.bnrDesc.push(value.description);
                    //         self.prodIds.push(value.prod_id);
                    //     })
                    // }
                }).catch(function(error){});
            },
            methods: {
                selectCoupon(c) {
                    // console.log(c);
                    this.couponId = c.id;
                    this.currentCoupon = c.code;
                    this.imageUrl = c.image;
                    this.selectedCoupon = c;
                    this.startDate = c.start_date;
                    this.endDate = c.end_date;
                    this.couponType = c.type;
                    this.couponPrice = c.price;
                    this.couponNumbers = c.c_limit;
                },
                clearSelection() {
                    this.couponId = 0;
                    this.currentCoupon = '';
                    this.imageUrl = '';
                    this.file = null;
                    this.startDate = null;
                    this.endDate = null;
                    this.type = '-';
                    this.couponPrice = 0;
                    this.couponNumbers = 0;
                },
                handleRemove(file, fileList) {
                    this.imageUrl = '';
                    this.file = null;
                },
                handlePreview(file) {
                    this.imageUrl = URL.createObjectURL(file.raw);
                    this.file = file;
                    console.log('file', file);
                    console.log('img', this.imageUrl);
                },
                submitCoupon(){
                    const self = this;
                    let formData = new FormData();
                    self.isAdding = true;
                    if (self.file) {
                        if (self.file.raw === undefined) {
                            formData.append('image', self.file.url);
                            // console.log("here");
                        } else {
                            formData.append('image', self.file.raw);
                            // console.log("there");
                        }
                    }
                    // console.log(formData.getAll("image"));
                    formData.append('coupon', self.currentCoupon);
                    formData.append('coupon_type', self.couponType);
                    formData.append('price', self.couponPrice);
                    formData.append('start_date', self.startDate);
                    formData.append('end_date', self.endDate);
                    formData.append('no_of_coupons', self.couponNumbers);
                    axios.defaults.headers.post['Content-Type'] = 'multipart/form-data';
                    axios.post( '/admin/addCoupon/' + self.couponId, formData, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        if (response.data.status) {
                            if (self.couponId == 0) {
                                self.coupons.push(response.data.values);
                            } else {
                                let i = self.coupons.indexOf(self.selectedCoupon);
                                self.coupons[i] = response.data.values;
                            }
                            self.selectedCoupon = response.data.values;
                            self.couponId = self.selectedCoupon.id;
                            self.currentCoupon = self.selectedCoupon.code;
                            self.imageUrl = self.selectedCoupon.image;
                            showToast('success', response.data.message);
                        } else {
                            showToast('warning', response.data.message);
                        }
                        self.isAdding = false;
                    }).catch(function(error){

                    });
                },
                activateCoupon() {
                    const self = this;
                    self.isActivating = true;
                    axios.post( '/admin/activateCoupon/' + self.couponId, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        console.log('res', response)
                        if (response.data.status) {
                            let i = self.coupons.indexOf(self.selectedCoupon);
                            self.selectedCoupon = response.data.values;
                            self.coupons[i] = response.data.values;
                            showToast('success', response.data.message);
                        }
                        self.isActivating = false;
                    }).catch(function(error){

                    });
                },
                deleteCoupon() {
                    const self = this;
                    self.isDeleting = true
                    axios.post( '/admin/deleteCoupon/' + self.couponId, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        console.log('res', response)

                        if (response.data.status) {
                            let i = self.coupons.indexOf(self.selectedCoupon);
                            if (response.data.values == null) {
                                self.coupons.splice(i, 1);
                                self.clearSelection();
                            } else {
                                self.selectedCoupon = response.data.values;
                                self.coupons[i] = self.selectedCoupon;

                            }
                            showToast('success', response.data.message);
                        }
                        self.isDeleting = false;
                    }).catch(function(error){

                    });
                },
                testDate() {
                    console.log(this.startDate, new Date().toISOString().split('T'))
                }

            }
        });
    </script>
    <style>

    </style>
@endsection
@section('footer')
    <script src=" {{asset('assets/admin_styles/js/pages/tables/jquery-datatable.js') }}"></script>
    <script src=" {{asset('assets/admin_styles/bundles/datatablescripts.bundle.js') }}"></script>

@endsection
