@extends('layouts.admin')

@section('content')
    <div id="main-content">

        <div class="row mt-5" id="manage-orders" v-if="apiData">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="header">
                        <h2>Custom Clients: {{$count_un}}</h2>
                        <div class="ml-auto">
                            <div class="user-account">
                                <div class="dropdown" style="float: right">
                                    <a href="javascript:void(0);" class="dropdown-toggle user-name" data-toggle="dropdown">Clients per page: @{{ paginateCustom }}</a>
                                    <ul class="dropdown-menu dropdown-menu-right account animated flipInY">
                                        <li><a href="javascript:void(0);" v-on:click="changePagCustom(15)">15</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePagCustom(30)">30</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePagCustom(45)">45</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePagCustom(60)">60</a></li>
                                    </ul>
                                </div>
                            </div>
                            <button class="btn btn-dark" :disabled="apiDataCustom.prev_page_url === null" v-on:click="prevPageCustom()">
                                Previous Page
                            </button>
                            <button class="btn btn-dark" :disabled="apiDataCustom.next_page_url === null" v-on:click="nextPageCustom()">
                                Next Page
                            </button>
                            <input type="text" placeholder="Search User, email, id..." class="form-control" v-model="searchCustom" v-on:keyUp="getClientsCustom()" style="width: auto !important; display: initial !important;">

                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive" v-if="clientsCustom.length > 0">
                            <table class="table table-hover m-b-0 text-center">
                                <thead class="thead-dark">
                                <tr>
{{--                                    <th>No.</th>--}}
                                    <th>User</th>
                                    <th>Address</th>
                                    <th>Address 2</th>
                                    <th>City</th>
                                    <th>Zip</th>
                                    <th>State</th>
                                    <th>Post</th>
                                    <th>Post 2</th>
                                    <th>Email</th>
                                    <th>Telephone</th>
                                    <th>Facebook</th>
                                    <th>Payer</th>
                                    <th>Payment Method</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(client, i) in clientsCustom">
{{--                                    <td>@{{ i+1 }}</td>--}}
                                    <td><span>@{{ client.name }}</span></td>
                                    <td><span>@{{ client.address }}</span></td>
                                    <td><span>@{{ client.address_2 }}</span></td>
                                    <td><span>@{{ client.city }}</span></td>
                                    <td><span>@{{ client.postal }}</span></td>
                                    <td><span>@{{ client.state }}</span></td>
                                    <td><span>@{{ client.post }}</span></td>
                                    <td><span>@{{ client.post_2 }}</span></td>
                                    <td><span>@{{ client.email }}</span></td>
                                    <td><span>@{{ client.telephone }}</span></td>
                                    <td><span>@{{ client.fb_pseudo }}</span></td>
                                    <td><span>@{{ client.payer_name }}</span></td>
                                    <td><span>@{{ client.payment_method}}</span></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div v-else>
                            <h1 class="text-center" style="font-style: italic;">No clients available.</h1>
                        </div>
                        <form action="/admin/importClients" method="POST" enctype="multipart/form-data" class="mt-2">
                            @csrf
                            <input type="file" name="file" class="form-control" v-model="selectedFile">
                            <br>
                            <button class="btn btn-success" :disabled="!selectedFile">Import Clients Data</button>
                            <a class="btn btn-warning" href="/admin/exportClients">Export Clients Data</a>
                            <a class="btn btn-warning" href="/admin/exampleExcel">Get Example CSV</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-5" id="manage-orders" v-if="apiData">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="header">
                        <h2>Registered Clients: {{$count}}</h2>

                        <div class="ml-auto">
                            <div class="user-account">
                                <div class="dropdown" style="float: right">
                                    <a href="javascript:void(0);" class="dropdown-toggle user-name" data-toggle="dropdown">Clients per page: @{{ paginate }}</a>
                                    <ul class="dropdown-menu dropdown-menu-right account animated flipInY">
                                        <li><a href="javascript:void(0);" v-on:click="changePag(15)">15</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(30)">30</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(45)">45</a></li>
                                        <li class="divider"></li>
                                        <li><a href="javascript:void(0);" v-on:click="changePag(60)">60</a></li>
                                    </ul>
                                </div>
                            </div>
                            <button class="btn btn-dark" :disabled="apiData.prev_page_url === null" v-on:click="prevPage()">
                                Previous Page
                            </button>
                            <button class="btn btn-dark" :disabled="apiData.next_page_url === null" v-on:click="nextPage()">
                                Next Page
                            </button>
                            <input type="text" placeholder="Search User, email, id..." class="form-control" v-model="search" v-on:keyUp="getClients()" style="width: auto !important; display: initial !important;">

                        </div>
                    </div>
                    <div class="body">
                        <div class="table-responsive" v-if="clients.length > 0">
                            <table class="table table-hover m-b-0 text-center">
                                <thead class="thead-dark">
                                <tr>
                                    <th>Id</th>
                                    <th>User</th>
                                    <th>Address</th>
                                    <th>City</th>
                                    <th>Zip</th>
                                    <th>Email</th>
                                    <th>Telephone</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(client, i) in clients">
                                    <td>@{{ client.id }}</td>
                                    <td><span>@{{ client.name }}</span></td>
                                    <td><span>@{{ client.address }}</span></td>
                                    <td><span>@{{ client.city }}</span></td>
                                    <td><span>@{{ client.zip }}</span></td>
                                    <td><span>@{{ client.email }}</span></td>
                                    <td><span>@{{ client.tel }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div v-else>
                            <h1 class="text-center" style="font-style: italic;">No clients available.</h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Products Modal -->
{{--        <div class="modal fade" id="showProducts" tabindex="-1" role="dialog">--}}
{{--            <div class="modal-dialog modal-lg" role="document">--}}
{{--                <div class="modal-content">--}}
{{--                    --}}{{--                    <div class="modal-header">--}}
{{--                    --}}{{--                        <h4 class="title text-center" id="largeModalLabel">Order Products</h4>--}}
{{--                    --}}{{--                    </div>--}}
{{--                    <div v-if="modProducts.length > 0">--}}
{{--                        <div class="table-responsive">--}}
{{--                            <table class="table table-hover m-b-0 text-center">--}}
{{--                                <thead class="thead-dark">--}}
{{--                                <tr>--}}
{{--                                    <th>no</th>--}}
{{--                                    <th>Product</th>--}}
{{--                                    <th>Size</th>--}}
{{--                                    <th>Color</th>--}}
{{--                                    <th>Quantity</th>--}}
{{--                                    <th>Price</th>--}}
{{--                                    <th>Total</th>--}}
{{--                                </tr>--}}
{{--                                </thead>--}}
{{--                                <tbody>--}}
{{--                                <tr  v-for="(p, i) in modProducts">--}}
{{--                                    <td>@{{ i+1 }}</td>--}}
{{--                                    <td><span>@{{ p.product.title }}</span></td>--}}
{{--                                    <td><span>@{{ p.size.size }}</span></td>--}}
{{--                                    <td><span>@{{ p.color.color }}</span></td>--}}
{{--                                    <td><span>@{{ p.quantity }}</span></td>--}}
{{--                                    <td><span>@{{ p.product.price }}</span></td>--}}
{{--                                    <td><span>@{{ p.product.price * p.quantity }}</span></td>--}}
{{--                                </tr>--}}
{{--                                </tbody>--}}
{{--                            </table>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
    </div>



@endsection
@section('footer')
    <script>
        const Vue_comp = new Vue({
            el:"#main-content",
            data: {
                clients: [],
                clientsCustom: [],
                apiData: null,
                apiDataCustom: null,
                changePage: false,
                changePageCustom: false,
                link: 'admin/getClients',
                linkCustom: 'admin/getClientsCustom',
                paginate: 30,
                paginateCustom: 15,
                modProducts: [],
                search: '',
                searchCustom: '',
                orderLoading: 0,
                selectedFile: null
            },
            created() {
                this.getClients();
                this.getClientsCustom();
            },
            methods: {
                capitalizeFirstLetter(string) {
                    return string.charAt(0).toUpperCase() + string.slice(1);
                },
                dateStr(d) {
                    // return new Date(d).toDateString();
                    return moment(d).format('DD MMM, YYYY');
                },
                getClients() {
                    const self = this;
                    axios.post(this.link, {number: this.paginate, search: this.search}, {
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        // console.log('Clients', response)
                        if (response.data.status) {
                            self.apiData = response.data.values;
                            self.clients = self.apiData.data;
                        }
                        this.changePage = false;
                    }).catch(function(error){
                        this.changePage = false;
                    });
                },
                getClientsCustom() {
                    const self = this;
                    axios.post(this.linkCustom, {number: this.paginateCustom, search: this.searchCustom}, {
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        console.log('ClientsCustom', response)
                        if (response.data.status) {
                            self.apiDataCustom = response.data.values;
                            self.clientsCustom = self.apiDataCustom.data;
                        }
                        this.changePageCustom = false;
                    }).catch(function(error){
                        this.changePageCustom = false;
                    });
                },
                prevPage() {
                    if (this.apiData && this.apiData.prev_page_url) {
                        // this.changePage = true;
                        this.link = this.apiData.prev_page_url;
                        this.getClients();
                    }
                },
                nextPage() {
                    if (this.apiData && this.apiData.next_page_url) {
                        // this.changePage = true;
                        this.link = this.apiData.next_page_url;
                        this.getClients();
                    }
                },
                prevPageCustom() {
                    if (this.apiDataCustom && this.apiDataCustom.prev_page_url) {
                        // this.changePage = true;
                        this.linkCustom = this.apiDataCustom.prev_page_url;
                        this.getClientsCustom();
                    }
                },
                nextPageCustom() {
                    if (this.apiDataCustom && this.apiDataCustom.next_page_url) {
                        // this.changePage = true;
                        this.linkCustom = this.apiDataCustom.next_page_url;
                        this.getClientsCustom();
                    }
                },
                changePag(val) {
                    this.paginate = val;
                    this.getClients();
                },
                changePagCustom(val) {
                    this.paginateCustom = val;
                    this.getClientsCustom();
                },
                modalProds(order) {
                    this.modProducts = order.items;
                }
            }
        });
    </script>
@endsection
