@extends('layouts.admin')
@section('otherStyles')
    <link rel="stylesheet" href="{{ asset('assets/admin_styles/vendor/jquery-datatable/dataTables.bootstrap4.min.css') }}">
@endsection

@section('content')
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="/admin"><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item active">Manage Categories</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="accordion" id="accordion">
                                        <div>
                                            <div class="card-header" id="headingOne" style="background: #fff;">
                                                <h5 class="mb-2">
                                                    <div class="align-items-center">
                                                        <ul class="list-unstyled text-center team-info margin-0" style="background: #fff;">
                                                            <li class="text-center" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                                Category
                                                                <img src="{{asset('plus.svg')}}"
                                                                 data-original-title="Add Category">
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </h5>
                                            </div>
                                            <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
                                                <div class="row mt-2">
                                                    <div class="col-lg-4 col-md-2 col-sm-9">
                                                        <div class="form-group">
                                                            <label>Category</label>
                                                            <input type="text" class="form-control" v-model="newCategory" >
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-2">
                                                        <div class="form-group">
                                                            <label>Order</label>
                                                            <input type="number" class="form-control" v-model="catOrder" >
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-6 col-sm-12 text-center" data-toggle="tooltip" data-original-title="Category Icon" data-placement="bottom">
                                                        <el-upload
                                                            class="avatar-uploader"
                                                            action=""
                                                            :auto-upload=false
                                                            :show-file-list=false
                                                            :on-change="handlePreview"
                                                            :on-remove="handleRemove">
                                                            <img v-if="imageUrl" :src="imageUrl" class="avatar">
                                                            <i v-else class="el-icon-plus avatar-uploader-icon"></i>
                                                        </el-upload>
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-12" v-if="!isAdding">
                                                        <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-if="catId === 0" @click="submitCategory()">Add Category</a>
                                                        <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-else @click="submitCategory()">Save Category</a>
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-12" v-else>
                                                        <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-if="catId === 0" disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Adding...</a>
                                                        <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Saving...</a>
                                                    </div>
                                                </div>
                                                <div class="row" v-if="catId !== 0">
                                                    <div class="col-lg-6 col-md-6 col-sm-12">
                                                        <a class="btn btn-warning" style="color: #fff0ff; width: 100%;" @click="clearSelection()">Clear</a>
                                                    </div>
                                                    <div class="col-lg-6 col-md-6 col-sm-12">
                                                        <div  v-if="selectedCategory.status == 1">
                                                            <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" @click="deleteCategory()" v-if="!isDeleting">Deactivate</a>
                                                            <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                                Deactivating...</a>
                                                        </div>
                                                        <div v-else>
                                                            <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" @click="deleteCategory()" v-if="!isDeleting">Delete</a>
                                                            <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                                Deleting...</a>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mt-2" v-if="selectedCategory.status == 0">
                                                        <a class="btn btn-success" style="color: #fff0ff; width: 100%;" @click="activateCategory()" v-if="!isActivating">Activate</a>
                                                        <a class="btn btn-success" style="color: #fff0ff; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Activating...</a>
                                                    </div>
                                                </div>
                                                <hr>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row clearfix" v-if="categories.length > 0">
                                <div class="col-lg-12">
                                    <div class="card">
                                        <div class="body">
                                            <div class="table-responsive">
                                                <table class="table table-hover js-basic-example dataTable table-custom">
                                                    <thead>
                                                    <tr>
                                                        <th>Icon</th>
                                                        <th>Product</th>
                                                        <th>Order</th>
                                                        <th>Status</th>
                                                        <th>Select</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(cat, i) in categories" >
                                                        <td><img :src="cat.icon" alt="img" class="img-fluid" style="height: 40px"></td>
                                                        <td>@{{ cat.title }}</td>
                                                        <td>@{{ cat.ordered_by }}</td>
                                                        <td><span class="badge badge-success" v-if="cat.status == 1">Active</span><span class="badge badge-danger" v-else>Inactive</span></td>
                                                        <td><a class="btn btn-primary" style="color: #fff0ff" @click="selectCat(cat)">Select Category</a></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-6" v-if="catId == 0">
                    <div class="card blur-card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="accordion" id="accordionSub">
                                        <div>
                                            <div class="card-header" id="headingOne" style="background: #fff;">
                                                <h5 class="mb-2">
                                                    <div class="align-items-center">
                                                        <ul class="list-unstyled text-center team-info margin-0" style="background: #fff;">
                                                            <li class="text-center">
                                                                Subcategory
                                                                <img src="{{asset('plus.svg')}}"
                                                                     data-original-title="Add Subcategory">
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </h5>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <p class="text-on-top">Select a category so you can edit subcategories for it.</p>
                </div>

                <div v-else class="col-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="accordion" id="accordionSub">
                                        <div>
                                            <div class="card-header" id="headingOne" style="background: #fff;">
                                                <h5 class="mb-2">
                                                    <div class="align-items-center">
                                                        <ul class="list-unstyled text-center team-info margin-0" style="background: #fff;">
                                                            <li class="text-center" data-toggle="collapse" data-target="#collapseSub" aria-expanded="true" aria-controls="collapseSub">
                                                                Subcategory
                                                                <img src="{{asset('plus.svg')}}"
                                                                     data-original-title="Add Subcategory">
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </h5>
                                            </div>
                                            <div id="collapseSub" class="collapse" aria-labelledby="headingOne" data-parent="#accordionSub">
                                                <div class="row mt-2">
                                                    <div class="col-lg-6 col-md-6 col-sm-11">
                                                        <div class="form-group">
                                                            <label>Sub Category</label>
                                                            <input type="text" class="form-control" v-model="newSubCategory">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6 col-md-6 col-sm-12" v-if="!isAddingSub">
                                                        <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" @click="submitSubCategory()" v-if="subId == 0">Add Subcategory</a>
                                                        <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" @click="submitSubCategory()" v-else>Save Subcategory</a>
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-12" v-else>
                                                        <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-if="subId == 0" disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Adding...</a>
                                                        <a class="btn btn-dark" style="color: #fff0ff; margin-top: 1.8rem !important; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Saving...</a>
                                                    </div>
                                                </div>
                                                <div class="row" v-if="subId !== 0">
                                                    <div class="col-lg-6 col-md-6 col-sm-12">
                                                        <a class="btn btn-warning" style="color: #fff0ff; width: 100%;" @click="clearSubSelection()">Clear</a>
                                                    </div>
                                                    <div class="col-lg-6 col-md-6 col-sm-12" v-if="!isDelSub">
                                                        <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" @click="deleteSubCat()" v-if="selectedSubCat.status == 1">Deactivate</a>
                                                        <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" @click="deleteSubCat()" v-else>Delete</a>
                                                    </div>
                                                    <div class="col-lg-6 col-md-6 col-sm-12" v-else>
                                                        <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" disabled v-if="selectedSubCat.status == 1"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Deactivating...</a>
                                                        <a class="btn btn-danger" style="color: #fff0ff; width: 100%;" disabled  v-else><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Deleting...</a>
                                                    </div>
                                                    <div class="col-12 mt-2" v-if="selectedSubCat.status == 0">
                                                        <a class="btn btn-success" style="color: #fff0ff; width: 100%;" @click="activateSubCat()" v-if="!isActSub">Activate</a>
                                                        <a class="btn btn-success" style="color: #fff0ff; width: 100%;" v-else disabled><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" disabled></span>
                                                            Activating...</a>
                                                    </div>
                                                </div>
                                                <hr>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row clearfix" v-if="subCategories.length > 0">
                                <div class="col-lg-12">
                                    <div class="card">
                                        <div class="body">
                                            <div class="table-responsive">
                                                <table class="table table-hover js-basic-example dataTable table-custom">
                                                    <thead>
                                                    <tr>
                                                        <th>Product</th>
                                                        <th>Status</th>
                                                        <th>Select</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(subCat, i) in subCategories" >
                                                        <td>@{{ subCat.title }}</td>
                                                        <td><span class="badge badge-success" v-if="subCat.status == 1">Active</span><span class="badge badge-danger" v-else>Inactive</span></td>
                                                        <td><a class="btn btn-primary" style="color: #fff0ff" @click="selectSubCat(subCat)">Select Subcategory</a></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footer')
    <style>
        .avatar-uploader .el-upload {
            margin-top: 1.6rem;
            border: 1px dashed #d9d9d9;
            border-radius: 6px;
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }
        .avatar-uploader .el-upload:hover {
            border-color: #409EFF;
        }
        .avatar-uploader-icon {
            font-size: 28px;
            color: #8c939d;
            width: 40px;
            height: 40px;
            line-height: 40px;
            text-align: center;
        }
        .avatar {
            width: 40px;
            height: 40px;
            display: block;
        }
        .blur-card {
            filter: blur(4px);
        }
        .text-on-top {
            position: absolute;
            top: 27px;
            width: 100%;
            text-align: center;
            font-weight: 500;
            font-size: 1.25rem;
        }
    </style>
    <script>

        const Vue_comp = new Vue({
            el:"#main-content",
            data: {
                newCategory: '', newSubCategory: '',
                catOrder: 1,
                categories: [], subCategories: [],
                selectedCategory: null, selectedSubCat: null,
                catId: 0, subId: 0,
                imageUrl: '',
                file: null,
                isActivating: false, isAdding: false, isDeleting: false,
                isAddingSub: false, isActSub: false, isDelSub: false
            },
            created() {
                const self = this;
                axios.post( 'api/V1/getAllCategories',{}, {
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{csrf_token()}}'
                        },
                    }
                ).then(function(response){
                    self.categories = response.data.values;
                    console.log('categories', response.data);
                    // if(self.banners.length > 0){
                    //     $.each(self.banners,function (index,value){
                    //         self.fileList.push({name: 'banner', url: value.image});
                    //         self.bnrDesc.push(value.description);
                    //         self.prodIds.push(value.prod_id);
                    //     })
                    // }
                }).catch(function(error){});
            },
            methods: {
                selectCat(cat) {
                  this.catId = cat.id;
                  this.newCategory = cat.title;
                  this.imageUrl = cat.icon;
                  this.catOrder = cat.ordered_by;
                  this.selectedCategory = cat;
                  this.subCategories = cat.sub_categories;
                  let acc = $('#collapseOne');
                  acc.collapse('show');
                  this.clearSubSelection();
                },
                selectSubCat(subCat) {
                    this.subId = subCat.id;
                    this.newSubCategory = subCat.title;
                    this.selectedSubCat = subCat;
                    let acc = $('#collapseSub');
                    acc.collapse('show');
                },
                clearSelection() {
                    this.catId = 0;
                    this.newCategory = '';
                    this.imageUrl = '';
                },
                handleRemove(file, fileList) {
                    this.imageUrl = '';
                    this.file = null;
                },
                handlePreview(file) {
                    this.imageUrl = URL.createObjectURL(file.raw);
                    this.file = file;
                    console.log('file', file);
                    console.log('img', this.imageUrl);
                },
                submitCategory(){
                    const self = this;
                    let formData = new FormData();
                    self.isAdding = true;
                    if (self.file) {
                        if (self.file.raw === undefined) {
                            formData.append('image', self.file.url);
                            console.log("here");
                        } else {
                            formData.append('image', self.file.raw);
                            console.log("there");
                        }
                    }
                    // console.log(formData.getAll("image"));
                    formData.append('category', self.newCategory);
                    formData.append('ordered_by', self.catOrder);
                    axios.defaults.headers.post['Content-Type'] = 'multipart/form-data';
                    axios.post( '/admin/addCategory/' + self.catId, formData, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        if (response.data.status) {
                            axios.post( 'api/V1/getAllCategories',{}, {
                                    headers: {
                                        'Content-Type': 'application/json',
                                        'X-CSRF-TOKEN': '{{csrf_token()}}'
                                    },
                                }
                            ).then(function(response1){
                                self.categories = response1.data.values;
                                self.selectedCategory = response.data.values;
                                self.catId = self.selectedCategory.id;
                                self.newCategory = self.selectedCategory.title;
                                self.imageUrl = self.selectedCategory.icon;
                                showToast('success', response.data.message);
                                // console.log('categories', response1.data);
                            }).catch(function(error){});

                        } else {
                            showToast('warning', response.data.message);
                        }
                        self.isAdding = false;
                    }).catch(function(error){
                        self.isAdding = false;
                    });
                },
                activateCategory() {
                    const self = this;
                    self.isActivating = true;
                    axios.post( '/admin/activateCategory/' + self.catId, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        if (response.data.status) {
                            let cat = self.categories.indexOf(self.selectedCategory);
                            self.selectedCategory = response.data.values;
                            self.categories[cat] = response.data.values;
                            self.subCategories = self.selectedCategory.sub_categories;
                            showToast('success', response.data.message);
                        }
                        self.isActivating = false;
                    }).catch(function(error){
                        self.isActivating = false;
                    });
                },
                deleteCategory() {
                    const self = this;
                    self.isDeleting = true
                    axios.post( '/admin/deleteCategory/' + self.catId, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        if (response.data.status) {
                            let c = self.categories.indexOf(self.selectedCategory);
                            if (response.data.values == null) {
                                self.categories.splice(c, 1);
                                self.clearSelection();
                                self.subCategories = [];
                            } else {
                                self.selectedCategory = response.data.values;
                                self.categories[c] = self.selectedCategory;
                                self.subCategories = self.selectedCategory.sub_categories;

                            }
                            showToast('success', response.data.message);
                        }
                        self.isDeleting = false;
                    }).catch(function(error){

                    });
                },
                submitSubCategory() {
                    const self = this;
                    let formData = new FormData();
                    self.isAddingSub = true;
                    formData.append('sub_category', self.newSubCategory);
                    axios.post( '/admin/addSubCategory/' + self.catId + '/' + self.subId, formData, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        console.log(response);
                        if (response.data.status) {
                            console.log(response);
                            let cat = self.categories.indexOf(self.selectedCategory);
                            if (self.subId == 0) {
                                self.subCategories.push(response.data.values);
                            } else {
                                let sub = self.subCategories.indexOf(self.selectedSubCat);
                                self.subCategories[sub] = response.data.values;
                            }
                            self.categories[cat].sub_categories = self.subCategories;
                            self.selectedSubCat = response.data.values;
                            self.subId = self.selectedSubCat.id;
                            self.newSubCategory = self.selectedSubCat.title;
                            showToast('success', response.data.message);
                        } else {
                            showToast('warning', response.data.message);

                        }
                        self.isAddingSub = false;
                    }).catch(function(error){

                    });
                },
                deleteSubCat() {
                    const self = this;
                    self.isDelSub = true
                    axios.post( '/admin/deleteSubCategory/' + self.subId, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        if (response.data.status) {
                            let s = self.subCategories.indexOf(self.selectedSubCat);
                            let c = self.categories.indexOf(self.selectedCategory);

                            if (response.data.values == null) {
                                self.subCategories.splice(s, 1);
                                self.clearSubSelection();
                                self.selectedCategory.sub_categories = self.subCategories;
                            } else {
                                self.selectedSubCat = response.data.values;
                                self.subCategories[s] = self.selectedSubCat;
                                self.categories[c].sub_categories = self.subCategories;
                            }
                            showToast('success', response.data.message);
                        }
                        self.isDelSub = false;
                    }).catch(function(error){

                    });
                },
                activateSubCat() {
                    const self = this;
                    self.isActSub = true;
                    axios.post( '/admin/activateSubCategory/' + self.subId, {
                            headers: {
                                'X-CSRF-TOKEN': '{{csrf_token()}}'
                            },
                        }
                    ).then(function(response){
                        if (response.data.status) {
                            let c = self.categories.indexOf(self.selectedCategory);
                            let s = self.subCategories.indexOf(self.selectedSubCat);
                            self.selectedSubCat = response.data.values;
                            self.subCategories[s] = response.data.values;
                            self.categories[c].sub_categories = self.subCategories;
                            showToast('success', response.data.message);
                        }
                        self.isActSub = false;
                    }).catch(function(error){

                    });
                },
                clearSubSelection() {
                    this.subId = 0;
                    this.newSubCategory = '';
                    this.selectedSubCat = null;
                }

            }
        });
    </script>
    <style>

    </style>
@endsection
@section('footer')
    <script src=" {{asset('assets/admin_styles/js/pages/tables/jquery-datatable.js') }}"></script>
    <script src=" {{asset('assets/admin_styles/bundles/datatablescripts.bundle.js') }}"></script>

@endsection
