import { Subject } from 'rxjs';
import axios from 'axios';
const storage = window.localStorage;

export const countWishProdsVar = new Subject()
export const countCartProdsVar = new Subject()
export const searchListenerVar = new Subject()
export const minValueSlider = new Subject()


class Store {
    /**
     * Creates instance of store on the top of localStorage
     * @param storeId {String} - id to store items inside localStorage
     * @param migrations {Array} - array of migrations to apply.
     *   Every migration should have "isApplicable" and "apply" functions
     */

    constructor(storeId, migrations = []) {
        this.storeId = storeId;

        const initialState = this.get();
        if (!initialState) {
            this.set({
                wishList: [],
                cart: [],
                loggedUser: [],
                updatedGuest:[],
                categories: [],
                userToken: null,
                url: null,
                base_url: null,
                quantity: 1,
                total:0,
                search:'',
                currency: 'MKD'
            })
            this.publishWishCount(0);
            this.publishCartCount(0);
            this.publishSearch('');
        } else {
            this.publishWishCount(initialState.wishList.length);
            this.publishCartCount(initialState.cart.length);
            this.publishSearch(initialState.search);
        }
    }
    api_post_call(link, params) {
        const storeData = this.get();
        params.token = storeData.userToken;
        return new Promise ((resolve, reject) => {
            axios.post(storeData.url + link, params).then(res => {
                resolve(res);
            }).catch(err => {
                if(err.status === 401) {

                }
                reject(err);
            })
        })

    }

    api_get_call(link, params) {
        const storeData = this.get();
        params.token = storeData.userToken;
        return new Promise ((resolve, reject) => {
            axios.get(storeData.url + link, params).then(res => {
                resolve(res);
            }).catch(err => {
                if(err.status === 401) {

                }
                reject(err);
            })
        })

    }

    api_post_call_wl(link, params) {
        const storeData = this.get();
        params.token = storeData.userToken;
        return new Promise ((resolve, reject) => {
            axios.post(link, params).then(res => {
                resolve(res);
            }).catch(err => {
                if(err.status === 401) {

                }
                reject(err);
            })
        })

    }

    set(data) {
        data = {
            ...this.get(),
            ...data,
        };
        console.log('setting in store:', data);
        storage.setItem(this.storeId, JSON.stringify(data));
    }
    publishWishCount(data) {
        countWishProdsVar.next(data)
    }

    publishCartCount(data) {
        countCartProdsVar.next(data)
    }

    publishSearch(data) {
        let data2 = this.get();
        data2.search = data;
        storage.setItem(this.storeId, JSON.stringify(data2));
        searchListenerVar.next(data)
    }


    publishMinValue(data) {
        minValueSlider.next(data)
    }


    editProduct(product, index) {
        let data = this.get();
        data.cart[index] = product;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }

    deleteCartProduct(index){
        let data = this.get();
        data.cart.splice(index, 1);
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
        // this.setState({wishListProds: data.wishlistProds});
    }


    addToWishListProduct(product, index){
        let data = this.get();
        if(typeof product.quantity =='undefined'){
            product.quantity = 1;
        }else{
            product.quantity = product.quantity;
        }


        let itemFound = false;
        data.wishList.map(function(item){
            if(item.id == product.id){
                itemFound = true;
                item.quantity = item.quantity + product.quantity;
                item.totalPrice = item.totalPrice + product.totalPrice;
            }
        });

        if(!itemFound){
            data.wishList.push(product);
        }
        this.publishWishCount(data.wishList.length);
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }

    addToCartProductOnCLick(product, index){
        let data = this.get();
        if(typeof product.quantity =='undefined'){
            product.quantity = 1;
        }else{
            product.quantity = product.quantity;
        }
        let itemFound = false;
        data.cart.map(function(item){
            if(item.id == product.id){
                itemFound = true;
                item.quantity = item.quantity + product.quantity;
                item.totalPrice = item.totalPrice + product.totalPrice;
            }
        });

        if(!itemFound){
            data.cart.push(product);
        }
        this.publishCartCount(data.cart.length);
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }

    addToCartProduct(product, index){
        let data = this.get();
        data.cart.push(product);
        data.wishList.splice(index, 1);
        this.publishWishCount(data.wishList.length);
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }

    saveToken(token){
        let data = this.get();
        data.userToken = token;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();

    }

    setCurrency(currency){
        let data = this.get();
        data.currency = currency;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }


    setQuantity(quantity){
        let data = this.get();
        data.quantity = quantity;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }

    setTotal(total){
        let data = this.get();
        data.total = total;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }

    setUrl(url){
        let data = this.get();
        data.url = url;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();

    }
    setBaseUrl(url){
        let data = this.get();
        data.base_url = url;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();

    }

    saveLoggedUser(user){
        let data = this.get();
        data.loggedUser = user;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }
    saveGuest(guest){
        console.log('guest----',guest);
        let data = this.get();
        data.updatedGuest = guest;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }

    saveCategories(categ){
        let data = this.get();
        data.categories = categ;
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
    }

    countCart() {
        let data = this.get();
        return data.cart.length;
    }


    countWish() {
        let data = this.get();
        return data.wishList.length;
    }

    deleteWishProduct(index){
        let data = this.get();
        data.wishList.splice(index, 1);
        this.publishWishCount(data.wishList.length);
        storage.setItem(this.storeId, JSON.stringify(data));
        return this.get();
        // this.setState({wishListProds: data.wishlistProds});
    }

    get() {
        const rawData = storage.getItem(this.storeId);
        const data = JSON.parse(rawData);
        return data;
    }

    countWishProds() {
        let data = this.get();
        let counterWish = data.wishList.length;
        console.log('wishLisklength', counterWish);

        return counterWish;
    }

    countCartProds() {
        let data = this.get();
        let counterCart = data.cart.length;
        console.log('cartcount', counterCart);

        return counterCart;
    }
    calculateCurrencies(ob, val) {
        console.log('here in here', ob, val)
        let current = this.get().currency;
        if (current === 'MKD') {
            let ret = parseFloat(val)*ob.mkd;
            ret = ret.toFixed(2);
            return ret.toString() + ' MKD';
        } else if (current === 'Euro') {
            let ret = parseFloat(val)*ob.eur;
            ret = ret.toFixed(2);
            return ret.toString() + ' €';
        } else if (current === 'Lek') {
            let ret = parseFloat(val)*ob.lek;
            ret = ret.toFixed(2);
            return ret.toString() + ' LEK';
        }
    }
    clearSession() {
        this.set({
            wishList: [],
            cart: [],
            loggedUser: [],
            categories: [],
            userToken: null,
            url: null,
            base_url: null,
            quantity: 1,
            total:0,
            search:''
        })
        this.publishWishCount(0);
        this.publishCartCount(0);
        this.publishSearch('');
    }


}

export default Store
